/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import dev.restate.generated.service.discovery.Discovery;
import dev.restate.sdk.common.Service;
import dev.restate.sdk.core.RestateGrpcServer;
import dev.restate.sdk.lambda.RestateLambdaEndpoint;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.opentelemetry.api.OpenTelemetry;
import java.util.Arrays;

public final class RestateLambdaEndpointBuilder {
    private final RestateGrpcServer.Builder restateGrpcServerBuilder = RestateGrpcServer.newBuilder((Discovery.ProtocolMode)Discovery.ProtocolMode.REQUEST_RESPONSE);
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();

    public RestateLambdaEndpointBuilder withService(Service service, ServerInterceptor ... interceptors) {
        ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)service, Arrays.asList(interceptors));
        this.restateGrpcServerBuilder.withService(definition);
        return this;
    }

    public RestateLambdaEndpointBuilder withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        return this;
    }

    public RestateLambdaEndpoint build() {
        return new RestateLambdaEndpoint(this.restateGrpcServerBuilder.build(), this.openTelemetry);
    }
}

