/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.http.vertx;

import dev.restate.sdk.auth.RequestIdentityVerifier;
import dev.restate.sdk.common.BindableService;
import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.core.manifest.DeploymentManifestSchema;
import dev.restate.sdk.http.vertx.RequestHttpServerHandler;
import io.opentelemetry.api.OpenTelemetry;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestateHttpEndpointBuilder {
    private static final Logger LOG = LogManager.getLogger(RestateHttpEndpointBuilder.class);
    private final Vertx vertx;
    private final RestateEndpoint.Builder endpointBuilder = RestateEndpoint.newBuilder((DeploymentManifestSchema.ProtocolMode)DeploymentManifestSchema.ProtocolMode.BIDI_STREAM);
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();
    private HttpServerOptions options = new HttpServerOptions().setPort(Optional.ofNullable(System.getenv("PORT")).map(Integer::parseInt).orElse(9080).intValue());

    private RestateHttpEndpointBuilder(Vertx vertx) {
        this.vertx = vertx;
    }

    public static RestateHttpEndpointBuilder builder() {
        return new RestateHttpEndpointBuilder(Vertx.vertx());
    }

    public static RestateHttpEndpointBuilder builder(Vertx vertx) {
        return new RestateHttpEndpointBuilder(vertx);
    }

    public RestateHttpEndpointBuilder withOptions(HttpServerOptions options) {
        this.options = Objects.requireNonNull(options);
        return this;
    }

    public RestateHttpEndpointBuilder bind(Object service) {
        return this.bind(RestateEndpoint.discoverBindableServiceFactory((Object)service).create(service));
    }

    public RestateHttpEndpointBuilder bind(BindableService<?> service) {
        for (ServiceDefinition serviceDefinition : service.definitions()) {
            this.endpointBuilder.bind(serviceDefinition, service.options());
        }
        return this;
    }

    public <O> RestateHttpEndpointBuilder bind(BindableService<O> service, O options) {
        for (ServiceDefinition serviceDefinition : service.definitions()) {
            this.endpointBuilder.bind(serviceDefinition, options);
        }
        return this;
    }

    public RestateHttpEndpointBuilder withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        return this;
    }

    public RestateHttpEndpointBuilder withRequestIdentityVerifier(RequestIdentityVerifier requestIdentityVerifier) {
        this.endpointBuilder.withRequestIdentityVerifier(requestIdentityVerifier);
        return this;
    }

    public void buildAndListen(int port) {
        this.build().listen(port).onComplete(RestateHttpEndpointBuilder::handleStart);
    }

    public void buildAndListen() {
        this.build().listen().onComplete(RestateHttpEndpointBuilder::handleStart);
    }

    public HttpServer build() {
        HttpServer server = this.vertx.createHttpServer(this.options);
        this.endpointBuilder.withTracer(this.openTelemetry.getTracer("restate-java-sdk-vertx"));
        server.requestHandler((Handler)new RequestHttpServerHandler(this.endpointBuilder.build(), this.openTelemetry));
        return server;
    }

    private static void handleStart(AsyncResult<HttpServer> ar) {
        if (ar.succeeded()) {
            LOG.info("Restate HTTP Endpoint server started on port " + ((HttpServer)ar.result()).actualPort());
        } else {
            LOG.error("Restate HTTP Endpoint server start failed", ar.cause());
        }
    }
}

