/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.http.vertx;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.ResolvedEndpointHandler;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.core.manifest.DeploymentManifestSchema;
import dev.restate.sdk.http.vertx.HttpRequestFlowAdapter;
import dev.restate.sdk.http.vertx.HttpResponseFlowAdapter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.reactiverse.contextual.logging.ContextualData;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

class RequestHttpServerHandler
implements Handler<HttpServerRequest> {
    private static final Logger LOG = LogManager.getLogger(RequestHttpServerHandler.class);
    private static final AsciiString APPLICATION_RESTATE = AsciiString.cached((String)"application/restate");
    private static final AsciiString X_RESTATE_SERVER_KEY = AsciiString.cached((String)"x-restate-server");
    private static final AsciiString X_RESTATE_SERVER_VALUE = AsciiString.cached((String)"restate-sdk-java/0.9.1_c426b413");
    private static final ObjectMapper MANIFEST_OBJECT_MAPPER = new ObjectMapper();
    private static final Pattern SLASH = Pattern.compile(Pattern.quote("/"));
    private static final String DISCOVER_PATH = "/discover";
    static TextMapGetter<MultiMap> OTEL_TEXT_MAP_GETTER = new TextMapGetter<MultiMap>(){

        public Iterable<String> keys(MultiMap carrier) {
            return carrier.names();
        }

        public @Nullable String get(@Nullable MultiMap carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.get(key);
        }
    };
    private final RestateEndpoint restateEndpoint;
    private final OpenTelemetry openTelemetry;

    RequestHttpServerHandler(RestateEndpoint restateEndpoint, OpenTelemetry openTelemetry) {
        this.restateEndpoint = restateEndpoint;
        this.openTelemetry = openTelemetry;
    }

    public void handle(HttpServerRequest request) {
        ResolvedEndpointHandler handler;
        URI uri = URI.create(request.uri());
        if (DISCOVER_PATH.equalsIgnoreCase(uri.getPath())) {
            this.handleDiscoveryRequest(request);
            return;
        }
        String[] pathSegments = SLASH.split(uri.getPath());
        if (pathSegments.length < 3) {
            LOG.warn("Path doesn't match the pattern /invoke/ServiceName/HandlerName nor /discover: '{}'", (Object)request.path());
            request.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            return;
        }
        String serviceName = pathSegments[pathSegments.length - 2];
        String handlerName = pathSegments[pathSegments.length - 1];
        Context otelContext = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)request.headers(), OTEL_TEXT_MAP_GETTER);
        io.vertx.core.Context vertxCurrentContext = ((HttpServerRequestInternal)request).context();
        try {
            handler = this.restateEndpoint.resolve(serviceName, handlerName, arg_0 -> ((HttpServerRequest)request).getHeader(arg_0), otelContext, ContextualData::put, this.currentContextExecutor(vertxCurrentContext));
        }
        catch (ProtocolException e) {
            LOG.warn("Error when resolving the handler", (Throwable)e);
            request.response().setStatusCode(e.getCode()).end();
            return;
        }
        LOG.debug("Handling request to " + serviceName + "/" + handlerName);
        HttpServerResponse response = request.response();
        response.setStatusCode(HttpResponseStatus.OK.code());
        response.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_RESTATE).putHeader((CharSequence)X_RESTATE_SERVER_KEY, (CharSequence)X_RESTATE_SERVER_VALUE);
        response.setChunked(true);
        HttpRequestFlowAdapter requestFlowAdapter = new HttpRequestFlowAdapter(request);
        HttpResponseFlowAdapter responseFlowAdapter = new HttpResponseFlowAdapter(response);
        requestFlowAdapter.subscribe((Flow.Subscriber<? super InvocationFlow.InvocationInput>)handler.input());
        handler.output().subscribe((Flow.Subscriber)((Object)responseFlowAdapter));
        handler.start();
    }

    private Executor currentContextExecutor(io.vertx.core.Context currentContext) {
        return runnable -> currentContext.runOnContext(v -> runnable.run());
    }

    private void handleDiscoveryRequest(HttpServerRequest request) {
        Buffer responseBuffer;
        DeploymentManifestSchema response = this.restateEndpoint.handleDiscoveryRequest();
        try {
            responseBuffer = Buffer.buffer((byte[])MANIFEST_OBJECT_MAPPER.writeValueAsBytes((Object)response));
        }
        catch (JsonProcessingException e) {
            LOG.warn("Error when writing out the manifest POJO", (Throwable)e);
            request.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
            return;
        }
        request.response().setStatusCode(HttpResponseStatus.OK.code()).putHeader((CharSequence)X_RESTATE_SERVER_KEY, (CharSequence)X_RESTATE_SERVER_VALUE).putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(responseBuffer);
    }
}

