/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.http.vertx;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.MessageHeader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import java.util.ArrayDeque;
import java.util.Queue;

class MessageDecoder {
    private final Queue<InvocationFlow.InvocationInput> parsedMessages = new ArrayDeque<InvocationFlow.InvocationInput>();
    private final ByteBuf internalBuffer = Unpooled.compositeBuffer();
    private State state = State.WAITING_HEADER;
    private MessageHeader lastParsedMessageHeader = null;
    private RuntimeException lastParsingFailure = null;

    MessageDecoder() {
    }

    InvocationFlow.InvocationInput poll() {
        if (this.state == State.FAILED) {
            throw this.lastParsingFailure;
        }
        return this.parsedMessages.poll();
    }

    void offer(Buffer buffer) {
        if (this.state != State.FAILED) {
            this.internalBuffer.writeBytes(buffer.getByteBuf());
            this.tryConsumeInternalBuffer();
        }
    }

    private void tryConsumeInternalBuffer() {
        while (this.state != State.FAILED && this.internalBuffer.readableBytes() >= this.wantBytes()) {
            if (this.state == State.WAITING_HEADER) {
                try {
                    this.lastParsedMessageHeader = MessageHeader.parse((long)this.internalBuffer.readLong());
                    this.state = State.WAITING_PAYLOAD;
                }
                catch (RuntimeException e) {
                    this.lastParsingFailure = e;
                    this.state = State.FAILED;
                }
                continue;
            }
            try {
                this.parsedMessages.offer(InvocationFlow.InvocationInput.of((MessageHeader)this.lastParsedMessageHeader, (MessageLite)((MessageLite)this.lastParsedMessageHeader.getType().messageParser().parseFrom(this.internalBuffer.readBytes(this.lastParsedMessageHeader.getLength()).nioBuffer()))));
                this.state = State.WAITING_HEADER;
            }
            catch (InvalidProtocolBufferException e) {
                this.lastParsingFailure = new RuntimeException("Cannot parse the protobuf message", e);
                this.state = State.FAILED;
            }
            catch (RuntimeException e) {
                this.lastParsingFailure = e;
                this.state = State.FAILED;
            }
        }
    }

    private int wantBytes() {
        if (this.state == State.WAITING_HEADER) {
            return 8;
        }
        return this.lastParsedMessageHeader.getLength();
    }

    private static enum State {
        WAITING_HEADER,
        WAITING_PAYLOAD,
        FAILED;

    }
}

