/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core.manifest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"required", "contentType", "jsonSchema"})
public class Input {
    @JsonProperty(value="required")
    @JsonPropertyDescription(value="If true, a body MUST be sent with a content-type, even if the body length is zero.")
    private Boolean required;
    @JsonProperty(value="contentType")
    @JsonPropertyDescription(value="Content type of the input. It can accept wildcards, in the same format as the 'Accept' header. When this field is unset, it implies emptiness, meaning no content-type/body is expected.")
    private String contentType;
    @JsonProperty(value="jsonSchema")
    private Object jsonSchema;

    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Input withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Input withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty(value="jsonSchema")
    public Object getJsonSchema() {
        return this.jsonSchema;
    }

    @JsonProperty(value="jsonSchema")
    public void setJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public Input withJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Input.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("required");
        sb.append('=');
        sb.append(this.required == null ? "<null>" : this.required);
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(this.contentType == null ? "<null>" : this.contentType);
        sb.append(',');
        sb.append("jsonSchema");
        sb.append('=');
        sb.append(this.jsonSchema == null ? "<null>" : this.jsonSchema);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = result * 31 + (this.jsonSchema == null ? 0 : this.jsonSchema.hashCode());
        result = result * 31 + (this.required == null ? 0 : this.required.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Input)) {
            return false;
        }
        Input rhs = (Input)other;
        return (this.contentType == rhs.contentType || this.contentType != null && this.contentType.equals(rhs.contentType)) && (this.jsonSchema == rhs.jsonSchema || this.jsonSchema != null && this.jsonSchema.equals(rhs.jsonSchema)) && (this.required == rhs.required || this.required != null && this.required.equals(rhs.required));
    }
}

