/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.restate.sdk.core.manifest.Input;
import dev.restate.sdk.core.manifest.Output;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "ty", "input", "output"})
public class Handler {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="ty")
    @JsonPropertyDescription(value="If unspecified, defaults to EXCLUSIVE for Virtual Object. This should be unset for Services.")
    private Ty ty;
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="Description of an input payload. This will be used by Restate to validate incoming requests.")
    private Input input;
    @JsonProperty(value="output")
    @JsonPropertyDescription(value="Description of an output payload.")
    private Output output;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Handler withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="ty")
    public Ty getTy() {
        return this.ty;
    }

    @JsonProperty(value="ty")
    public void setTy(Ty ty) {
        this.ty = ty;
    }

    public Handler withTy(Ty ty) {
        this.ty = ty;
        return this;
    }

    @JsonProperty(value="input")
    public Input getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(Input input) {
        this.input = input;
    }

    public Handler withInput(Input input) {
        this.input = input;
        return this;
    }

    @JsonProperty(value="output")
    public Output getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public void setOutput(Output output) {
        this.output = output;
    }

    public Handler withOutput(Output output) {
        this.output = output;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Handler.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("ty");
        sb.append('=');
        sb.append(this.ty == null ? "<null>" : this.ty);
        sb.append(',');
        sb.append("input");
        sb.append('=');
        sb.append(this.input == null ? "<null>" : this.input);
        sb.append(',');
        sb.append("output");
        sb.append('=');
        sb.append(this.output == null ? "<null>" : this.output);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
        result = result * 31 + (this.input == null ? 0 : this.input.hashCode());
        result = result * 31 + (this.ty == null ? 0 : this.ty.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Handler)) {
            return false;
        }
        Handler rhs = (Handler)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.output == rhs.output || this.output != null && this.output.equals(rhs.output)) && (this.input == rhs.input || this.input != null && this.input.equals(rhs.input)) && (this.ty == rhs.ty || this.ty != null && this.ty.equals((Object)rhs.ty));
    }

    public static enum Ty {
        EXCLUSIVE("EXCLUSIVE"),
        SHARED("SHARED");

        private final String value;
        private static final Map<String, Ty> CONSTANTS;

        private Ty(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Ty fromValue(String value) {
            Ty constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Ty>();
            for (Ty c : Ty.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

