/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.MessageLite;
import dev.restate.generated.sdk.java.Java;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.common.AbortedExecutionException;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.core.MessageType;
import dev.restate.sdk.core.ProtocolException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public final class Util {
    private Util() {
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    static <T extends Throwable> Optional<T> findCause(Throwable throwable, Predicate<? super Throwable> condition) {
        for (Throwable currentThrowable = throwable; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            if (condition.test(currentThrowable)) {
                return Optional.of(currentThrowable);
            }
            if (currentThrowable == currentThrowable.getCause()) break;
        }
        return Optional.empty();
    }

    public static Optional<ProtocolException> findProtocolException(Throwable throwable) {
        return Util.findCause(throwable, t -> t instanceof ProtocolException);
    }

    public static boolean containsSuspendedException(Throwable throwable) {
        return Util.findCause(throwable, t -> t == AbortedExecutionException.INSTANCE).isPresent();
    }

    static Protocol.Failure toProtocolFailure(int code, String message) {
        Protocol.Failure.Builder builder = Protocol.Failure.newBuilder().setCode(code);
        if (message != null) {
            builder.setMessage(message);
        }
        return builder.build();
    }

    static Protocol.Failure toProtocolFailure(Throwable throwable) {
        if (throwable instanceof TerminalException) {
            return Util.toProtocolFailure(((TerminalException)throwable).getCode(), throwable.getMessage());
        }
        return Util.toProtocolFailure(500, throwable.toString());
    }

    static Protocol.ErrorMessage toErrorMessage(Throwable throwable, int currentJournalIndex, @Nullable String currentJournalEntryName, @Nullable MessageType currentJournalEntryType) {
        Protocol.ErrorMessage.Builder msg = Protocol.ErrorMessage.newBuilder().setMessage(throwable.toString());
        if (throwable instanceof ProtocolException) {
            msg.setCode(((ProtocolException)throwable).getCode());
        } else {
            msg.setCode(500);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Stacktrace:");
        throwable.printStackTrace(pw);
        msg.setDescription(sw.toString());
        if (currentJournalIndex >= 0) {
            msg.setRelatedEntryIndex(currentJournalIndex);
        }
        if (currentJournalEntryName != null) {
            msg.setRelatedEntryName(currentJournalEntryName);
        }
        if (currentJournalEntryType != null) {
            msg.setRelatedEntryType(currentJournalEntryType.encode());
        }
        return msg.build();
    }

    static TerminalException toRestateException(Protocol.Failure failure) {
        return new TerminalException(failure.getCode(), failure.getMessage());
    }

    static boolean isTerminalException(Throwable throwable) {
        return throwable instanceof TerminalException;
    }

    static void assertIsEntry(MessageLite msg) {
        if (!Util.isEntry(msg)) {
            throw new IllegalStateException("Expected input to be entry: " + msg);
        }
    }

    static void assertEntryEquals(MessageLite expected, MessageLite actual) {
        if (!Objects.equals(expected, actual)) {
            throw ProtocolException.entryDoesNotMatch(expected, actual);
        }
    }

    static void assertEntryClass(Class<? extends MessageLite> clazz, MessageLite actual) {
        if (!clazz.equals(actual.getClass())) {
            throw ProtocolException.unexpectedMessage(clazz, actual);
        }
    }

    static boolean isEntry(MessageLite msg) {
        return msg instanceof Protocol.InputEntryMessage || msg instanceof Protocol.OutputEntryMessage || msg instanceof Protocol.GetStateEntryMessage || msg instanceof Protocol.GetStateKeysEntryMessage || msg instanceof Protocol.SetStateEntryMessage || msg instanceof Protocol.ClearStateEntryMessage || msg instanceof Protocol.ClearAllStateEntryMessage || msg instanceof Protocol.SleepEntryMessage || msg instanceof Protocol.CallEntryMessage || msg instanceof Protocol.OneWayCallEntryMessage || msg instanceof Protocol.AwakeableEntryMessage || msg instanceof Protocol.CompleteAwakeableEntryMessage || msg instanceof Java.CombinatorAwaitableEntryMessage || msg instanceof Protocol.RunEntryMessage;
    }
}

