/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.ByteString;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.EnterSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.ExitSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.core.DeferredResults;
import dev.restate.sdk.core.Entries;
import dev.restate.sdk.core.InvocationState;
import dev.restate.sdk.core.InvocationStateMachine;
import dev.restate.sdk.core.SyscallsInternal;
import dev.restate.sdk.core.Util;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public final class SyscallsImpl
implements SyscallsInternal {
    private static final Logger LOG = LogManager.getLogger(SyscallsImpl.class);
    private final Request request;
    private final InvocationStateMachine stateMachine;

    SyscallsImpl(Request request, InvocationStateMachine stateMachine) {
        this.request = request;
        this.stateMachine = stateMachine;
    }

    public String objectKey() {
        return this.stateMachine.objectKey();
    }

    public Request request() {
        return this.request;
    }

    public void writeOutput(ByteString value, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("writeOutput success");
            this.writeOutput(Protocol.OutputEntryMessage.newBuilder().setValue(value).build(), callback);
        }, callback);
    }

    public void writeOutput(TerminalException throwable, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("writeOutput failure");
            this.writeOutput(Protocol.OutputEntryMessage.newBuilder().setFailure(Util.toProtocolFailure((Throwable)throwable)).build(), callback);
        }, callback);
    }

    private void writeOutput(Protocol.OutputEntryMessage entry, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> this.stateMachine.processJournalEntry(entry, Entries.OutputEntry.INSTANCE, callback), callback);
    }

    public void get(String name, SyscallCallback<Deferred<ByteString>> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("get {}", (Object)name);
            this.stateMachine.processCompletableJournalEntry(Protocol.GetStateEntryMessage.newBuilder().setKey(ByteString.copyFromUtf8((String)name)).build(), Entries.GetStateEntry.INSTANCE, callback);
        }, callback);
    }

    public void getKeys(SyscallCallback<Deferred<Collection<String>>> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("get keys");
            this.stateMachine.processCompletableJournalEntry(Protocol.GetStateKeysEntryMessage.newBuilder().build(), Entries.GetStateKeysEntry.INSTANCE, callback);
        }, callback);
    }

    public void clear(String name, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("clear {}", (Object)name);
            this.stateMachine.processJournalEntry(Protocol.ClearStateEntryMessage.newBuilder().setKey(ByteString.copyFromUtf8((String)name)).build(), Entries.ClearStateEntry.INSTANCE, callback);
        }, callback);
    }

    public void clearAll(SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("clearAll");
            this.stateMachine.processJournalEntry(Protocol.ClearAllStateEntryMessage.newBuilder().build(), Entries.ClearAllStateEntry.INSTANCE, callback);
        }, callback);
    }

    public void set(String name, ByteString value, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("set {}", (Object)name);
            this.stateMachine.processJournalEntry(Protocol.SetStateEntryMessage.newBuilder().setKey(ByteString.copyFromUtf8((String)name)).setValue(value).build(), Entries.SetStateEntry.INSTANCE, callback);
        }, callback);
    }

    public void sleep(Duration duration, SyscallCallback<Deferred<Void>> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("sleep {}", (Object)duration);
            this.stateMachine.processCompletableJournalEntry(Protocol.SleepEntryMessage.newBuilder().setWakeUpTime(Instant.now().toEpochMilli() + duration.toMillis()).build(), Entries.SleepEntry.INSTANCE, callback);
        }, callback);
    }

    public void call(Target target, ByteString parameter, SyscallCallback<Deferred<ByteString>> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("call {}", (Object)target);
            Protocol.CallEntryMessage.Builder builder = Protocol.CallEntryMessage.newBuilder().setServiceName(target.getService()).setHandlerName(target.getHandler()).setParameter(parameter);
            if (target.getKey() != null) {
                builder.setKey(target.getKey());
            }
            this.stateMachine.processCompletableJournalEntry(builder.build(), new Entries.InvokeEntry(Result::success), callback);
        }, callback);
    }

    public void send(Target target, ByteString parameter, @Nullable Duration delay, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("backgroundCall {}", (Object)target);
            Protocol.OneWayCallEntryMessage.Builder builder = Protocol.OneWayCallEntryMessage.newBuilder().setServiceName(target.getService()).setHandlerName(target.getHandler()).setParameter(parameter);
            if (target.getKey() != null) {
                builder.setKey(target.getKey());
            }
            if (delay != null && !delay.isZero()) {
                builder.setInvokeTime(Instant.now().toEpochMilli() + delay.toMillis());
            }
            this.stateMachine.processJournalEntry(builder.build(), Entries.BackgroundInvokeEntry.INSTANCE, callback);
        }, callback);
    }

    public void enterSideEffectBlock(String name, EnterSideEffectSyscallCallback callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("enterSideEffectBlock");
            this.stateMachine.enterSideEffectBlock(name, callback);
        }, (SyscallCallback<?>)callback);
    }

    public void exitSideEffectBlock(ByteString toWrite, ExitSideEffectSyscallCallback callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("exitSideEffectBlock with success");
            this.stateMachine.exitSideEffectBlock(Protocol.RunEntryMessage.newBuilder().setValue(toWrite).build(), callback);
        }, (SyscallCallback<?>)callback);
    }

    public void exitSideEffectBlockWithTerminalException(TerminalException toWrite, ExitSideEffectSyscallCallback callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("exitSideEffectBlock with failure");
            this.stateMachine.exitSideEffectBlock(Protocol.RunEntryMessage.newBuilder().setFailure(Util.toProtocolFailure((Throwable)toWrite)).build(), callback);
        }, (SyscallCallback<?>)callback);
    }

    public void awakeable(SyscallCallback<Map.Entry<String, Deferred<ByteString>>> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("awakeable");
            this.stateMachine.processCompletableJournalEntry(Protocol.AwakeableEntryMessage.getDefaultInstance(), Entries.AwakeableEntry.INSTANCE, SyscallCallback.mappingTo(deferredResult -> {
                ByteString awakeableId = this.stateMachine.id().concat(ByteString.copyFrom((ByteBuffer)ByteBuffer.allocate(4).putInt(((DeferredResults.SingleDeferredInternal)deferredResult).entryIndex()).rewind()));
                return new AbstractMap.SimpleImmutableEntry<CallSite, Deferred>((CallSite)((Object)("prom_1" + Base64.getUrlEncoder().encodeToString(awakeableId.toByteArray()))), (Deferred)deferredResult);
            }, (SyscallCallback)callback));
        }, callback);
    }

    public void resolveAwakeable(String serializedId, ByteString payload, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("resolveAwakeable");
            this.completeAwakeable(serializedId, Protocol.CompleteAwakeableEntryMessage.newBuilder().setValue(payload), callback);
        }, callback);
    }

    public void rejectAwakeable(String serializedId, String reason, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> {
            LOG.trace("rejectAwakeable");
            this.completeAwakeable(serializedId, Protocol.CompleteAwakeableEntryMessage.newBuilder().setFailure(Protocol.Failure.newBuilder().setCode(500).setMessage(reason)), callback);
        }, callback);
    }

    private void completeAwakeable(String serializedId, Protocol.CompleteAwakeableEntryMessage.Builder builder, SyscallCallback<Void> callback) {
        Protocol.CompleteAwakeableEntryMessage expectedEntry = builder.setId(serializedId).build();
        this.stateMachine.processJournalEntry(expectedEntry, Entries.CompleteAwakeableEntry.INSTANCE, callback);
    }

    public <T> void resolveDeferred(Deferred<T> deferredToResolve, SyscallCallback<Void> callback) {
        this.wrapAndPropagateExceptions(() -> this.stateMachine.resolveDeferred(deferredToResolve, callback), callback);
    }

    @Override
    public String getFullyQualifiedMethodName() {
        return this.stateMachine.getFullyQualifiedHandlerName();
    }

    @Override
    public InvocationState getInvocationState() {
        return this.stateMachine.getInvocationState();
    }

    public boolean isInsideSideEffect() {
        return this.stateMachine.isInsideSideEffect();
    }

    @Override
    public void close() {
        this.stateMachine.end();
    }

    public void fail(Throwable cause) {
        this.stateMachine.fail(cause);
    }

    private void wrapAndPropagateExceptions(Runnable r, SyscallCallback<?> handler) {
        try {
            r.run();
        }
        catch (Throwable e) {
            this.fail(e);
            handler.onCancel(e);
        }
    }
}

