/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.sdk.core.BaseSuspendableCallbackStateMachine;
import dev.restate.sdk.core.SuspendableCallback;

class SideEffectAckStateMachine
extends BaseSuspendableCallbackStateMachine<SideEffectAckCallback> {
    private int lastAcknowledgedEntry = -1;
    private int lastExecutedSideEffect = -1;

    SideEffectAckStateMachine() {
    }

    void waitLastSideEffectAck(SideEffectAckCallback callback) {
        if (this.canExecuteSideEffect()) {
            callback.onLastSideEffectAck();
        } else {
            this.setCallback(callback);
        }
    }

    void tryHandleSideEffectAck(int entryIndex) {
        this.lastAcknowledgedEntry = Math.max(entryIndex, this.lastAcknowledgedEntry);
        if (this.canExecuteSideEffect()) {
            this.consumeCallback(SideEffectAckCallback::onLastSideEffectAck);
        }
    }

    void registerExecutedSideEffect(int entryIndex) {
        this.lastExecutedSideEffect = entryIndex;
    }

    private boolean canExecuteSideEffect() {
        return this.lastExecutedSideEffect <= this.lastAcknowledgedEntry;
    }

    public int getLastExecutedSideEffect() {
        return this.lastExecutedSideEffect;
    }

    @Override
    void abort(Throwable cause) {
        super.abort(cause);
        this.tryFailCallback();
    }

    static interface SideEffectAckCallback
    extends SuspendableCallback {
        public void onLastSideEffectAck();
    }
}

