/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.sdk.auth.RequestIdentityVerifier;
import dev.restate.sdk.common.BindableServiceFactory;
import dev.restate.sdk.common.syscalls.HandlerDefinition;
import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.core.DeploymentManifest;
import dev.restate.sdk.core.InvocationStateMachine;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.ResolvedEndpointHandler;
import dev.restate.sdk.core.ResolvedEndpointHandlerImpl;
import dev.restate.sdk.core.manifest.DeploymentManifestSchema;
import dev.restate.sdk.core.manifest.Service;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.jspecify.annotations.Nullable;

public class RestateEndpoint {
    private static final Logger LOG = LogManager.getLogger(RestateEndpoint.class);
    private final Map<String, ServiceAndOptions<?>> services;
    private final Tracer tracer;
    private final RequestIdentityVerifier requestIdentityVerifier;
    private final DeploymentManifest deploymentManifest;

    private RestateEndpoint(DeploymentManifestSchema.ProtocolMode protocolMode, Map<String, ServiceAndOptions<?>> services, Tracer tracer, RequestIdentityVerifier requestIdentityVerifier) {
        this.services = services;
        this.tracer = tracer;
        this.requestIdentityVerifier = requestIdentityVerifier;
        this.deploymentManifest = new DeploymentManifest(protocolMode, services.values().stream().map(c -> c.service));
        this.logCreation();
    }

    public ResolvedEndpointHandler resolve(String componentName, String handlerName, RequestIdentityVerifier.Headers headers, Context otelContext, LoggingContextSetter loggingContextSetter, @Nullable Executor syscallExecutor) throws ProtocolException {
        ServiceAndOptions<?> svc = this.services.get(componentName);
        if (svc == null) {
            throw ProtocolException.methodNotFound(componentName, handlerName);
        }
        String fullyQualifiedServiceMethod = componentName + "/" + handlerName;
        HandlerDefinition handler = svc.service.getHandler(handlerName);
        if (handler == null) {
            throw ProtocolException.methodNotFound(componentName, handlerName);
        }
        if (this.requestIdentityVerifier != null) {
            try {
                this.requestIdentityVerifier.verifyRequest(headers);
            }
            catch (Exception e) {
                throw ProtocolException.unauthorized(e);
            }
        }
        Span span = this.tracer.spanBuilder("Invoke method").setSpanKind(SpanKind.SERVER).setParent(otelContext).startSpan();
        loggingContextSetter.set("restateInvocationTarget", fullyQualifiedServiceMethod);
        InvocationStateMachine stateMachine = new InvocationStateMachine(componentName, fullyQualifiedServiceMethod, span, loggingContextSetter);
        return new ResolvedEndpointHandlerImpl(stateMachine, handler, svc.options, syscallExecutor);
    }

    public DeploymentManifestSchema handleDiscoveryRequest() {
        DeploymentManifestSchema response = this.deploymentManifest.manifest();
        LOG.info("Replying to discovery request with services [{}]", (Object)response.getServices().stream().map(Service::getName).collect(Collectors.joining(",")));
        return response;
    }

    private void logCreation() {
        LOG.info("Registered services: {}", this.services.keySet());
    }

    public static Builder newBuilder(DeploymentManifestSchema.ProtocolMode protocolMode) {
        return new Builder(protocolMode);
    }

    public static BindableServiceFactory<Object, Object> discoverBindableServiceFactory(Object service) {
        return Objects.requireNonNull(ServiceAdapterSingleton.INSTANCE.discoverAdapter(service), () -> "ServiceAdapter class not found for service " + service.getClass().getCanonicalName() + ". Make sure the annotation processor is correctly configured to generate the ServiceAdapter, and it generates the META-INF/services/" + BindableServiceFactory.class.getCanonicalName() + " file containing the generated class. If you're using fat jars, make sure the jar plugin correctly squashes all the META-INF/services files. Found ServiceAdapter: " + ServiceAdapterSingleton.INSTANCE.adapters);
    }

    private static class ServiceAndOptions<O> {
        private final ServiceDefinition<O> service;
        private final O options;

        ServiceAndOptions(ServiceDefinition<O> service, O options) {
            this.service = service;
            this.options = options;
        }
    }

    private static class ServiceAdapterDiscovery {
        private final List<BindableServiceFactory> adapters = ServiceLoader.load(BindableServiceFactory.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());

        private ServiceAdapterDiscovery() {
        }

        private @Nullable BindableServiceFactory discoverAdapter(Object service) {
            return this.adapters.stream().filter(sa -> sa.supports(service)).findFirst().orElse(null);
        }
    }

    private static class ServiceAdapterSingleton {
        private static final ServiceAdapterDiscovery INSTANCE = new ServiceAdapterDiscovery();

        private ServiceAdapterSingleton() {
        }
    }

    @FunctionalInterface
    public static interface LoggingContextSetter {
        public static final String INVOCATION_ID_KEY = "restateInvocationId";
        public static final String INVOCATION_TARGET_KEY = "restateInvocationTarget";
        public static final String INVOCATION_STATUS_KEY = "restateInvocationStatus";
        public static final LoggingContextSetter THREAD_LOCAL_INSTANCE = ThreadContext::put;

        public void set(String var1, String var2);
    }

    public static class Builder {
        private final List<ServiceAndOptions<?>> services = new ArrayList();
        private final DeploymentManifestSchema.ProtocolMode protocolMode;
        private RequestIdentityVerifier requestIdentityVerifier;
        private Tracer tracer = OpenTelemetry.noop().getTracer("NOOP");

        public Builder(DeploymentManifestSchema.ProtocolMode protocolMode) {
            this.protocolMode = protocolMode;
        }

        public <O> Builder bind(ServiceDefinition<O> component, O options) {
            this.services.add(new ServiceAndOptions<O>(component, options));
            return this;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder withRequestIdentityVerifier(RequestIdentityVerifier requestIdentityVerifier) {
            this.requestIdentityVerifier = requestIdentityVerifier;
            return this;
        }

        public RestateEndpoint build() {
            return new RestateEndpoint(this.protocolMode, this.services.stream().collect(Collectors.toMap(c -> c.service.getServiceName(), Function.identity())), this.tracer, this.requestIdentityVerifier);
        }
    }
}

