/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.ByteString;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.HandlerDefinition;
import dev.restate.sdk.common.syscalls.HandlerSpecification;
import dev.restate.sdk.common.syscalls.InvocationHandler;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.common.syscalls.Syscalls;
import dev.restate.sdk.core.ExceptionCatchingInvocationInputSubscriber;
import dev.restate.sdk.core.ExecutorSwitchingSyscalls;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.InvocationStateMachine;
import dev.restate.sdk.core.ResolvedEndpointHandler;
import dev.restate.sdk.core.SyscallsImpl;
import dev.restate.sdk.core.SyscallsInternal;
import dev.restate.sdk.core.Util;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

final class ResolvedEndpointHandlerImpl
implements ResolvedEndpointHandler {
    private static final Logger LOG = LogManager.getLogger(ResolvedEndpointHandlerImpl.class);
    private final InvocationStateMachine stateMachine;
    private final HandlerSpecification<Object, Object> spec;
    private final InvocationHandler<Object, Object, Object> wrappedHandler;
    private final Object componentOptions;
    private final @Nullable Executor syscallsExecutor;

    public ResolvedEndpointHandlerImpl(InvocationStateMachine stateMachine, HandlerDefinition<?, ?, Object> handler, Object serviceOptions, @Nullable Executor syscallExecutor) {
        this.stateMachine = stateMachine;
        this.spec = handler.getSpec();
        this.wrappedHandler = new InvocationHandlerWrapper<Object, Object, Object>(handler.getHandler());
        this.componentOptions = serviceOptions;
        this.syscallsExecutor = syscallExecutor;
    }

    @Override
    public InvocationFlow.InvocationInputSubscriber input() {
        return new ExceptionCatchingInvocationInputSubscriber(this.stateMachine);
    }

    @Override
    public InvocationFlow.InvocationOutputPublisher output() {
        return this.stateMachine;
    }

    @Override
    public void start() {
        LOG.trace("Start processing invocation");
        this.stateMachine.startAndConsumeInput((SyscallCallback<Request>)SyscallCallback.of(request -> {
            SyscallsInternal syscalls = this.syscallsExecutor != null ? new ExecutorSwitchingSyscalls(new SyscallsImpl((Request)request, this.stateMachine), this.syscallsExecutor) : new SyscallsImpl((Request)request, this.stateMachine);
            this.wrappedHandler.handle(this.spec, (Syscalls)syscalls, this.componentOptions, SyscallCallback.of(o -> this.writeOutputAndEnd(syscalls, (ByteString)o), t -> this.end(syscalls, (Throwable)t)));
        }, t -> {}));
    }

    private void writeOutputAndEnd(SyscallsInternal syscalls, ByteString output) {
        syscalls.writeOutput(output, SyscallCallback.ofVoid(() -> {
            LOG.trace("Wrote output message:\n{}", (Object)output);
            this.end(syscalls, null);
        }, arg_0 -> ((SyscallsInternal)syscalls).fail(arg_0)));
    }

    private void end(SyscallsInternal syscalls, @Nullable Throwable exception) {
        if (exception == null || Util.containsSuspendedException(exception)) {
            syscalls.close();
        } else {
            LOG.warn("Error when processing the invocation", exception);
            if (Util.isTerminalException(exception)) {
                syscalls.writeOutput((TerminalException)exception, SyscallCallback.ofVoid(() -> {
                    LOG.trace("Closed correctly with non ok exception", exception);
                    syscalls.close();
                }, arg_0 -> ((SyscallsInternal)syscalls).fail(arg_0)));
            } else {
                syscalls.fail(exception);
            }
        }
    }

    private static class InvocationHandlerWrapper<REQ, RES, O>
    implements InvocationHandler<REQ, RES, O> {
        private final InvocationHandler<REQ, RES, O> handler;

        private InvocationHandlerWrapper(InvocationHandler<REQ, RES, O> handler) {
            this.handler = handler;
        }

        public void handle(HandlerSpecification<REQ, RES> spec, Syscalls syscalls, O options, SyscallCallback<ByteString> callback) {
            try {
                this.handler.handle(spec, syscalls, options, callback);
            }
            catch (Throwable e) {
                callback.onCancel(e);
            }
        }
    }
}

