/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.core.BaseSuspendableCallbackStateMachine;
import dev.restate.sdk.core.SuspendableCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReadyResultStateMachine
extends BaseSuspendableCallbackStateMachine<OnNewReadyResultCallback> {
    private static final Logger LOG = LogManager.getLogger(ReadyResultStateMachine.class);
    private final Map<Integer, Protocol.CompletionMessage> completions = new HashMap<Integer, Protocol.CompletionMessage>();
    private final Map<Integer, Function<Protocol.CompletionMessage, Result<?>>> completionParsers = new HashMap();
    private final Map<Integer, Result<?>> results = new HashMap();

    ReadyResultStateMachine() {
    }

    void offerCompletion(Protocol.CompletionMessage completionMessage) {
        LOG.trace("Offered new completion {}", (Object)completionMessage);
        this.completions.put(completionMessage.getEntryIndex(), completionMessage);
        this.tryParse(completionMessage.getEntryIndex());
    }

    void offerCompletionParser(int entryIndex, Function<Protocol.CompletionMessage, Result<?>> parser) {
        LOG.trace("Offered new completion parser for index {}", (Object)entryIndex);
        this.completionParsers.put(entryIndex, parser);
        this.tryParse(entryIndex);
    }

    void onNewReadyResult(OnNewReadyResultCallback callback) {
        this.assertCallbackNotSet("Two concurrent reads were requested.");
        this.tryProgress(callback);
    }

    @Override
    void abort(Throwable cause) {
        super.abort(cause);
        this.consumeCallback(this::tryProgress);
    }

    private void tryParse(int entryIndex) {
        Protocol.CompletionMessage completionMessage = this.completions.get(entryIndex);
        if (completionMessage == null) {
            return;
        }
        Function<Protocol.CompletionMessage, Result<?>> parser = this.completionParsers.remove(entryIndex);
        if (parser == null) {
            return;
        }
        this.completions.remove(entryIndex, completionMessage);
        Result<?> readyResult = parser.apply(completionMessage);
        this.results.put(completionMessage.getEntryIndex(), readyResult);
        this.consumeCallback(this::tryProgress);
    }

    private void tryProgress(OnNewReadyResultCallback cb) {
        boolean resolved = cb.onNewResult(this.results);
        if (!resolved) {
            this.setCallback(cb);
        }
    }

    static interface OnNewReadyResultCallback
    extends SuspendableCallback {
        public boolean onNewResult(Map<Integer, Result<?>> var1);
    }
}

