/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.MessageLite;
import dev.restate.generated.service.protocol.Protocol;

public class ProtocolException
extends RuntimeException {
    static final int UNAUTHORIZED_CODE = 401;
    static final int NOT_FOUND_CODE = 404;
    static final int JOURNAL_MISMATCH_CODE = 570;
    static final int PROTOCOL_VIOLATION_CODE = 571;
    static final ProtocolException CLOSED = new ProtocolException("Invocation closed");
    private final int code;

    private ProtocolException(String message) {
        this(message, 500);
    }

    private ProtocolException(String message, int code) {
        this(message, code, null);
    }

    public ProtocolException(String message, int code, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static ProtocolException unexpectedMessage(Class<? extends MessageLite> expected, MessageLite actual) {
        return new ProtocolException("Unexpected message type received from the runtime. Expected: '" + expected.getCanonicalName() + "', Actual: '" + actual.getClass().getCanonicalName() + "'", 571);
    }

    static ProtocolException entryDoesNotMatch(MessageLite expected, MessageLite actual) {
        return new ProtocolException("Journal entry " + expected.getClass() + " does not match: " + expected + " != " + actual, 570);
    }

    static ProtocolException completionDoesNotMatch(String entry, Protocol.CompletionMessage.ResultCase actual) {
        return new ProtocolException("Completion for entry " + entry + " doesn't expect completion variant " + actual, 570);
    }

    static ProtocolException unknownMessageType(short type) {
        return new ProtocolException("MessageType " + Integer.toHexString(type) + " unknown", 571);
    }

    static ProtocolException methodNotFound(String serviceName, String handlerName) {
        return new ProtocolException("Cannot find handler '" + serviceName + "/" + handlerName + "'", 404);
    }

    static ProtocolException invalidSideEffectCall() {
        return new ProtocolException("A syscall was invoked from within a side effect closure.", 500, null);
    }

    static ProtocolException unauthorized(Throwable e) {
        return new ProtocolException("Unauthorized", 401, e);
    }
}

