/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import dev.restate.generated.sdk.java.Java;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.core.ProtocolException;

public enum MessageType {
    StartMessage,
    CompletionMessage,
    SuspensionMessage,
    ErrorMessage,
    EndMessage,
    EntryAckMessage,
    InputEntryMessage,
    OutputEntryMessage,
    GetStateEntryMessage,
    SetStateEntryMessage,
    ClearStateEntryMessage,
    ClearAllStateEntryMessage,
    GetStateKeysEntryMessage,
    SleepEntryMessage,
    CallEntryMessage,
    OneWayCallEntryMessage,
    AwakeableEntryMessage,
    CompleteAwakeableEntryMessage,
    RunEntryMessage,
    CombinatorAwaitableEntryMessage;

    public static final short START_MESSAGE_TYPE = 0;
    public static final short COMPLETION_MESSAGE_TYPE = 1;
    public static final short SUSPENSION_MESSAGE_TYPE = 2;
    public static final short ERROR_MESSAGE_TYPE = 3;
    public static final short ENTRY_ACK_MESSAGE_TYPE = 4;
    public static final short END_MESSAGE_TYPE = 5;
    public static final short INPUT_ENTRY_MESSAGE_TYPE = 1024;
    public static final short OUTPUT_ENTRY_MESSAGE_TYPE = 1025;
    public static final short GET_STATE_ENTRY_MESSAGE_TYPE = 2048;
    public static final short SET_STATE_ENTRY_MESSAGE_TYPE = 2049;
    public static final short CLEAR_STATE_ENTRY_MESSAGE_TYPE = 2050;
    public static final short CLEAR_ALL_STATE_ENTRY_MESSAGE_TYPE = 2051;
    public static final short GET_STATE_KEYS_ENTRY_MESSAGE_TYPE = 2052;
    public static final short SLEEP_ENTRY_MESSAGE_TYPE = 3072;
    public static final short INVOKE_ENTRY_MESSAGE_TYPE = 3073;
    public static final short BACKGROUND_INVOKE_ENTRY_MESSAGE_TYPE = 3074;
    public static final short AWAKEABLE_ENTRY_MESSAGE_TYPE = 3075;
    public static final short COMPLETE_AWAKEABLE_ENTRY_MESSAGE_TYPE = 3076;
    public static final short COMBINATOR_AWAITABLE_ENTRY_MESSAGE_TYPE = -1024;
    public static final short SIDE_EFFECT_ENTRY_MESSAGE_TYPE = 3077;

    public Parser<? extends MessageLite> messageParser() {
        switch (this) {
            case StartMessage: {
                return Protocol.StartMessage.parser();
            }
            case CompletionMessage: {
                return Protocol.CompletionMessage.parser();
            }
            case SuspensionMessage: {
                return Protocol.SuspensionMessage.parser();
            }
            case EndMessage: {
                return Protocol.EndMessage.parser();
            }
            case ErrorMessage: {
                return Protocol.ErrorMessage.parser();
            }
            case EntryAckMessage: {
                return Protocol.EntryAckMessage.parser();
            }
            case InputEntryMessage: {
                return Protocol.InputEntryMessage.parser();
            }
            case OutputEntryMessage: {
                return Protocol.OutputEntryMessage.parser();
            }
            case GetStateEntryMessage: {
                return Protocol.GetStateEntryMessage.parser();
            }
            case SetStateEntryMessage: {
                return Protocol.SetStateEntryMessage.parser();
            }
            case ClearStateEntryMessage: {
                return Protocol.ClearStateEntryMessage.parser();
            }
            case ClearAllStateEntryMessage: {
                return Protocol.ClearAllStateEntryMessage.parser();
            }
            case GetStateKeysEntryMessage: {
                return Protocol.GetStateKeysEntryMessage.parser();
            }
            case SleepEntryMessage: {
                return Protocol.SleepEntryMessage.parser();
            }
            case CallEntryMessage: {
                return Protocol.CallEntryMessage.parser();
            }
            case OneWayCallEntryMessage: {
                return Protocol.OneWayCallEntryMessage.parser();
            }
            case AwakeableEntryMessage: {
                return Protocol.AwakeableEntryMessage.parser();
            }
            case CompleteAwakeableEntryMessage: {
                return Protocol.CompleteAwakeableEntryMessage.parser();
            }
            case CombinatorAwaitableEntryMessage: {
                return Java.CombinatorAwaitableEntryMessage.parser();
            }
            case RunEntryMessage: {
                return Protocol.RunEntryMessage.parser();
            }
        }
        throw new IllegalStateException();
    }

    public short encode() {
        switch (this) {
            case StartMessage: {
                return 0;
            }
            case CompletionMessage: {
                return 1;
            }
            case SuspensionMessage: {
                return 2;
            }
            case EndMessage: {
                return 5;
            }
            case ErrorMessage: {
                return 3;
            }
            case EntryAckMessage: {
                return 4;
            }
            case InputEntryMessage: {
                return 1024;
            }
            case OutputEntryMessage: {
                return 1025;
            }
            case GetStateEntryMessage: {
                return 2048;
            }
            case SetStateEntryMessage: {
                return 2049;
            }
            case ClearStateEntryMessage: {
                return 2050;
            }
            case ClearAllStateEntryMessage: {
                return 2051;
            }
            case GetStateKeysEntryMessage: {
                return 2052;
            }
            case SleepEntryMessage: {
                return 3072;
            }
            case CallEntryMessage: {
                return 3073;
            }
            case OneWayCallEntryMessage: {
                return 3074;
            }
            case AwakeableEntryMessage: {
                return 3075;
            }
            case CompleteAwakeableEntryMessage: {
                return 3076;
            }
            case CombinatorAwaitableEntryMessage: {
                return -1024;
            }
            case RunEntryMessage: {
                return 3077;
            }
        }
        throw new IllegalStateException();
    }

    public static MessageType decode(short value) throws ProtocolException {
        switch (value) {
            case 0: {
                return StartMessage;
            }
            case 1: {
                return CompletionMessage;
            }
            case 2: {
                return SuspensionMessage;
            }
            case 5: {
                return EndMessage;
            }
            case 3: {
                return ErrorMessage;
            }
            case 4: {
                return EntryAckMessage;
            }
            case 1024: {
                return InputEntryMessage;
            }
            case 1025: {
                return OutputEntryMessage;
            }
            case 2048: {
                return GetStateEntryMessage;
            }
            case 2049: {
                return SetStateEntryMessage;
            }
            case 2050: {
                return ClearStateEntryMessage;
            }
            case 2051: {
                return ClearAllStateEntryMessage;
            }
            case 2052: {
                return GetStateKeysEntryMessage;
            }
            case 3072: {
                return SleepEntryMessage;
            }
            case 3073: {
                return CallEntryMessage;
            }
            case 3074: {
                return OneWayCallEntryMessage;
            }
            case 3075: {
                return AwakeableEntryMessage;
            }
            case 3076: {
                return CompleteAwakeableEntryMessage;
            }
            case -1024: {
                return CombinatorAwaitableEntryMessage;
            }
            case 3077: {
                return RunEntryMessage;
            }
        }
        throw ProtocolException.unknownMessageType(value);
    }

    public static MessageType fromMessage(MessageLite msg) {
        if (msg instanceof Protocol.SuspensionMessage) {
            return SuspensionMessage;
        }
        if (msg instanceof Protocol.ErrorMessage) {
            return ErrorMessage;
        }
        if (msg instanceof Protocol.EndMessage) {
            return EndMessage;
        }
        if (msg instanceof Protocol.EntryAckMessage) {
            return EntryAckMessage;
        }
        if (msg instanceof Protocol.InputEntryMessage) {
            return InputEntryMessage;
        }
        if (msg instanceof Protocol.OutputEntryMessage) {
            return OutputEntryMessage;
        }
        if (msg instanceof Protocol.GetStateEntryMessage) {
            return GetStateEntryMessage;
        }
        if (msg instanceof Protocol.SetStateEntryMessage) {
            return SetStateEntryMessage;
        }
        if (msg instanceof Protocol.ClearStateEntryMessage) {
            return ClearStateEntryMessage;
        }
        if (msg instanceof Protocol.ClearAllStateEntryMessage) {
            return ClearAllStateEntryMessage;
        }
        if (msg instanceof Protocol.GetStateKeysEntryMessage) {
            return GetStateKeysEntryMessage;
        }
        if (msg instanceof Protocol.SleepEntryMessage) {
            return SleepEntryMessage;
        }
        if (msg instanceof Protocol.CallEntryMessage) {
            return CallEntryMessage;
        }
        if (msg instanceof Protocol.OneWayCallEntryMessage) {
            return OneWayCallEntryMessage;
        }
        if (msg instanceof Protocol.AwakeableEntryMessage) {
            return AwakeableEntryMessage;
        }
        if (msg instanceof Protocol.CompleteAwakeableEntryMessage) {
            return CompleteAwakeableEntryMessage;
        }
        if (msg instanceof Java.CombinatorAwaitableEntryMessage) {
            return CombinatorAwaitableEntryMessage;
        }
        if (msg instanceof Protocol.RunEntryMessage) {
            return RunEntryMessage;
        }
        if (msg instanceof Protocol.CompletionMessage) {
            throw new IllegalArgumentException("SDK should never send a CompletionMessage");
        }
        throw new IllegalStateException();
    }
}

