/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.MessageLite;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.core.MessageType;
import dev.restate.sdk.core.ProtocolException;

public class MessageHeader {
    static final short SUPPORTED_PROTOCOL_VERSION = 2;
    static final short VERSION_MASK = 1023;
    static final short DONE_FLAG = 1;
    static final int REQUIRES_ACK_FLAG = 32768;
    private final MessageType type;
    private final int flags;
    private final int length;

    public MessageHeader(MessageType type, int flags, int length) {
        this.type = type;
        this.flags = flags;
        this.length = length;
    }

    public MessageType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public long encode() {
        long res = 0L;
        res |= (long)this.type.encode() << 48;
        res |= (long)this.flags << 32;
        return res |= (long)this.length;
    }

    public static MessageHeader parse(long encoded) throws ProtocolException {
        short ty_code = (short)(encoded >> 48);
        short flags = (short)(encoded >> 32);
        int len = (int)encoded;
        return new MessageHeader(MessageType.decode(ty_code), flags, len);
    }

    public static MessageHeader fromMessage(MessageLite msg) {
        if (msg instanceof Protocol.GetStateEntryMessage) {
            return new MessageHeader(MessageType.GetStateEntryMessage, ((Protocol.GetStateEntryMessage)msg).getResultCase() != Protocol.GetStateEntryMessage.ResultCase.RESULT_NOT_SET ? 1 : 0, msg.getSerializedSize());
        }
        if (msg instanceof Protocol.GetStateKeysEntryMessage) {
            return new MessageHeader(MessageType.GetStateKeysEntryMessage, ((Protocol.GetStateKeysEntryMessage)msg).getResultCase() != Protocol.GetStateKeysEntryMessage.ResultCase.RESULT_NOT_SET ? 1 : 0, msg.getSerializedSize());
        }
        if (msg instanceof Protocol.SleepEntryMessage) {
            return new MessageHeader(MessageType.SleepEntryMessage, ((Protocol.SleepEntryMessage)msg).getResultCase() != Protocol.SleepEntryMessage.ResultCase.RESULT_NOT_SET ? 1 : 0, msg.getSerializedSize());
        }
        if (msg instanceof Protocol.CallEntryMessage) {
            return new MessageHeader(MessageType.CallEntryMessage, ((Protocol.CallEntryMessage)msg).getResultCase() != Protocol.CallEntryMessage.ResultCase.RESULT_NOT_SET ? 1 : 0, msg.getSerializedSize());
        }
        if (msg instanceof Protocol.AwakeableEntryMessage) {
            return new MessageHeader(MessageType.AwakeableEntryMessage, ((Protocol.AwakeableEntryMessage)msg).getResultCase() != Protocol.AwakeableEntryMessage.ResultCase.RESULT_NOT_SET ? 1 : 0, msg.getSerializedSize());
        }
        if (msg instanceof Protocol.RunEntryMessage) {
            return new MessageHeader(MessageType.RunEntryMessage, 32768, msg.getSerializedSize());
        }
        return new MessageHeader(MessageType.fromMessage(msg), 0, msg.getSerializedSize());
    }

    public static void checkProtocolVersion(MessageHeader header) {
        if (header.type != MessageType.StartMessage) {
            throw new IllegalStateException("Expected StartMessage, got " + header.type);
        }
        short version = (short)(header.flags & 0x3FF);
        if (version != 2) {
            throw new IllegalStateException("Unsupported protocol version " + version + ", only version 2 is supported");
        }
    }
}

