/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import dev.restate.generated.sdk.java.Java;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.common.AbortedExecutionException;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.EnterSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.ExitSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.core.CallbackHandle;
import dev.restate.sdk.core.DeferredResults;
import dev.restate.sdk.core.Entries;
import dev.restate.sdk.core.IncomingEntriesStateMachine;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.InvocationIdImpl;
import dev.restate.sdk.core.InvocationState;
import dev.restate.sdk.core.MessageHeader;
import dev.restate.sdk.core.MessageType;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.ReadyResultStateMachine;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.core.SideEffectAckStateMachine;
import dev.restate.sdk.core.Tracing;
import dev.restate.sdk.core.UserStateStore;
import dev.restate.sdk.core.Util;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class InvocationStateMachine
implements InvocationFlow.InvocationProcessor {
    private static final Logger LOG = LogManager.getLogger(InvocationStateMachine.class);
    private final String serviceName;
    private final String fullyQualifiedHandlerName;
    private final Span span;
    private final RestateEndpoint.LoggingContextSetter loggingContextSetter;
    private volatile InvocationState invocationState = InvocationState.WAITING_START;
    private volatile boolean insideSideEffect = false;
    private ByteString id;
    private String debugId;
    private String key;
    private int entriesToReplay;
    private UserStateStore userStateStore;
    private int currentJournalEntryIndex = -1;
    private String currentJournalEntryName = null;
    private MessageType currentJournalEntryType = null;
    private final IncomingEntriesStateMachine incomingEntriesStateMachine;
    private final SideEffectAckStateMachine sideEffectAckStateMachine;
    private final ReadyResultStateMachine readyResultStateMachine;
    private Flow.Subscriber<? super MessageLite> outputSubscriber;
    private Flow.Subscription inputSubscription;
    private final CallbackHandle<SyscallCallback<Request>> afterStartCallback;

    InvocationStateMachine(String serviceName, String fullyQualifiedHandlerName, Span span, RestateEndpoint.LoggingContextSetter loggingContextSetter) {
        this.serviceName = serviceName;
        this.fullyQualifiedHandlerName = fullyQualifiedHandlerName;
        this.span = span;
        this.loggingContextSetter = loggingContextSetter;
        this.incomingEntriesStateMachine = new IncomingEntriesStateMachine();
        this.readyResultStateMachine = new ReadyResultStateMachine();
        this.sideEffectAckStateMachine = new SideEffectAckStateMachine();
        this.afterStartCallback = new CallbackHandle();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ByteString id() {
        return this.id;
    }

    public String objectKey() {
        return this.key;
    }

    public InvocationState getInvocationState() {
        return this.invocationState;
    }

    public boolean isInsideSideEffect() {
        return this.insideSideEffect;
    }

    public String getFullyQualifiedHandlerName() {
        return this.fullyQualifiedHandlerName;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super MessageLite> subscriber) {
        this.outputSubscriber = subscriber;
        this.outputSubscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long l) {
            }

            @Override
            public void cancel() {
                InvocationStateMachine.this.end();
            }
        });
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.inputSubscription = subscription;
    }

    @Override
    public void onNext(InvocationFlow.InvocationInput invocationInput) {
        MessageLite msg = invocationInput.message();
        LOG.trace("Received input message {} {}", msg.getClass(), (Object)msg);
        if (this.invocationState == InvocationState.WAITING_START) {
            MessageHeader.checkProtocolVersion(invocationInput.header());
            this.onStartMessage(msg);
        } else if (msg instanceof Protocol.CompletionMessage) {
            this.readyResultStateMachine.offerCompletion((Protocol.CompletionMessage)msg);
        } else if (msg instanceof Protocol.EntryAckMessage) {
            this.sideEffectAckStateMachine.tryHandleSideEffectAck(((Protocol.EntryAckMessage)msg).getEntryIndex());
        } else {
            this.incomingEntriesStateMachine.offer(msg);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.trace("Got failure from input publisher", throwable);
        this.fail(throwable);
    }

    @Override
    public void onComplete() {
        LOG.trace("Input publisher closed");
        this.readyResultStateMachine.abort((Throwable)AbortedExecutionException.INSTANCE);
        this.sideEffectAckStateMachine.abort((Throwable)AbortedExecutionException.INSTANCE);
    }

    void startAndConsumeInput(SyscallCallback<Request> afterStartCallback) {
        this.afterStartCallback.set(afterStartCallback);
        this.inputSubscription.request(1L);
    }

    void onStartMessage(MessageLite msg) {
        if (!(msg instanceof Protocol.StartMessage)) {
            this.fail(ProtocolException.unexpectedMessage(Protocol.StartMessage.class, msg));
            return;
        }
        Protocol.StartMessage startMessage = (Protocol.StartMessage)msg;
        this.id = startMessage.getId();
        this.debugId = startMessage.getDebugId();
        InvocationIdImpl invocationId = new InvocationIdImpl(startMessage.getDebugId());
        this.key = startMessage.getKey();
        this.entriesToReplay = startMessage.getKnownEntries();
        this.userStateStore = new UserStateStore(startMessage.getPartialState(), startMessage.getStateMapList().stream().collect(Collectors.toMap(Protocol.StartMessage.StateEntry::getKey, Protocol.StartMessage.StateEntry::getValue)));
        this.loggingContextSetter.set("restateInvocationId", startMessage.getDebugId());
        if (this.span.isRecording()) {
            this.span.addEvent("Start", Attributes.of(Tracing.RESTATE_INVOCATION_ID, (Object)startMessage.getDebugId()));
        }
        LOG.info("Start invocation");
        this.transitionState(InvocationState.REPLAYING);
        if (this.entriesToReplay == 0) {
            this.fail(new ProtocolException("Expected at least one entry with Input, got " + this.entriesToReplay + " entries", 500, null));
            return;
        }
        this.inputSubscription.request(Long.MAX_VALUE);
        this.nextJournalEntry(null, MessageType.InputEntryMessage);
        this.readEntry(inputMsg -> {
            if (!(inputMsg instanceof Protocol.InputEntryMessage)) {
                throw ProtocolException.unexpectedMessage(Protocol.InputEntryMessage.class, inputMsg);
            }
            Protocol.InputEntryMessage inputEntry = (Protocol.InputEntryMessage)inputMsg;
            Request request = new Request(invocationId, Context.root().with((ImplicitContextKeyed)this.span), inputEntry.getValue(), inputEntry.getHeadersList().stream().collect(Collectors.toUnmodifiableMap(Protocol.Header::getKey, Protocol.Header::getValue)));
            this.afterStartCallback.consume(cb -> cb.onSuccess((Object)request));
        }, this::fail);
    }

    void end() {
        LOG.info("End invocation");
        this.closeWithMessage((MessageLite)Protocol.EndMessage.getDefaultInstance(), ProtocolException.CLOSED);
    }

    void suspend(Collection<Integer> suspensionIndexes) {
        assert (!suspensionIndexes.isEmpty()) : "Suspension indexes MUST be a non-empty collection, per protocol specification";
        LOG.info("Suspend invocation");
        this.closeWithMessage((MessageLite)Protocol.SuspensionMessage.newBuilder().addAllEntryIndexes(suspensionIndexes).build(), ProtocolException.CLOSED);
    }

    void fail(Throwable cause) {
        LOG.warn("Invocation failed", cause);
        this.closeWithMessage((MessageLite)Util.toErrorMessage(cause, this.currentJournalEntryIndex, this.currentJournalEntryName, this.currentJournalEntryType), cause);
    }

    private void closeWithMessage(MessageLite closeMessage, Throwable cause) {
        if (this.invocationState != InvocationState.CLOSED) {
            this.transitionState(InvocationState.CLOSED);
            if (this.inputSubscription != null) {
                this.inputSubscription.cancel();
            }
            if (this.outputSubscriber != null) {
                this.outputSubscriber.onNext((MessageLite)closeMessage);
                this.outputSubscriber.onComplete();
                this.outputSubscriber = null;
            }
            this.afterStartCallback.consume(cb -> cb.onCancel(cause));
            this.readyResultStateMachine.abort(cause);
            this.sideEffectAckStateMachine.abort(cause);
            this.incomingEntriesStateMachine.abort(cause);
            this.span.end();
        }
    }

    <E extends MessageLite, T> void processCompletableJournalEntry(E expectedEntryMessage, Entries.CompletableJournalEntry<E, T> journalEntry, SyscallCallback<Deferred<T>> callback) {
        this.checkInsideSideEffectGuard();
        this.nextJournalEntry(journalEntry.getName(expectedEntryMessage), MessageType.fromMessage(expectedEntryMessage));
        if (this.invocationState == InvocationState.CLOSED) {
            callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
        } else if (this.invocationState == InvocationState.REPLAYING) {
            this.readEntry(actualEntryMessage -> {
                journalEntry.checkEntryHeader(expectedEntryMessage, (MessageLite)actualEntryMessage);
                if (journalEntry.hasResult(actualEntryMessage)) {
                    journalEntry.updateUserStateStoreWithEntry(actualEntryMessage, this.userStateStore);
                    Result readyResultInternal = journalEntry.parseEntryResult(actualEntryMessage);
                    callback.onSuccess(DeferredResults.completedSingle(this.currentJournalEntryIndex, readyResultInternal));
                } else {
                    this.readyResultStateMachine.offerCompletionParser(this.currentJournalEntryIndex, completionMessage -> {
                        journalEntry.updateUserStateStorageWithCompletion(actualEntryMessage, (Protocol.CompletionMessage)completionMessage, this.userStateStore);
                        return journalEntry.parseCompletionResult((Protocol.CompletionMessage)completionMessage);
                    });
                    callback.onSuccess(DeferredResults.single(this.currentJournalEntryIndex));
                }
            }, arg_0 -> callback.onCancel(arg_0));
        } else if (this.invocationState == InvocationState.PROCESSING) {
            Object entryToWrite = journalEntry.tryCompleteWithUserStateStorage(expectedEntryMessage, this.userStateStore);
            if (this.span.isRecording()) {
                journalEntry.trace(entryToWrite, this.span);
            }
            this.writeEntry((MessageLite)entryToWrite);
            if (journalEntry.hasResult(entryToWrite)) {
                callback.onSuccess(DeferredResults.completedSingle(this.currentJournalEntryIndex, journalEntry.parseEntryResult(entryToWrite)));
            } else {
                this.readyResultStateMachine.offerCompletionParser(this.currentJournalEntryIndex, completionMessage -> {
                    journalEntry.updateUserStateStorageWithCompletion(entryToWrite, (Protocol.CompletionMessage)completionMessage, this.userStateStore);
                    return journalEntry.parseCompletionResult((Protocol.CompletionMessage)completionMessage);
                });
                callback.onSuccess(DeferredResults.single(this.currentJournalEntryIndex));
            }
        } else {
            throw new IllegalStateException("This method was invoked when the state machine is not ready to process user code. This is probably an SDK bug");
        }
    }

    <E extends MessageLite> void processJournalEntry(E expectedEntryMessage, Entries.JournalEntry<E> journalEntry, SyscallCallback<Void> callback) {
        this.checkInsideSideEffectGuard();
        this.nextJournalEntry(journalEntry.getName(expectedEntryMessage), MessageType.fromMessage(expectedEntryMessage));
        if (this.invocationState == InvocationState.CLOSED) {
            callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
        } else if (this.invocationState == InvocationState.REPLAYING) {
            this.readEntry(actualEntryMessage -> {
                journalEntry.checkEntryHeader(expectedEntryMessage, (MessageLite)actualEntryMessage);
                journalEntry.updateUserStateStoreWithEntry(actualEntryMessage, this.userStateStore);
                callback.onSuccess(null);
            }, arg_0 -> callback.onCancel(arg_0));
        } else if (this.invocationState == InvocationState.PROCESSING) {
            if (this.span.isRecording()) {
                journalEntry.trace(expectedEntryMessage, this.span);
            }
            this.writeEntry(expectedEntryMessage);
            journalEntry.updateUserStateStoreWithEntry(expectedEntryMessage, this.userStateStore);
            callback.onSuccess(null);
        } else {
            throw new IllegalStateException("This method was invoked when the state machine is not ready to process user code. This is probably an SDK bug");
        }
    }

    void enterSideEffectBlock(String name, EnterSideEffectSyscallCallback callback) {
        this.checkInsideSideEffectGuard();
        this.nextJournalEntry(name, MessageType.RunEntryMessage);
        if (this.invocationState == InvocationState.CLOSED) {
            callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
        } else if (this.invocationState == InvocationState.REPLAYING) {
            this.readEntry(msg -> {
                Util.assertEntryClass(Protocol.RunEntryMessage.class, msg);
                this.completeSideEffectCallbackWithEntry((Protocol.RunEntryMessage)msg, (ExitSideEffectSyscallCallback)callback);
            }, arg_0 -> ((EnterSideEffectSyscallCallback)callback).onCancel(arg_0));
        } else if (this.invocationState == InvocationState.PROCESSING) {
            this.insideSideEffect = true;
            if (this.span.isRecording()) {
                this.span.addEvent("Enter SideEffect");
            }
            callback.onNotExecuted();
        } else {
            throw new IllegalStateException("This method was invoked when the state machine is not ready to process user code. This is probably an SDK bug");
        }
    }

    void exitSideEffectBlock(Protocol.RunEntryMessage sideEffectEntry, final ExitSideEffectSyscallCallback callback) {
        this.insideSideEffect = false;
        if (this.invocationState == InvocationState.CLOSED) {
            callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
        } else {
            if (this.invocationState == InvocationState.REPLAYING) {
                throw new IllegalStateException("exitSideEffect has been invoked when the state machine is in replaying mode. This is probably an SDK bug and might be caused by a missing enterSideEffectBlock invocation before exitSideEffectBlock.");
            }
            if (this.invocationState == InvocationState.PROCESSING) {
                if (this.span.isRecording()) {
                    this.span.addEvent("Exit SideEffect");
                }
                if (this.currentJournalEntryName != null) {
                    sideEffectEntry = sideEffectEntry.toBuilder().setName(this.currentJournalEntryName).build();
                }
                this.sideEffectAckStateMachine.registerExecutedSideEffect(this.currentJournalEntryIndex);
                this.writeEntry((MessageLite)sideEffectEntry);
                final Protocol.RunEntryMessage finalSideEffectEntry = sideEffectEntry;
                this.sideEffectAckStateMachine.waitLastSideEffectAck(new SideEffectAckStateMachine.SideEffectAckCallback(){

                    @Override
                    public void onLastSideEffectAck() {
                        InvocationStateMachine.this.completeSideEffectCallbackWithEntry(finalSideEffectEntry, callback);
                    }

                    @Override
                    public void onSuspend() {
                        InvocationStateMachine.this.suspend(List.of(Integer.valueOf(InvocationStateMachine.this.sideEffectAckStateMachine.getLastExecutedSideEffect())));
                        callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
                    }

                    @Override
                    public void onError(Throwable e) {
                        callback.onCancel(e);
                    }
                });
            } else {
                throw new IllegalStateException("This method was invoked when the state machine is not ready to process user code. This is probably an SDK bug");
            }
        }
    }

    void completeSideEffectCallbackWithEntry(Protocol.RunEntryMessage sideEffectEntry, ExitSideEffectSyscallCallback callback) {
        if (sideEffectEntry.hasFailure()) {
            callback.onFailure(Util.toRestateException(sideEffectEntry.getFailure()));
        } else {
            callback.onSuccess((Object)sideEffectEntry.getValue());
        }
    }

    <T> void resolveDeferred(Deferred<T> deferredToResolve, SyscallCallback<Void> callback) {
        if (deferredToResolve.isCompleted()) {
            callback.onSuccess(null);
            return;
        }
        if (deferredToResolve instanceof DeferredResults.ResolvableSingleDeferred) {
            this.resolveSingleDeferred((DeferredResults.ResolvableSingleDeferred)deferredToResolve, callback);
            return;
        }
        if (deferredToResolve instanceof DeferredResults.CombinatorDeferred) {
            this.resolveCombinatorDeferred((DeferredResults.CombinatorDeferred)deferredToResolve, callback);
            return;
        }
        throw new IllegalArgumentException("Unexpected deferred class " + deferredToResolve.getClass());
    }

    <T> void resolveSingleDeferred(final DeferredResults.ResolvableSingleDeferred<T> deferred, final SyscallCallback<Void> callback) {
        this.readyResultStateMachine.onNewReadyResult(new ReadyResultStateMachine.OnNewReadyResultCallback(){

            @Override
            public boolean onNewResult(Map<Integer, Result<?>> resultMap) {
                Result<?> resolved = resultMap.remove(deferred.entryIndex());
                if (resolved != null) {
                    deferred.resolve(resolved);
                    callback.onSuccess(null);
                    return true;
                }
                return false;
            }

            @Override
            public void onSuspend() {
                InvocationStateMachine.this.suspend(List.of(Integer.valueOf(deferred.entryIndex())));
                callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
            }

            @Override
            public void onError(Throwable e) {
                callback.onCancel(e);
            }
        });
    }

    private void resolveCombinatorDeferred(final DeferredResults.CombinatorDeferred<?> rootDeferred, final SyscallCallback<Void> callback) {
        this.checkInsideSideEffectGuard();
        this.nextJournalEntry(null, MessageType.CombinatorAwaitableEntryMessage);
        if (Objects.equals((Object)this.invocationState, (Object)InvocationState.REPLAYING)) {
            this.readEntry(actualMsg -> {
                Util.assertEntryClass(Java.CombinatorAwaitableEntryMessage.class, actualMsg);
                if (!rootDeferred.tryResolve(((Java.CombinatorAwaitableEntryMessage)actualMsg).getEntryIndexList())) {
                    throw new IllegalStateException("Combinator message cannot be resolved.");
                }
                callback.onSuccess(null);
            }, arg_0 -> callback.onCancel(arg_0));
        } else if (this.invocationState == InvocationState.PROCESSING) {
            final HashMap<Integer, DeferredResults.ResolvableSingleDeferred> resolvableSingles = new HashMap<Integer, DeferredResults.ResolvableSingleDeferred>();
            Set unprocessedLeafs = rootDeferred.unprocessedLeafs().collect(Collectors.toSet());
            if (unprocessedLeafs.isEmpty()) {
                if (!rootDeferred.tryResolve(-1)) {
                    throw new IllegalStateException("Combinator cannot be resolved, but every children have been resolved already. This is a symptom of an SDK bug, please contact the developers.");
                }
                this.writeCombinatorEntry(Collections.emptyList());
                callback.onSuccess(null);
                return;
            }
            final ArrayList<Integer> resolvedOrder = new ArrayList<Integer>();
            for (DeferredResults.SingleDeferredInternal singleDeferred : unprocessedLeafs) {
                int entryIndex = singleDeferred.entryIndex();
                if (singleDeferred.isCompleted()) {
                    resolvedOrder.add(entryIndex);
                    if (!rootDeferred.tryResolve(entryIndex)) continue;
                    this.writeCombinatorEntry(resolvedOrder);
                    callback.onSuccess(null);
                    return;
                }
                resolvableSingles.put(entryIndex, (DeferredResults.ResolvableSingleDeferred)singleDeferred);
            }
            this.readyResultStateMachine.onNewReadyResult(new ReadyResultStateMachine.OnNewReadyResultCallback(){

                @Override
                public boolean onNewResult(Map<Integer, Result<?>> resultMap) {
                    Iterator it = resolvableSingles.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        int entryIndex = (Integer)entry.getKey();
                        Result<?> result = resultMap.remove(entryIndex);
                        if (result == null) continue;
                        resolvedOrder.add(entryIndex);
                        ((DeferredResults.ResolvableSingleDeferred)entry.getValue()).resolve(result);
                        it.remove();
                        if (!rootDeferred.tryResolve(entryIndex)) continue;
                        InvocationStateMachine.this.writeCombinatorEntry(resolvedOrder);
                        callback.onSuccess(null);
                        return true;
                    }
                    return false;
                }

                @Override
                public void onSuspend() {
                    InvocationStateMachine.this.suspend(resolvableSingles.keySet());
                    callback.onCancel((Throwable)AbortedExecutionException.INSTANCE);
                }

                @Override
                public void onError(Throwable e) {
                    callback.onCancel(e);
                }
            });
        } else {
            throw new IllegalStateException("This method was invoked when the state machine is not ready to process user code. This is probably an SDK bug");
        }
    }

    private void writeCombinatorEntry(List<Integer> resolvedList) {
        Java.CombinatorAwaitableEntryMessage entry = Java.CombinatorAwaitableEntryMessage.newBuilder().addAllEntryIndex(resolvedList).build();
        this.span.addEvent("Combinator");
        this.writeEntry((MessageLite)entry);
    }

    private void transitionState(InvocationState newInvocationState) {
        if (this.invocationState == InvocationState.CLOSED) {
            return;
        }
        LOG.debug("Transitioning state machine to {}", (Object)newInvocationState);
        this.invocationState = newInvocationState;
        this.loggingContextSetter.set("restateInvocationStatus", newInvocationState.toString());
    }

    private void tryTransitionProcessing() {
        if (this.currentJournalEntryIndex == this.entriesToReplay - 1 && this.invocationState == InvocationState.REPLAYING) {
            if (!this.incomingEntriesStateMachine.isEmpty()) {
                throw new IllegalStateException("Entries queue should be empty at this point");
            }
            this.transitionState(InvocationState.PROCESSING);
        }
    }

    private void nextJournalEntry(String entryName, MessageType entryType) {
        ++this.currentJournalEntryIndex;
        this.currentJournalEntryName = entryName;
        this.currentJournalEntryType = entryType;
        LOG.debug("Current journal entry [{}]({}): {}", (Object)this.currentJournalEntryIndex, (Object)this.currentJournalEntryName, (Object)this.currentJournalEntryType);
    }

    private void checkInsideSideEffectGuard() {
        if (this.insideSideEffect) {
            throw ProtocolException.invalidSideEffectCall();
        }
    }

    void readEntry(final Consumer<MessageLite> msgCallback, final Consumer<Throwable> errorCallback) {
        this.incomingEntriesStateMachine.read(new IncomingEntriesStateMachine.OnEntryCallback(){

            @Override
            public void onEntry(MessageLite msg) {
                InvocationStateMachine.this.tryTransitionProcessing();
                msgCallback.accept(msg);
            }

            @Override
            public void onSuspend() {
                errorCallback.accept(ProtocolException.CLOSED);
            }

            @Override
            public void onError(Throwable e) {
                errorCallback.accept(e);
            }
        });
    }

    private void writeEntry(MessageLite message) {
        LOG.trace("Writing to output message {} {}", message.getClass(), (Object)message);
        Objects.requireNonNull(this.outputSubscriber).onNext((MessageLite)message);
    }

    public String toString() {
        return "InvocationStateMachine[" + this.debugId + "]";
    }
}

