/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.sdk.common.InvocationId;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

final class InvocationIdImpl
implements InvocationId {
    private final String id;
    private Long seed;

    InvocationIdImpl(String debugId) {
        this.id = debugId;
        this.seed = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationIdImpl that = (InvocationIdImpl)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public long toRandomSeed() {
        if (this.seed == null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] digest = md.digest(this.id.getBytes(StandardCharsets.UTF_8));
            long n = 0L;
            n |= (long)(digest[7] & 0xFF) << 56;
            n |= (long)(digest[6] & 0xFF) << 48;
            n |= (long)(digest[5] & 0xFF) << 40;
            n |= (long)(digest[4] & 0xFF) << 32;
            n |= (long)(digest[3] & 0xFF) << 24;
            n |= (long)((digest[2] & 0xFF) << 16);
            n |= (long)((digest[1] & 0xFF) << 8);
            this.seed = n |= (long)(digest[0] & 0xFF);
        }
        return this.seed;
    }

    public String toString() {
        return this.id;
    }
}

