/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.MessageLite;
import dev.restate.sdk.core.BaseSuspendableCallbackStateMachine;
import dev.restate.sdk.core.SuspendableCallback;
import dev.restate.sdk.core.Util;
import java.util.ArrayDeque;
import java.util.Queue;

class IncomingEntriesStateMachine
extends BaseSuspendableCallbackStateMachine<OnEntryCallback> {
    private final Queue<MessageLite> unprocessedMessages = new ArrayDeque<MessageLite>();

    IncomingEntriesStateMachine() {
    }

    void offer(MessageLite msg) {
        Util.assertIsEntry(msg);
        this.consumeCallbackOrElse(cb -> cb.onEntry(msg), () -> this.unprocessedMessages.offer(msg));
    }

    void read(OnEntryCallback msgCallback) {
        this.assertCallbackNotSet("Two concurrent reads were requested.");
        MessageLite popped = this.unprocessedMessages.poll();
        if (popped != null) {
            msgCallback.onEntry(popped);
        } else {
            this.setCallback(msgCallback);
        }
    }

    boolean isEmpty() {
        return this.unprocessedMessages.isEmpty();
    }

    @Override
    void abort(Throwable cause) {
        super.abort(cause);
        this.tryFailCallback();
    }

    static interface OnEntryCallback
    extends SuspendableCallback {
        public void onEntry(MessageLite var1);
    }
}

