/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.ByteString;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.EnterSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.ExitSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.core.InvocationState;
import dev.restate.sdk.core.SyscallsInternal;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;

class ExecutorSwitchingSyscalls
implements SyscallsInternal {
    private final SyscallsInternal syscalls;
    private final Executor syscallsExecutor;

    ExecutorSwitchingSyscalls(SyscallsInternal syscalls, Executor syscallsExecutor) {
        this.syscalls = syscalls;
        this.syscallsExecutor = syscallsExecutor;
    }

    public void writeOutput(ByteString value, SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.writeOutput(value, callback));
    }

    public void writeOutput(TerminalException throwable, SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.writeOutput(throwable, callback));
    }

    public void get(String name, SyscallCallback<Deferred<ByteString>> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.get(name, callback));
    }

    public void getKeys(SyscallCallback<Deferred<Collection<String>>> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.getKeys(callback));
    }

    public void clear(String name, SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.clear(name, callback));
    }

    public void clearAll(SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.clearAll(callback));
    }

    public void set(String name, ByteString value, SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.set(name, value, callback));
    }

    public void sleep(Duration duration, SyscallCallback<Deferred<Void>> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.sleep(duration, callback));
    }

    public void call(Target target, ByteString parameter, SyscallCallback<Deferred<ByteString>> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.call(target, parameter, callback));
    }

    public void send(Target target, ByteString parameter, @Nullable Duration delay, SyscallCallback<Void> requestCallback) {
        this.syscallsExecutor.execute(() -> this.syscalls.send(target, parameter, delay, requestCallback));
    }

    public void enterSideEffectBlock(String name, EnterSideEffectSyscallCallback callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.enterSideEffectBlock(name, callback));
    }

    public void exitSideEffectBlock(ByteString toWrite, ExitSideEffectSyscallCallback callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.exitSideEffectBlock(toWrite, callback));
    }

    public void exitSideEffectBlockWithTerminalException(TerminalException toWrite, ExitSideEffectSyscallCallback callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.exitSideEffectBlockWithTerminalException(toWrite, callback));
    }

    public void awakeable(SyscallCallback<Map.Entry<String, Deferred<ByteString>>> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.awakeable(callback));
    }

    public void resolveAwakeable(String id, ByteString payload, SyscallCallback<Void> requestCallback) {
        this.syscallsExecutor.execute(() -> this.syscalls.resolveAwakeable(id, payload, requestCallback));
    }

    public void rejectAwakeable(String id, String reason, SyscallCallback<Void> requestCallback) {
        this.syscallsExecutor.execute(() -> this.syscalls.rejectAwakeable(id, reason, requestCallback));
    }

    public <T> void resolveDeferred(Deferred<T> deferredToResolve, SyscallCallback<Void> callback) {
        this.syscallsExecutor.execute(() -> this.syscalls.resolveDeferred(deferredToResolve, callback));
    }

    @Override
    public String getFullyQualifiedMethodName() {
        return this.syscalls.getFullyQualifiedMethodName();
    }

    @Override
    public InvocationState getInvocationState() {
        return this.syscalls.getInvocationState();
    }

    public String objectKey() {
        return this.syscalls.objectKey();
    }

    public Request request() {
        return this.syscalls.request();
    }

    public boolean isInsideSideEffect() {
        return this.syscalls.isInsideSideEffect();
    }

    @Override
    public void close() {
        this.syscallsExecutor.execute(this.syscalls::close);
    }

    public void fail(Throwable cause) {
        this.syscallsExecutor.execute(() -> this.syscalls.fail(cause));
    }
}

