/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import dev.restate.generated.service.protocol.Protocol;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.Tracing;
import dev.restate.sdk.core.UserStateStore;
import dev.restate.sdk.core.Util;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

final class Entries {
    static final String AWAKEABLE_IDENTIFIER_PREFIX = "prom_1";

    private Entries() {
    }

    static final class CompleteAwakeableEntry
    extends JournalEntry<Protocol.CompleteAwakeableEntryMessage> {
        static final CompleteAwakeableEntry INSTANCE = new CompleteAwakeableEntry();

        private CompleteAwakeableEntry() {
        }

        @Override
        public void trace(Protocol.CompleteAwakeableEntryMessage expected, Span span) {
            span.addEvent("CompleteAwakeable");
        }

        @Override
        String getName(Protocol.CompleteAwakeableEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.CompleteAwakeableEntryMessage expected, MessageLite actual) throws ProtocolException {
            Util.assertEntryEquals((MessageLite)expected, actual);
        }
    }

    static final class AwakeableEntry
    extends CompletableJournalEntry<Protocol.AwakeableEntryMessage, ByteString> {
        static final AwakeableEntry INSTANCE = new AwakeableEntry();

        private AwakeableEntry() {
        }

        @Override
        String getName(Protocol.AwakeableEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void trace(Protocol.AwakeableEntryMessage expected, Span span) {
            span.addEvent("Awakeable");
        }

        @Override
        public boolean hasResult(Protocol.AwakeableEntryMessage actual) {
            return actual.getResultCase() != Protocol.AwakeableEntryMessage.ResultCase.RESULT_NOT_SET;
        }

        @Override
        public Result<ByteString> parseEntryResult(Protocol.AwakeableEntryMessage actual) {
            if (actual.hasValue()) {
                return Result.success((Object)actual.getValue());
            }
            return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
        }

        @Override
        public Result<ByteString> parseCompletionResult(Protocol.CompletionMessage actual) {
            if (actual.hasValue()) {
                return Result.success((Object)actual.getValue());
            }
            if (actual.hasFailure()) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            return super.parseCompletionResult(actual);
        }
    }

    static final class BackgroundInvokeEntry
    extends JournalEntry<Protocol.OneWayCallEntryMessage> {
        static final BackgroundInvokeEntry INSTANCE = new BackgroundInvokeEntry();

        private BackgroundInvokeEntry() {
        }

        @Override
        public void trace(Protocol.OneWayCallEntryMessage expected, Span span) {
            span.addEvent("BackgroundInvoke", Attributes.of(Tracing.RESTATE_COORDINATION_CALL_SERVICE, (Object)expected.getServiceName(), Tracing.RESTATE_COORDINATION_CALL_METHOD, (Object)expected.getHandlerName()));
        }

        @Override
        String getName(Protocol.OneWayCallEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.OneWayCallEntryMessage expected, MessageLite actual) throws ProtocolException {
            Util.assertEntryEquals((MessageLite)expected, actual);
        }
    }

    static final class InvokeEntry<R>
    extends CompletableJournalEntry<Protocol.CallEntryMessage, R> {
        private final Function<ByteString, Result<R>> valueParser;

        InvokeEntry(Function<ByteString, Result<R>> valueParser) {
            this.valueParser = valueParser;
        }

        @Override
        void trace(Protocol.CallEntryMessage expected, Span span) {
            span.addEvent("Invoke", Attributes.of(Tracing.RESTATE_COORDINATION_CALL_SERVICE, (Object)expected.getServiceName(), Tracing.RESTATE_COORDINATION_CALL_METHOD, (Object)expected.getHandlerName()));
        }

        @Override
        public boolean hasResult(Protocol.CallEntryMessage actual) {
            return actual.getResultCase() != Protocol.CallEntryMessage.ResultCase.RESULT_NOT_SET;
        }

        @Override
        String getName(Protocol.CallEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.CallEntryMessage expected, MessageLite actual) throws ProtocolException {
            if (!(actual instanceof Protocol.CallEntryMessage)) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
            Protocol.CallEntryMessage actualInvoke = (Protocol.CallEntryMessage)actual;
            if (!(expected.getServiceName().equals(actualInvoke.getServiceName()) && expected.getHandlerName().equals(actualInvoke.getHandlerName()) && expected.getParameter().equals((Object)actualInvoke.getParameter()))) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, (MessageLite)actualInvoke);
            }
        }

        @Override
        public Result<R> parseEntryResult(Protocol.CallEntryMessage actual) {
            if (actual.hasValue()) {
                return this.valueParser.apply(actual.getValue());
            }
            return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
        }

        @Override
        public Result<R> parseCompletionResult(Protocol.CompletionMessage actual) {
            if (actual.hasValue()) {
                return this.valueParser.apply(actual.getValue());
            }
            if (actual.hasFailure()) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            return super.parseCompletionResult(actual);
        }
    }

    static final class SleepEntry
    extends CompletableJournalEntry<Protocol.SleepEntryMessage, Void> {
        static final SleepEntry INSTANCE = new SleepEntry();

        private SleepEntry() {
        }

        @Override
        String getName(Protocol.SleepEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void trace(Protocol.SleepEntryMessage expected, Span span) {
            span.addEvent("Sleep", Attributes.of(Tracing.RESTATE_SLEEP_WAKE_UP_TIME, (Object)expected.getWakeUpTime()));
        }

        @Override
        public boolean hasResult(Protocol.SleepEntryMessage actual) {
            return actual.getResultCase() != Protocol.SleepEntryMessage.ResultCase.RESULT_NOT_SET;
        }

        @Override
        public Result<Void> parseEntryResult(Protocol.SleepEntryMessage actual) {
            if (actual.getResultCase() == Protocol.SleepEntryMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            if (actual.getResultCase() == Protocol.SleepEntryMessage.ResultCase.EMPTY) {
                return Result.empty();
            }
            throw new IllegalStateException("SleepEntry has not been completed.");
        }

        @Override
        public Result<Void> parseCompletionResult(Protocol.CompletionMessage actual) {
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.EMPTY) {
                return Result.empty();
            }
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            return super.parseCompletionResult(actual);
        }
    }

    static final class SetStateEntry
    extends JournalEntry<Protocol.SetStateEntryMessage> {
        static final SetStateEntry INSTANCE = new SetStateEntry();

        private SetStateEntry() {
        }

        @Override
        public void trace(Protocol.SetStateEntryMessage expected, Span span) {
            span.addEvent("SetState", Attributes.of(Tracing.RESTATE_STATE_KEY, (Object)expected.getKey().toString()));
        }

        @Override
        String getName(Protocol.SetStateEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.SetStateEntryMessage expected, MessageLite actual) throws ProtocolException {
            if (!(actual instanceof Protocol.SetStateEntryMessage)) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
            if (!expected.getKey().equals((Object)((Protocol.SetStateEntryMessage)actual).getKey())) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
        }

        @Override
        void updateUserStateStoreWithEntry(Protocol.SetStateEntryMessage expected, UserStateStore userStateStore) {
            userStateStore.set(expected.getKey(), expected.getValue());
        }
    }

    static final class ClearAllStateEntry
    extends JournalEntry<Protocol.ClearAllStateEntryMessage> {
        static final ClearAllStateEntry INSTANCE = new ClearAllStateEntry();

        private ClearAllStateEntry() {
        }

        @Override
        public void trace(Protocol.ClearAllStateEntryMessage expected, Span span) {
            span.addEvent("ClearAllState");
        }

        @Override
        String getName(Protocol.ClearAllStateEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.ClearAllStateEntryMessage expected, MessageLite actual) throws ProtocolException {
            Util.assertEntryEquals((MessageLite)expected, actual);
        }

        @Override
        void updateUserStateStoreWithEntry(Protocol.ClearAllStateEntryMessage expected, UserStateStore userStateStore) {
            userStateStore.clearAll();
        }
    }

    static final class ClearStateEntry
    extends JournalEntry<Protocol.ClearStateEntryMessage> {
        static final ClearStateEntry INSTANCE = new ClearStateEntry();

        private ClearStateEntry() {
        }

        @Override
        public void trace(Protocol.ClearStateEntryMessage expected, Span span) {
            span.addEvent("ClearState", Attributes.of(Tracing.RESTATE_STATE_KEY, (Object)expected.getKey().toString()));
        }

        @Override
        String getName(Protocol.ClearStateEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.ClearStateEntryMessage expected, MessageLite actual) throws ProtocolException {
            Util.assertEntryEquals((MessageLite)expected, actual);
        }

        @Override
        void updateUserStateStoreWithEntry(Protocol.ClearStateEntryMessage expected, UserStateStore userStateStore) {
            userStateStore.clear(expected.getKey());
        }
    }

    static final class GetStateKeysEntry
    extends CompletableJournalEntry<Protocol.GetStateKeysEntryMessage, Collection<String>> {
        static final GetStateKeysEntry INSTANCE = new GetStateKeysEntry();

        private GetStateKeysEntry() {
        }

        @Override
        void trace(Protocol.GetStateKeysEntryMessage expected, Span span) {
            span.addEvent("GetStateKeys");
        }

        @Override
        public boolean hasResult(Protocol.GetStateKeysEntryMessage actual) {
            return actual.getResultCase() != Protocol.GetStateKeysEntryMessage.ResultCase.RESULT_NOT_SET;
        }

        @Override
        String getName(Protocol.GetStateKeysEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.GetStateKeysEntryMessage expected, MessageLite actual) throws ProtocolException {
            if (!(actual instanceof Protocol.GetStateKeysEntryMessage)) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
        }

        @Override
        public Result<Collection<String>> parseEntryResult(Protocol.GetStateKeysEntryMessage actual) {
            if (actual.getResultCase() == Protocol.GetStateKeysEntryMessage.ResultCase.VALUE) {
                return Result.success((Object)actual.getValue().getKeysList().stream().map(ByteString::toStringUtf8).collect(Collectors.toUnmodifiableList()));
            }
            if (actual.getResultCase() == Protocol.GetStateKeysEntryMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            throw new IllegalStateException("GetStateKeysEntryMessage has not been completed.");
        }

        @Override
        public Result<Collection<String>> parseCompletionResult(Protocol.CompletionMessage actual) {
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.VALUE) {
                Protocol.GetStateKeysEntryMessage.StateKeys stateKeys;
                try {
                    stateKeys = Protocol.GetStateKeysEntryMessage.StateKeys.parseFrom(actual.getValue());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new ProtocolException("Cannot parse get state keys completion", 571, e);
                }
                return Result.success((Object)stateKeys.getKeysList().stream().map(ByteString::toStringUtf8).collect(Collectors.toUnmodifiableList()));
            }
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            return super.parseCompletionResult(actual);
        }

        @Override
        Protocol.GetStateKeysEntryMessage tryCompleteWithUserStateStorage(Protocol.GetStateKeysEntryMessage expected, UserStateStore userStateStore) {
            if (userStateStore.isComplete()) {
                return expected.toBuilder().setValue(Protocol.GetStateKeysEntryMessage.StateKeys.newBuilder().addAllKeys(userStateStore.keys())).build();
            }
            return expected;
        }
    }

    static final class GetStateEntry
    extends CompletableJournalEntry<Protocol.GetStateEntryMessage, ByteString> {
        static final GetStateEntry INSTANCE = new GetStateEntry();

        private GetStateEntry() {
        }

        @Override
        void trace(Protocol.GetStateEntryMessage expected, Span span) {
            span.addEvent("GetState", Attributes.of(Tracing.RESTATE_STATE_KEY, (Object)expected.getKey().toString()));
        }

        @Override
        public boolean hasResult(Protocol.GetStateEntryMessage actual) {
            return actual.getResultCase() != Protocol.GetStateEntryMessage.ResultCase.RESULT_NOT_SET;
        }

        @Override
        String getName(Protocol.GetStateEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.GetStateEntryMessage expected, MessageLite actual) throws ProtocolException {
            if (!(actual instanceof Protocol.GetStateEntryMessage)) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
            if (!expected.getKey().equals((Object)((Protocol.GetStateEntryMessage)actual).getKey())) {
                throw ProtocolException.entryDoesNotMatch((MessageLite)expected, actual);
            }
        }

        @Override
        public Result<ByteString> parseEntryResult(Protocol.GetStateEntryMessage actual) {
            if (actual.getResultCase() == Protocol.GetStateEntryMessage.ResultCase.VALUE) {
                return Result.success((Object)actual.getValue());
            }
            if (actual.getResultCase() == Protocol.GetStateEntryMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            if (actual.getResultCase() == Protocol.GetStateEntryMessage.ResultCase.EMPTY) {
                return Result.empty();
            }
            throw new IllegalStateException("GetStateEntry has not been completed.");
        }

        @Override
        public Result<ByteString> parseCompletionResult(Protocol.CompletionMessage actual) {
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.VALUE) {
                return Result.success((Object)actual.getValue());
            }
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.EMPTY) {
                return Result.empty();
            }
            if (actual.getResultCase() == Protocol.CompletionMessage.ResultCase.FAILURE) {
                return Result.failure((TerminalException)Util.toRestateException(actual.getFailure()));
            }
            return super.parseCompletionResult(actual);
        }

        @Override
        void updateUserStateStoreWithEntry(Protocol.GetStateEntryMessage expected, UserStateStore userStateStore) {
            userStateStore.set(expected.getKey(), expected.getValue());
        }

        @Override
        Protocol.GetStateEntryMessage tryCompleteWithUserStateStorage(Protocol.GetStateEntryMessage expected, UserStateStore userStateStore) {
            UserStateStore.State value = userStateStore.get(expected.getKey());
            if (value instanceof UserStateStore.Value) {
                return expected.toBuilder().setValue(((UserStateStore.Value)value).getValue()).build();
            }
            if (value instanceof UserStateStore.Empty) {
                return expected.toBuilder().setEmpty(Protocol.Empty.getDefaultInstance()).build();
            }
            return expected;
        }

        @Override
        void updateUserStateStorageWithCompletion(Protocol.GetStateEntryMessage expected, Protocol.CompletionMessage actual, UserStateStore userStateStore) {
            if (actual.hasEmpty()) {
                userStateStore.clear(expected.getKey());
            } else {
                userStateStore.set(expected.getKey(), actual.getValue());
            }
        }
    }

    static final class OutputEntry
    extends JournalEntry<Protocol.OutputEntryMessage> {
        static final OutputEntry INSTANCE = new OutputEntry();

        private OutputEntry() {
        }

        @Override
        String getName(Protocol.OutputEntryMessage expected) {
            return expected.getName();
        }

        @Override
        void checkEntryHeader(Protocol.OutputEntryMessage expected, MessageLite actual) throws ProtocolException {
            Util.assertEntryEquals((MessageLite)expected, actual);
        }

        @Override
        public void trace(Protocol.OutputEntryMessage expected, Span span) {
            span.addEvent("Output");
        }
    }

    static abstract class CompletableJournalEntry<E extends MessageLite, R>
    extends JournalEntry<E> {
        CompletableJournalEntry() {
        }

        abstract boolean hasResult(E var1);

        abstract Result<R> parseEntryResult(E var1);

        Result<R> parseCompletionResult(Protocol.CompletionMessage actual) {
            throw ProtocolException.completionDoesNotMatch(this.getClass().getName(), actual.getResultCase());
        }

        E tryCompleteWithUserStateStorage(E expected, UserStateStore userStateStore) {
            return expected;
        }

        void updateUserStateStorageWithCompletion(E expected, Protocol.CompletionMessage actual, UserStateStore userStateStore) {
        }
    }

    static abstract class JournalEntry<E extends MessageLite> {
        JournalEntry() {
        }

        abstract String getName(E var1);

        void checkEntryHeader(E expected, MessageLite actual) throws ProtocolException {
        }

        abstract void trace(E var1, Span var2);

        void updateUserStateStoreWithEntry(E expected, UserStateStore userStateStore) {
        }
    }
}

