/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.Result;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

abstract class DeferredResults {
    private DeferredResults() {
    }

    static <T> DeferredInternal<T> single(int entryIndex) {
        return new ResolvableSingleDeferred(null, entryIndex);
    }

    static <T> DeferredInternal<T> completedSingle(int entryIndex, Result<T> result) {
        return new ResolvableSingleDeferred<T>(result, entryIndex);
    }

    static DeferredInternal<Integer> any(List<DeferredInternal<?>> any) {
        return new AnyDeferred(any);
    }

    static DeferredInternal<Void> all(List<DeferredInternal<?>> all) {
        return new AllDeferred(all);
    }

    static class AllDeferred
    extends CombinatorDeferred<Void> {
        private AllDeferred(List<DeferredInternal<?>> children) {
            super(children.stream().filter(d -> d instanceof SingleDeferredInternal).map(d -> (SingleDeferredInternal)d).collect(Collectors.toMap(SingleDeferredInternal::entryIndex, Function.identity(), (v1, v2) -> v1, HashMap::new)), children.stream().filter(d -> d instanceof CombinatorDeferred).map(d -> (CombinatorDeferred)d).collect(Collectors.toCollection(HashSet::new)));
        }

        @Override
        boolean tryResolve(int newResolvedSingle) {
            if (this.isCompleted()) {
                return true;
            }
            SingleDeferredInternal resolvedSingle = (SingleDeferredInternal)this.unresolvedSingles.remove(newResolvedSingle);
            if (resolvedSingle != null && !resolvedSingle.toResult().isSuccess()) {
                this.resolve(resolvedSingle.toResult());
                return true;
            }
            Iterator it = this.unresolvedCombinators.iterator();
            while (it.hasNext()) {
                CombinatorDeferred combinator = (CombinatorDeferred)it.next();
                if (!combinator.tryResolve(newResolvedSingle)) continue;
                it.remove();
                if (combinator.toResult().isSuccess()) continue;
                this.resolve(combinator.toResult());
                return true;
            }
            if (this.unresolvedSingles.isEmpty() && this.unresolvedCombinators.isEmpty()) {
                this.resolve(Result.empty());
                return true;
            }
            return false;
        }
    }

    static class AnyDeferred
    extends CombinatorDeferred<Integer>
    implements Deferred<Integer> {
        private final IdentityHashMap<DeferredInternal<?>, Integer> indexMapping = new IdentityHashMap();

        private AnyDeferred(List<DeferredInternal<?>> children) {
            super(children.stream().filter(d -> d instanceof SingleDeferredInternal).map(d -> (SingleDeferredInternal)d).collect(Collectors.toMap(SingleDeferredInternal::entryIndex, Function.identity())), children.stream().filter(d -> d instanceof CombinatorDeferred).map(d -> (CombinatorDeferred)d).collect(Collectors.toSet()));
            for (int i = 0; i < children.size(); ++i) {
                this.indexMapping.put(children.get(i), i);
            }
        }

        @Override
        boolean tryResolve(int newResolvedSingle) {
            if (this.isCompleted()) {
                return true;
            }
            SingleDeferredInternal resolvedSingle = (SingleDeferredInternal)this.unresolvedSingles.get(newResolvedSingle);
            if (resolvedSingle != null) {
                this.resolve(Result.success((Object)this.indexMapping.get(resolvedSingle)));
                return true;
            }
            for (CombinatorDeferred combinator : this.unresolvedCombinators) {
                if (!combinator.tryResolve(newResolvedSingle)) continue;
                this.resolve(Result.success((Object)this.indexMapping.get(combinator)));
                return true;
            }
            return false;
        }
    }

    static abstract class CombinatorDeferred<T>
    extends BaseDeferred<T> {
        protected final Map<Integer, SingleDeferredInternal<?>> unresolvedSingles;
        protected final Set<CombinatorDeferred<?>> unresolvedCombinators;

        CombinatorDeferred(Map<Integer, SingleDeferredInternal<?>> unresolvedSingles, Set<CombinatorDeferred<?>> unresolvedCombinators) {
            super(null);
            this.unresolvedSingles = unresolvedSingles;
            this.unresolvedCombinators = unresolvedCombinators;
        }

        abstract boolean tryResolve(int var1);

        boolean tryResolve(List<Integer> resolvedSingle) {
            boolean resolved = false;
            for (int newResolvedSingle : resolvedSingle) {
                resolved = this.tryResolve(newResolvedSingle);
            }
            return resolved;
        }

        @Override
        public Stream<SingleDeferredInternal<?>> unprocessedLeafs() {
            return Stream.concat(this.unresolvedSingles.values().stream(), this.unresolvedCombinators.stream().flatMap(CombinatorDeferred::unprocessedLeafs));
        }
    }

    static class ResolvableSingleDeferred<T>
    extends BaseDeferred<T>
    implements SingleDeferredInternal<T> {
        private final int entryIndex;

        private ResolvableSingleDeferred(@Nullable Result<T> result, int entryIndex) {
            super(result);
            this.entryIndex = entryIndex;
        }

        @Override
        public int entryIndex() {
            return this.entryIndex;
        }

        @Override
        public Stream<SingleDeferredInternal<?>> unprocessedLeafs() {
            return Stream.of(this);
        }
    }

    private static abstract class BaseDeferred<T>
    implements DeferredInternal<T> {
        private @Nullable Result<T> readyResult;

        BaseDeferred(@Nullable Result<T> result) {
            this.readyResult = result;
        }

        public boolean isCompleted() {
            return this.readyResult != null;
        }

        public void resolve(Result<T> result) {
            this.readyResult = result;
        }

        @Override
        public @Nullable Result<T> toResult() {
            return this.readyResult;
        }
    }

    static interface SingleDeferredInternal<T>
    extends DeferredInternal<T> {
        public int entryIndex();
    }

    static interface DeferredInternal<T>
    extends Deferred<T> {
        public @Nullable Result<T> toResult();

        public Stream<SingleDeferredInternal<?>> unprocessedLeafs();
    }
}

