/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.core;

import dev.restate.sdk.core.CallbackHandle;
import dev.restate.sdk.core.InputPublisherState;
import dev.restate.sdk.core.SuspendableCallback;
import java.util.function.Consumer;

abstract class BaseSuspendableCallbackStateMachine<CB extends SuspendableCallback> {
    private final CallbackHandle<CB> callbackHandle = new CallbackHandle();
    private final InputPublisherState inputPublisherState = new InputPublisherState();

    BaseSuspendableCallbackStateMachine() {
    }

    void abort(Throwable cause) {
        this.inputPublisherState.notifyClosed(cause);
    }

    public void tryFailCallback() {
        this.callbackHandle.consume(cb -> {
            if (this.inputPublisherState.isSuspended()) {
                cb.onSuspend();
            } else if (this.inputPublisherState.isClosed()) {
                cb.onError(this.inputPublisherState.getCloseCause());
            }
        });
    }

    public void consumeCallback(Consumer<CB> consumer) {
        this.callbackHandle.consume(consumer);
    }

    public void consumeCallbackOrElse(Consumer<CB> consumer, Runnable elseRunnable) {
        this.callbackHandle.consumeOrElse(consumer, elseRunnable);
    }

    public void assertCallbackNotSet(String reason) {
        if (!this.callbackHandle.isEmpty()) {
            throw new IllegalStateException(reason);
        }
    }

    void setCallback(CB callback) {
        if (this.inputPublisherState.isSuspended()) {
            callback.onSuspend();
        } else if (this.inputPublisherState.isClosed()) {
            callback.onError(this.inputPublisherState.getCloseCause());
        } else {
            this.callbackHandle.set(callback);
        }
    }
}

