
package dev.restate.sdk.core.manifest;

import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * OutputPayload
 * <p>
 * Description of an output payload.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "contentType",
    "setContentTypeIfEmpty",
    "jsonSchema"
})
@Generated("jsonschema2pojo")
public class Output {

    /**
     * Content type set on output. This will be used by Restate to set the output content type at the ingress.
     * 
     */
    @JsonProperty("contentType")
    @JsonPropertyDescription("Content type set on output. This will be used by Restate to set the output content type at the ingress.")
    private String contentType;
    /**
     * If true, the specified content-type is set even if the output is empty.
     * 
     */
    @JsonProperty("setContentTypeIfEmpty")
    @JsonPropertyDescription("If true, the specified content-type is set even if the output is empty.")
    private Boolean setContentTypeIfEmpty;
    @JsonProperty("jsonSchema")
    private Object jsonSchema;

    /**
     * Content type set on output. This will be used by Restate to set the output content type at the ingress.
     * 
     */
    @JsonProperty("contentType")
    public String getContentType() {
        return contentType;
    }

    /**
     * Content type set on output. This will be used by Restate to set the output content type at the ingress.
     * 
     */
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Output withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * If true, the specified content-type is set even if the output is empty.
     * 
     */
    @JsonProperty("setContentTypeIfEmpty")
    public Boolean getSetContentTypeIfEmpty() {
        return setContentTypeIfEmpty;
    }

    /**
     * If true, the specified content-type is set even if the output is empty.
     * 
     */
    @JsonProperty("setContentTypeIfEmpty")
    public void setSetContentTypeIfEmpty(Boolean setContentTypeIfEmpty) {
        this.setContentTypeIfEmpty = setContentTypeIfEmpty;
    }

    public Output withSetContentTypeIfEmpty(Boolean setContentTypeIfEmpty) {
        this.setContentTypeIfEmpty = setContentTypeIfEmpty;
        return this;
    }

    @JsonProperty("jsonSchema")
    public Object getJsonSchema() {
        return jsonSchema;
    }

    @JsonProperty("jsonSchema")
    public void setJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public Output withJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Output.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("setContentTypeIfEmpty");
        sb.append('=');
        sb.append(((this.setContentTypeIfEmpty == null)?"<null>":this.setContentTypeIfEmpty));
        sb.append(',');
        sb.append("jsonSchema");
        sb.append('=');
        sb.append(((this.jsonSchema == null)?"<null>":this.jsonSchema));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.setContentTypeIfEmpty == null)? 0 :this.setContentTypeIfEmpty.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.jsonSchema == null)? 0 :this.jsonSchema.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Output) == false) {
            return false;
        }
        Output rhs = ((Output) other);
        return ((((this.setContentTypeIfEmpty == rhs.setContentTypeIfEmpty)||((this.setContentTypeIfEmpty!= null)&&this.setContentTypeIfEmpty.equals(rhs.setContentTypeIfEmpty)))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))))&&((this.jsonSchema == rhs.jsonSchema)||((this.jsonSchema!= null)&&this.jsonSchema.equals(rhs.jsonSchema))));
    }

}
