
package dev.restate.sdk.core.manifest;

import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * InputPayload
 * <p>
 * Description of an input payload. This will be used by Restate to validate incoming requests.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "required",
    "contentType",
    "jsonSchema"
})
@Generated("jsonschema2pojo")
public class Input {

    /**
     * If true, a body MUST be sent with a content-type, even if the body length is zero.
     * 
     */
    @JsonProperty("required")
    @JsonPropertyDescription("If true, a body MUST be sent with a content-type, even if the body length is zero.")
    private Boolean required;
    /**
     * Content type of the input. It can accept wildcards, in the same format as the 'Accept' header. When this field is unset, it implies emptiness, meaning no content-type/body is expected.
     * 
     */
    @JsonProperty("contentType")
    @JsonPropertyDescription("Content type of the input. It can accept wildcards, in the same format as the 'Accept' header. When this field is unset, it implies emptiness, meaning no content-type/body is expected.")
    private String contentType;
    @JsonProperty("jsonSchema")
    private Object jsonSchema;

    /**
     * If true, a body MUST be sent with a content-type, even if the body length is zero.
     * 
     */
    @JsonProperty("required")
    public Boolean getRequired() {
        return required;
    }

    /**
     * If true, a body MUST be sent with a content-type, even if the body length is zero.
     * 
     */
    @JsonProperty("required")
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Input withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Content type of the input. It can accept wildcards, in the same format as the 'Accept' header. When this field is unset, it implies emptiness, meaning no content-type/body is expected.
     * 
     */
    @JsonProperty("contentType")
    public String getContentType() {
        return contentType;
    }

    /**
     * Content type of the input. It can accept wildcards, in the same format as the 'Accept' header. When this field is unset, it implies emptiness, meaning no content-type/body is expected.
     * 
     */
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Input withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty("jsonSchema")
    public Object getJsonSchema() {
        return jsonSchema;
    }

    @JsonProperty("jsonSchema")
    public void setJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public Input withJsonSchema(Object jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Input.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("required");
        sb.append('=');
        sb.append(((this.required == null)?"<null>":this.required));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("jsonSchema");
        sb.append('=');
        sb.append(((this.jsonSchema == null)?"<null>":this.jsonSchema));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.jsonSchema == null)? 0 :this.jsonSchema.hashCode()));
        result = ((result* 31)+((this.required == null)? 0 :this.required.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Input) == false) {
            return false;
        }
        Input rhs = ((Input) other);
        return ((((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType)))&&((this.jsonSchema == rhs.jsonSchema)||((this.jsonSchema!= null)&&this.jsonSchema.equals(rhs.jsonSchema))))&&((this.required == rhs.required)||((this.required!= null)&&this.required.equals(rhs.required))));
    }

}
