/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk;

import com.google.protobuf.ByteString;
import dev.restate.sdk.common.AbortedExecutionException;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.function.ThrowingFunction;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.common.syscalls.Syscalls;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

class Util {
    private Util() {
    }

    static <T> T blockOnResolve(Syscalls syscalls, Deferred<T> deferred) {
        if (!deferred.isCompleted()) {
            Util.blockOnSyscall(cb -> syscalls.resolveDeferred(deferred, cb));
        }
        return Util.unwrapResult(deferred.toResult());
    }

    static <T> T awaitCompletableFuture(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | CancellationException e) {
            AbortedExecutionException.sneakyThrow();
            return null;
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    static <T> T blockOnSyscall(Consumer<SyscallCallback<T>> syscallExecutor) {
        CompletableFuture fut = new CompletableFuture();
        syscallExecutor.accept(SyscallCallback.completingFuture(fut));
        return Util.awaitCompletableFuture(fut);
    }

    static <T> T unwrapResult(Result<T> res) {
        if (res.isSuccess()) {
            return (T)res.getValue();
        }
        throw res.getFailure();
    }

    static <T> Optional<T> unwrapOptionalReadyResult(Result<T> res) {
        if (!res.isSuccess()) {
            throw res.getFailure();
        }
        if (res.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(res.getValue());
    }

    static <T, R> R executeMappingException(Syscalls syscalls, ThrowingFunction<T, R> fn, T t) {
        try {
            return (R)fn.apply(t);
        }
        catch (Throwable e) {
            syscalls.fail(e);
            AbortedExecutionException.sneakyThrow();
            return null;
        }
    }

    static <T> ByteString serializeWrappingException(Syscalls syscalls, Serde<T> serde, T value) {
        return (ByteString)Util.executeMappingException(syscalls, arg_0 -> serde.serializeToByteString(arg_0), value);
    }

    static <T> T deserializeWrappingException(Syscalls syscalls, Serde<T> serde, ByteString byteString) {
        return (T)Util.executeMappingException(syscalls, arg_0 -> serde.deserialize(arg_0), byteString);
    }
}

