/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk;

import com.google.protobuf.ByteString;
import dev.restate.sdk.Context;
import dev.restate.sdk.ContextImpl;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.SharedObjectContext;
import dev.restate.sdk.common.BindableService;
import dev.restate.sdk.common.HandlerType;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.HandlerDefinition;
import dev.restate.sdk.common.syscalls.InvocationHandler;
import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.common.syscalls.SyscallCallback;
import dev.restate.sdk.common.syscalls.Syscalls;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Service
implements BindableService<Options> {
    private final ServiceDefinition<Options> serviceDefinition;
    private final Options options;

    private Service(String fqsn, boolean isKeyed, HashMap<String, Handler<?, ?>> handlers, Options options) {
        this.serviceDefinition = new ServiceDefinition(fqsn, isKeyed ? ServiceType.VIRTUAL_OBJECT : ServiceType.SERVICE, (Collection)handlers.values().stream().map(Handler::toHandlerDefinition).collect(Collectors.toList()));
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public List<ServiceDefinition<Options>> definitions() {
        return List.of(this.serviceDefinition);
    }

    public static ServiceBuilder service(String name) {
        return new ServiceBuilder(name);
    }

    public static VirtualObjectBuilder virtualObject(String name) {
        return new VirtualObjectBuilder(name);
    }

    public static class Options {
        public static final Options DEFAULT = new Options(Executors.newCachedThreadPool());
        private final Executor executor;

        public Options(Executor executor) {
            this.executor = executor;
        }
    }

    public static class HandlerSignature<REQ, RES> {
        private final String name;
        private final Serde<REQ> requestSerde;
        private final Serde<RES> responseSerde;

        HandlerSignature(String name, Serde<REQ> requestSerde, Serde<RES> responseSerde) {
            this.name = name;
            this.requestSerde = requestSerde;
            this.responseSerde = responseSerde;
        }

        public static <T, R> HandlerSignature<T, R> of(String method, Serde<T> requestSerde, Serde<R> responseSerde) {
            return new HandlerSignature<T, R>(method, requestSerde, responseSerde);
        }

        public String getName() {
            return this.name;
        }

        public Serde<REQ> getRequestSerde() {
            return this.requestSerde;
        }

        public Serde<RES> getResponseSerde() {
            return this.responseSerde;
        }
    }

    public static class Handler<REQ, RES>
    implements InvocationHandler<Options> {
        private final HandlerSignature<REQ, RES> handlerSignature;
        private final HandlerType handlerType;
        private final BiFunction<Context, REQ, RES> runner;
        private static final Logger LOG = LogManager.getLogger(Handler.class);

        public Handler(HandlerSignature<REQ, RES> handlerSignature, HandlerType handlerType, BiFunction<? extends Context, REQ, RES> runner) {
            this.handlerSignature = handlerSignature;
            this.handlerType = handlerType;
            this.runner = runner;
        }

        public HandlerSignature<REQ, RES> getHandlerSignature() {
            return this.handlerSignature;
        }

        public BiFunction<Context, REQ, RES> getRunner() {
            return this.runner;
        }

        public HandlerDefinition<Options> toHandlerDefinition() {
            return new HandlerDefinition(this.handlerSignature.name, this.handlerType, this.handlerSignature.requestSerde.contentType() != null, this.handlerSignature.requestSerde.contentType(), this.handlerSignature.responseSerde.contentType(), (InvocationHandler)this);
        }

        public void handle(Syscalls syscalls, Options options, SyscallCallback<ByteString> callback) {
            Executor wrapped = runnable -> options.executor.execute(() -> {
                SYSCALLS_THREAD_LOCAL.set(syscalls);
                try (Scope ignored = syscalls.request().otelContext().makeCurrent();){
                    runnable.run();
                }
                finally {
                    SYSCALLS_THREAD_LOCAL.remove();
                }
            });
            wrapped.execute(() -> {
                ByteString serializedResult;
                RES res;
                Object req;
                ContextImpl ctx = new ContextImpl(syscalls);
                try {
                    req = this.handlerSignature.requestSerde.deserialize(syscalls.request().bodyBuffer());
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn("Cannot deserialize input", e);
                    callback.onCancel((Throwable)new TerminalException(400, "Cannot deserialize input: " + e.getMessage()));
                    return;
                }
                try {
                    res = this.runner.apply(ctx, req);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    callback.onCancel(e);
                    return;
                }
                try {
                    serializedResult = this.handlerSignature.responseSerde.serializeToByteString(res);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn("Cannot serialize output", e);
                    callback.onCancel((Throwable)new TerminalException(500, "Cannot serialize output: " + e.getMessage()));
                    return;
                }
                callback.onSuccess((Object)serializedResult);
            });
        }
    }

    public static class ServiceBuilder
    extends AbstractServiceBuilder {
        ServiceBuilder(String name) {
            super(name);
        }

        public <REQ, RES> ServiceBuilder with(HandlerSignature<REQ, RES> sig, BiFunction<Context, REQ, RES> runner) {
            this.handlers.put(sig.getName(), new Handler<REQ, RES>(sig, HandlerType.SHARED, runner));
            return this;
        }

        public Service build(Options options) {
            return new Service(this.name, false, this.handlers, options);
        }
    }

    public static class VirtualObjectBuilder
    extends AbstractServiceBuilder {
        VirtualObjectBuilder(String name) {
            super(name);
        }

        public <REQ, RES> VirtualObjectBuilder withShared(HandlerSignature<REQ, RES> sig, BiFunction<SharedObjectContext, REQ, RES> runner) {
            this.handlers.put(sig.getName(), new Handler<REQ, RES>(sig, HandlerType.SHARED, runner));
            return this;
        }

        public <REQ, RES> VirtualObjectBuilder withExclusive(HandlerSignature<REQ, RES> sig, BiFunction<ObjectContext, REQ, RES> runner) {
            this.handlers.put(sig.getName(), new Handler<REQ, RES>(sig, HandlerType.EXCLUSIVE, runner));
            return this;
        }

        public Service build(Options options) {
            return new Service(this.name, true, this.handlers, options);
        }
    }

    public static class AbstractServiceBuilder {
        protected final String name;
        protected final HashMap<String, Handler<?, ?>> handlers;

        public AbstractServiceBuilder(String name) {
            this.name = name;
            this.handlers = new HashMap();
        }
    }
}

