/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk;

import dev.restate.sdk.common.syscalls.Syscalls;
import java.util.Random;
import java.util.UUID;

public class RestateRandom
extends Random {
    private final Syscalls syscalls;
    private boolean seedInitialized = false;

    RestateRandom(long randomSeed, Syscalls syscalls) {
        super(randomSeed);
        this.syscalls = syscalls;
    }

    @Override
    public synchronized void setSeed(long seed) {
        if (this.seedInitialized) {
            throw new UnsupportedOperationException("You cannot set the seed on RestateRandom");
        }
        super.setSeed(seed);
        this.seedInitialized = true;
    }

    public UUID nextUUID() {
        return new UUID(this.nextLong(), this.nextLong());
    }

    @Override
    protected int next(int bits) {
        if (this.syscalls.isInsideSideEffect()) {
            throw new IllegalStateException("You can't use RestateRandom inside ctx.run!");
        }
        return super.next(bits);
    }
}

