/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk;

import com.google.protobuf.ByteString;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Awakeable;
import dev.restate.sdk.AwakeableHandle;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.RestateRandom;
import dev.restate.sdk.Util;
import dev.restate.sdk.common.AbortedExecutionException;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.function.ThrowingSupplier;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.EnterSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.ExitSideEffectSyscallCallback;
import dev.restate.sdk.common.syscalls.Syscalls;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class ContextImpl
implements ObjectContext {
    private final Syscalls syscalls;

    ContextImpl(Syscalls syscalls) {
        this.syscalls = syscalls;
    }

    @Override
    public String key() {
        return this.syscalls.objectKey();
    }

    @Override
    public Request request() {
        return this.syscalls.request();
    }

    @Override
    public <T> Optional<T> get(StateKey<T> key) {
        Deferred deferred = (Deferred)Util.blockOnSyscall(cb -> this.syscalls.get(key.name(), cb));
        if (!deferred.isCompleted()) {
            Util.blockOnSyscall(cb -> this.syscalls.resolveDeferred(deferred, cb));
        }
        return Util.unwrapOptionalReadyResult(deferred.toResult()).map(bs -> Util.deserializeWrappingException(this.syscalls, key.serde(), bs));
    }

    @Override
    public Collection<String> stateKeys() {
        Deferred deferred = (Deferred)Util.blockOnSyscall(arg_0 -> ((Syscalls)this.syscalls).getKeys(arg_0));
        if (!deferred.isCompleted()) {
            Util.blockOnSyscall(cb -> this.syscalls.resolveDeferred(deferred, cb));
        }
        return (Collection)Util.unwrapResult(deferred.toResult());
    }

    @Override
    public void clear(StateKey<?> key) {
        Util.blockOnSyscall(cb -> this.syscalls.clear(key.name(), cb));
    }

    @Override
    public void clearAll() {
        Util.blockOnSyscall(arg_0 -> ((Syscalls)this.syscalls).clearAll(arg_0));
    }

    @Override
    public <T> void set(StateKey<T> key, @NonNull T value) {
        Util.blockOnSyscall(cb -> this.syscalls.set(key.name(), Util.serializeWrappingException(this.syscalls, key.serde(), value), cb));
    }

    @Override
    public Awaitable<Void> timer(Duration duration) {
        Deferred result = (Deferred)Util.blockOnSyscall(cb -> this.syscalls.sleep(duration, cb));
        return Awaitable.single(this.syscalls, result);
    }

    @Override
    public <T, R> Awaitable<R> call(Target target, Serde<T> inputSerde, Serde<R> outputSerde, T parameter) {
        ByteString input = Util.serializeWrappingException(this.syscalls, inputSerde, parameter);
        Deferred result = (Deferred)Util.blockOnSyscall(cb -> this.syscalls.call(target, input, cb));
        return Awaitable.single(this.syscalls, result).map(bs -> Util.deserializeWrappingException(this.syscalls, outputSerde, bs));
    }

    @Override
    public <T> void send(Target target, Serde<T> inputSerde, T parameter) {
        ByteString input = Util.serializeWrappingException(this.syscalls, inputSerde, parameter);
        Util.blockOnSyscall(cb -> this.syscalls.send(target, input, null, cb));
    }

    @Override
    public <T> void send(Target target, Serde<T> inputSerde, T parameter, Duration delay) {
        ByteString input = Util.serializeWrappingException(this.syscalls, inputSerde, parameter);
        Util.blockOnSyscall(cb -> this.syscalls.send(target, input, delay, cb));
    }

    @Override
    public <T> T run(String name, Serde<T> serde, ThrowingSupplier<T> action) {
        final CompletableFuture enterFut = new CompletableFuture();
        this.syscalls.enterSideEffectBlock(name, new EnterSideEffectSyscallCallback(){

            public void onNotExecuted() {
                enterFut.complete(new CompletableFuture());
            }

            public void onSuccess(ByteString result) {
                enterFut.complete(CompletableFuture.completedFuture(result));
            }

            public void onFailure(TerminalException t) {
                enterFut.complete(CompletableFuture.failedFuture((Throwable)t));
            }

            public void onCancel(Throwable t) {
                enterFut.cancel(true);
            }
        });
        final CompletableFuture exitFut = (CompletableFuture)Util.awaitCompletableFuture(enterFut);
        if (exitFut.isDone()) {
            return Util.deserializeWrappingException(this.syscalls, serde, (ByteString)Util.awaitCompletableFuture(exitFut));
        }
        ExitSideEffectSyscallCallback exitCallback = new ExitSideEffectSyscallCallback(){

            public void onSuccess(ByteString result) {
                exitFut.complete(result);
            }

            public void onFailure(TerminalException t) {
                exitFut.completeExceptionally((Throwable)t);
            }

            public void onCancel(@Nullable Throwable t) {
                exitFut.cancel(true);
            }
        };
        Object res = null;
        TerminalException failure = null;
        try {
            res = action.get();
        }
        catch (TerminalException e) {
            failure = e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            this.syscalls.fail(e);
            AbortedExecutionException.sneakyThrow();
        }
        if (failure != null) {
            this.syscalls.exitSideEffectBlockWithTerminalException(failure, exitCallback);
        } else {
            this.syscalls.exitSideEffectBlock(Util.serializeWrappingException(this.syscalls, serde, res), exitCallback);
        }
        return Util.deserializeWrappingException(this.syscalls, serde, (ByteString)Util.awaitCompletableFuture(exitFut));
    }

    @Override
    public <T> Awakeable<T> awakeable(Serde<T> serde) throws TerminalException {
        Map.Entry awakeable = (Map.Entry)Util.blockOnSyscall(arg_0 -> ((Syscalls)this.syscalls).awakeable(arg_0));
        return new Awakeable<T>(this.syscalls, (Deferred<ByteString>)((Deferred)awakeable.getValue()), serde, (String)awakeable.getKey());
    }

    @Override
    public AwakeableHandle awakeableHandle(final String id) {
        return new AwakeableHandle(){

            @Override
            public <T> void resolve(Serde<T> serde, @NonNull T payload) {
                Util.blockOnSyscall(cb -> ContextImpl.this.syscalls.resolveAwakeable(id, Util.serializeWrappingException(ContextImpl.this.syscalls, serde, payload), cb));
            }

            @Override
            public void reject(String reason) {
                Util.blockOnSyscall(cb -> ContextImpl.this.syscalls.rejectAwakeable(id, reason, cb));
            }
        };
    }

    @Override
    public RestateRandom random() {
        return new RestateRandom(this.request().invocationId().toRandomSeed(), this.syscalls);
    }
}

