/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk;

import dev.restate.sdk.AnyAwaitable;
import dev.restate.sdk.Util;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.function.ThrowingFunction;
import dev.restate.sdk.common.syscalls.Deferred;
import dev.restate.sdk.common.syscalls.Result;
import dev.restate.sdk.common.syscalls.Syscalls;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class Awaitable<T> {
    protected final Syscalls syscalls;

    Awaitable(Syscalls syscalls) {
        this.syscalls = syscalls;
    }

    protected abstract Deferred<?> deferred();

    protected abstract Result<T> awaitResult();

    public final T await() throws TerminalException {
        return Util.unwrapResult(this.awaitResult());
    }

    public final T await(Duration timeout) throws TerminalException, TimeoutException {
        Deferred sleep = (Deferred)Util.blockOnSyscall(cb -> this.syscalls.sleep(timeout, cb));
        Awaitable<T> sleepAwaitable = Awaitable.single(this.syscalls, sleep);
        int index = Awaitable.any(this, sleepAwaitable, new Awaitable[0]).awaitIndex();
        if (index == 1) {
            throw new TimeoutException();
        }
        return this.await();
    }

    public final <U> Awaitable<U> map(ThrowingFunction<T, U> mapper) {
        return new MappedAwaitable(this, result -> {
            if (result.isSuccess()) {
                return Result.success(Util.executeMappingException(this.syscalls, mapper, result.getValue()));
            }
            return result;
        });
    }

    static <T> Awaitable<T> single(Syscalls syscalls, Deferred<T> deferred) {
        return new SingleAwaitable<T>(syscalls, deferred);
    }

    public static AnyAwaitable any(Awaitable<?> first, Awaitable<?> second, Awaitable<?> ... others) {
        ArrayList awaitables = new ArrayList(2 + others.length);
        awaitables.add(first);
        awaitables.add(second);
        awaitables.addAll(Arrays.asList(others));
        return new AnyAwaitable(first.syscalls, (Deferred<Integer>)first.syscalls.createAnyDeferred(awaitables.stream().map(Awaitable::deferred).collect(Collectors.toList())), awaitables);
    }

    public static Awaitable<Void> all(Awaitable<?> first, Awaitable<?> second, Awaitable<?> ... others) {
        ArrayList deferred = new ArrayList(2 + others.length);
        deferred.add(first.deferred());
        deferred.add(second.deferred());
        Arrays.stream(others).map(Awaitable::deferred).forEach(deferred::add);
        return Awaitable.single(first.syscalls, first.syscalls.createAllDeferred(deferred));
    }

    static class MappedAwaitable<T, U>
    extends Awaitable<U> {
        private final Awaitable<T> inner;
        private final Function<Result<T>, Result<U>> mapper;
        private Result<U> mappedResult;

        MappedAwaitable(Awaitable<T> inner, Function<Result<T>, Result<U>> mapper) {
            super(inner.syscalls);
            this.inner = inner;
            this.mapper = mapper;
        }

        @Override
        protected Deferred<?> deferred() {
            return this.inner.deferred();
        }

        @Override
        public Result<U> awaitResult() throws TerminalException {
            if (this.mappedResult == null) {
                this.mappedResult = this.mapper.apply(this.inner.awaitResult());
            }
            return this.mappedResult;
        }
    }

    static class SingleAwaitable<T>
    extends Awaitable<T> {
        private final Deferred<T> deferred;
        private Result<T> result;

        SingleAwaitable(Syscalls syscalls, Deferred<T> deferred) {
            super(syscalls);
            this.deferred = deferred;
        }

        @Override
        protected Deferred<?> deferred() {
            return this.deferred;
        }

        @Override
        protected Result<T> awaitResult() {
            if (!this.deferred.isCompleted()) {
                Util.blockOnSyscall(cb -> this.syscalls.resolveDeferred(this.deferred, cb));
            }
            if (this.result == null) {
                this.result = this.deferred.toResult();
            }
            return this.result;
        }
    }
}

