/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.kotlin.gen;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.KSBuiltIns;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.FunctionKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.Variance;
import com.google.devtools.ksp.symbol.Visibility;
import com.google.devtools.ksp.visitor.KSDefaultVisitor;
import dev.restate.sdk.annotation.Accept;
import dev.restate.sdk.annotation.Exclusive;
import dev.restate.sdk.annotation.Handler;
import dev.restate.sdk.annotation.Json;
import dev.restate.sdk.annotation.Raw;
import dev.restate.sdk.annotation.Service;
import dev.restate.sdk.annotation.Shared;
import dev.restate.sdk.annotation.VirtualObject;
import dev.restate.sdk.annotation.Workflow;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.gen.model.Handler;
import dev.restate.sdk.gen.model.HandlerType;
import dev.restate.sdk.gen.model.PayloadType;
import dev.restate.sdk.gen.model.Service;
import dev.restate.sdk.gen.utils.AnnotationUtils;
import dev.restate.sdk.kotlin.Context;
import dev.restate.sdk.kotlin.ObjectContext;
import dev.restate.sdk.kotlin.SharedObjectContext;
import dev.restate.sdk.kotlin.SharedWorkflowContext;
import dev.restate.sdk.kotlin.WorkflowContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00019B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018H\u0002J,\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u00102\u001a\u00020\u00032\n\u00103\u001a\u0006\u0012\u0002\b\u0003042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u00105\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\t2\u0006\u00106\u001a\u00020\u001aH\u0002J\u0018\u00107\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\t2\u0006\u00106\u001a\u00020\u001aH\u0002J\u0010\u00106\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ldev/restate/sdk/kotlin/gen/KElementConverter;", "Lcom/google/devtools/ksp/visitor/KSDefaultVisitor;", "Ldev/restate/sdk/gen/model/Service$Builder;", "", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "builtIns", "Lcom/google/devtools/ksp/processing/KSBuiltIns;", "byteArrayType", "Lcom/google/devtools/ksp/symbol/KSType;", "<init>", "(Lcom/google/devtools/ksp/processing/KSPLogger;Lcom/google/devtools/ksp/processing/KSBuiltIns;Lcom/google/devtools/ksp/symbol/KSType;)V", "defaultHandler", "node", "Lcom/google/devtools/ksp/symbol/KSNode;", "data", "visitAnnotated", "annotated", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "visitClassDeclaration", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "visitFunctionDeclaration", "function", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "inputAcceptFromParameterList", "", "paramList", "", "Lcom/google/devtools/ksp/symbol/KSValueParameter;", "inputPayloadFromParameterList", "Ldev/restate/sdk/gen/model/PayloadType;", "outputPayloadFromExecutableElement", "fn", "payloadFromTypeMirrorAndAnnotations", "ty", "jsonAnnotation", "Ldev/restate/sdk/annotation/Json;", "rawAnnotation", "Ldev/restate/sdk/annotation/Raw;", "relatedNode", "contentTypeDecoratedSerdeDecl", "serdeDecl", "contentType", "defaultHandlerType", "Ldev/restate/sdk/gen/model/HandlerType;", "serviceType", "Ldev/restate/sdk/common/ServiceType;", "validateMethodSignature", "handlerType", "validateFirstParameterType", "clazz", "Lkotlin/reflect/KClass;", "jsonSerdeDecl", "qualifiedTypeName", "boxedType", "ksType", "Companion", "sdk-api-kotlin-gen"})
@SourceDebugExtension(value={"SMAP\nKElementConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KElementConverter.kt\ndev/restate/sdk/kotlin/gen/KElementConverter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,356:1\n1317#2,2:357\n*S KotlinDebug\n*F\n+ 1 KElementConverter.kt\ndev/restate/sdk/kotlin/gen/KElementConverter\n*L\n120#1:357,2\n*E\n"})
public final class KElementConverter
extends KSDefaultVisitor<Service.Builder, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final KSBuiltIns builtIns;
    @NotNull
    private final KSType byteArrayType;
    @NotNull
    private static final Set<ClassKind> SUPPORTED_CLASS_KIND;
    @NotNull
    private static final PayloadType EMPTY_PAYLOAD;
    @NotNull
    private static final String RAW_SERDE = "dev.restate.sdk.common.Serde.RAW";

    public KElementConverter(@NotNull KSPLogger logger, @NotNull KSBuiltIns builtIns, @NotNull KSType byteArrayType) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)byteArrayType, (String)"byteArrayType");
        this.logger = logger;
        this.builtIns = builtIns;
        this.byteArrayType = byteArrayType;
    }

    public void defaultHandler(@NotNull KSNode node, @NotNull Service.Builder data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public void visitAnnotated(@NotNull KSAnnotated annotated, @NotNull Service.Builder data) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(annotated instanceof KSClassDeclaration)) {
            KSPLogger.error$default((KSPLogger)this.logger, (String)"Only classes or interfaces can be annotated with @Service or @VirtualObject or @Workflow", null, (int)2, null);
        }
        this.visitClassDeclaration((KSClassDeclaration)annotated, data);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull Service.Builder data) {
        void $this$forEach$iv;
        CharSequence charSequence;
        String serviceName;
        String string;
        boolean isAnnotatedWithWorkflow;
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!((Collection)classDeclaration.getTypeParameters()).isEmpty()) {
            this.logger.error("The ServiceProcessor doesn't support services with generics", (KSNode)classDeclaration);
        }
        if (!SUPPORTED_CLASS_KIND.contains(classDeclaration.getClassKind())) {
            this.logger.error("The ServiceProcessor supports only class declarations of kind " + SUPPORTED_CLASS_KIND, (KSNode)classDeclaration);
        }
        if (UtilsKt.getVisibility((KSDeclaration)((KSDeclaration)classDeclaration)) == Visibility.PRIVATE) {
            this.logger.error("The annotated class is private", (KSNode)classDeclaration);
        }
        Service serviceAnnotation = (Service)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Service.class)));
        VirtualObject virtualObjectAnnotation = (VirtualObject)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(VirtualObject.class)));
        Workflow workflowAnnotation = (Workflow)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Workflow.class)));
        boolean isAnnotatedWithService = serviceAnnotation != null;
        boolean isAnnotatedWithVirtualObject = virtualObjectAnnotation != null;
        boolean bl = isAnnotatedWithWorkflow = workflowAnnotation != null;
        if (!(isAnnotatedWithService ^ isAnnotatedWithVirtualObject ^ isAnnotatedWithWorkflow)) {
            this.logger.error("The type can be annotated only with one annotation between @VirtualObject and @Service and @Workflow", (KSNode)classDeclaration);
        }
        data.withServiceType(isAnnotatedWithService ? ServiceType.SERVICE : (isAnnotatedWithWorkflow ? ServiceType.WORKFLOW : ServiceType.VIRTUAL_OBJECT));
        String targetPkg = classDeclaration.getPackageName().asString();
        KSName kSName = classDeclaration.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        String targetFqcn = kSName.asString();
        if (isAnnotatedWithService) {
            Service service = serviceAnnotation;
            Intrinsics.checkNotNull((Object)service);
            string = service.name();
        } else if (isAnnotatedWithWorkflow) {
            Workflow workflow = workflowAnnotation;
            Intrinsics.checkNotNull((Object)workflow);
            string = workflow.name();
        } else {
            VirtualObject virtualObject = virtualObjectAnnotation;
            Intrinsics.checkNotNull((Object)virtualObject);
            string = serviceName = virtualObject.name();
        }
        if (((CharSequence)serviceName).length() == 0) {
            String string2 = targetFqcn.substring(targetPkg.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            charSequence = string2;
            String string3 = Pattern.quote(".");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"quote(...)");
            String string4 = string3;
            string4 = new Regex(string4);
            String string5 = "";
            serviceName = string4.replace(charSequence, string5);
        }
        data.withTargetPkg((CharSequence)targetPkg).withTargetFqcn((CharSequence)targetFqcn).withServiceName(serviceName);
        charSequence = SequencesKt.filter((Sequence)classDeclaration.getAllFunctions(), KElementConverter::visitClassDeclaration$lambda$0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSFunctionDeclaration it = (KSFunctionDeclaration)element$iv;
            boolean bl2 = false;
            this.visitFunctionDeclaration(it, data);
        }
        if (data.getHandlers().isEmpty()) {
            this.logger.warn("The class declaration " + targetFqcn + " has no methods annotated as handlers", (KSNode)classDeclaration);
        }
    }

    public void visitFunctionDeclaration(@NotNull KSFunctionDeclaration function, @NotNull Service.Builder data) {
        HandlerType handlerType;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!((Collection)function.getTypeParameters()).isEmpty()) {
            this.logger.error("The ServiceProcessor doesn't support methods with generics", (KSNode)function);
        }
        if (function.getFunctionKind() != FunctionKind.MEMBER) {
            KSPLogger.error$default((KSPLogger)this.logger, (String)"Only member function declarations are supported as Restate handlers", null, (int)2, null);
        }
        boolean isAnnotatedWithShared = UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Shared.class));
        boolean isAnnotatedWithExclusive = UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Exclusive.class));
        boolean isAnnotatedWithWorkflow = UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Workflow.class));
        boolean hasAnyAnnotation = isAnnotatedWithExclusive || isAnnotatedWithShared || isAnnotatedWithWorkflow;
        boolean hasExactlyOneAnnotation = isAnnotatedWithShared ^ isAnnotatedWithExclusive ^ isAnnotatedWithWorkflow;
        if (hasAnyAnnotation && !hasExactlyOneAnnotation) {
            this.logger.error("You can have only one annotation between @Shared and @Exclusive and @Workflow to a method", (KSNode)function);
        }
        Handler.Builder handlerBuilder = dev.restate.sdk.gen.model.Handler.builder();
        if (isAnnotatedWithShared) {
            handlerType = HandlerType.SHARED;
        } else if (isAnnotatedWithExclusive) {
            handlerType = HandlerType.EXCLUSIVE;
        } else if (isAnnotatedWithWorkflow) {
            handlerType = HandlerType.WORKFLOW;
        } else {
            ServiceType serviceType = data.getServiceType();
            Intrinsics.checkNotNullExpressionValue((Object)serviceType, (String)"getServiceType(...)");
            handlerType = this.defaultHandlerType(serviceType);
        }
        HandlerType handlerType2 = handlerType;
        handlerBuilder.withHandlerType(handlerType2);
        ServiceType serviceType = data.getServiceType();
        Intrinsics.checkNotNullExpressionValue((Object)serviceType, (String)"getServiceType(...)");
        this.validateMethodSignature(serviceType, handlerType2, function);
        try {
            data.withHandler(handlerBuilder.withName((CharSequence)function.getSimpleName().asString()).withHandlerType(handlerType2).withInputAccept(this.inputAcceptFromParameterList(function.getParameters())).withInputType(this.inputPayloadFromParameterList(function.getParameters())).withOutputType(this.outputPayloadFromExecutableElement(function)).validateAndBuild());
        }
        catch (Exception e) {
            this.logger.error("Error when building handler: " + e, (KSNode)function);
        }
    }

    private final String inputAcceptFromParameterList(List<? extends KSValueParameter> paramList) {
        if (paramList.size() <= 1) {
            return null;
        }
        Accept accept = (Accept)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)paramList.get(1)), (KClass)Reflection.getOrCreateKotlinClass(Accept.class)));
        return accept != null ? accept.value() : null;
    }

    private final PayloadType inputPayloadFromParameterList(List<? extends KSValueParameter> paramList) {
        if (paramList.size() <= 1) {
            return EMPTY_PAYLOAD;
        }
        KSValueParameter parameterElement = paramList.get(1);
        return this.payloadFromTypeMirrorAndAnnotations(parameterElement.getType().resolve(), (Json)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)parameterElement), (KClass)Reflection.getOrCreateKotlinClass(Json.class))), (Raw)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)parameterElement), (KClass)Reflection.getOrCreateKotlinClass(Raw.class))), (KSNode)parameterElement);
    }

    private final PayloadType outputPayloadFromExecutableElement(KSFunctionDeclaration fn) {
        KSTypeReference kSTypeReference = fn.getReturnType();
        if (kSTypeReference == null || (kSTypeReference = kSTypeReference.resolve()) == null) {
            kSTypeReference = this.builtIns.getUnitType();
        }
        return this.payloadFromTypeMirrorAndAnnotations((KSType)kSTypeReference, (Json)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)fn), (KClass)Reflection.getOrCreateKotlinClass(Json.class))), (Raw)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)fn), (KClass)Reflection.getOrCreateKotlinClass(Raw.class))), (KSNode)fn);
    }

    private final PayloadType payloadFromTypeMirrorAndAnnotations(KSType ty, Json jsonAnnotation, Raw rawAnnotation, KSNode relatedNode) {
        String serdeDecl;
        if (Intrinsics.areEqual((Object)ty, (Object)this.builtIns.getUnitType())) {
            if (rawAnnotation != null || jsonAnnotation != null) {
                this.logger.error("Unexpected annotation for void type.", relatedNode);
            }
            return EMPTY_PAYLOAD;
        }
        if (rawAnnotation != null && jsonAnnotation != null) {
            this.logger.error("A parameter cannot be annotated both with @Raw and @Json.", relatedNode);
        }
        if (rawAnnotation != null && !Intrinsics.areEqual((Object)ty, (Object)this.byteArrayType)) {
            this.logger.error("A parameter annotated with @Raw MUST be of type byte[], was " + ty, relatedNode);
        }
        if (ty.isFunctionType() || ty.isSuspendFunctionType()) {
            this.logger.error("Cannot use fun as parameter or return type", relatedNode);
        }
        String qualifiedTypeName = this.qualifiedTypeName(ty);
        String string = serdeDecl = rawAnnotation != null ? RAW_SERDE : this.jsonSerdeDecl(ty, qualifiedTypeName);
        if (rawAnnotation != null && !Intrinsics.areEqual((Object)rawAnnotation.contentType(), (Object)AnnotationUtils.getAnnotationDefaultValue(Raw.class, (String)"contentType"))) {
            serdeDecl = this.contentTypeDecoratedSerdeDecl(serdeDecl, rawAnnotation.contentType());
        }
        if (jsonAnnotation != null && !Intrinsics.areEqual((Object)jsonAnnotation.contentType(), (Object)AnnotationUtils.getAnnotationDefaultValue(Json.class, (String)"contentType"))) {
            serdeDecl = this.contentTypeDecoratedSerdeDecl(serdeDecl, jsonAnnotation.contentType());
        }
        return new PayloadType(false, qualifiedTypeName, this.boxedType(ty, qualifiedTypeName), serdeDecl);
    }

    private final String contentTypeDecoratedSerdeDecl(String serdeDecl, String contentType) {
        return "dev.restate.sdk.common.Serde.withContentType(\"" + contentType + "\", " + serdeDecl + ")";
    }

    private final HandlerType defaultHandlerType(ServiceType serviceType) {
        switch (WhenMappings.$EnumSwitchMapping$0[serviceType.ordinal()]) {
            case 1: {
                return HandlerType.STATELESS;
            }
            case 2: {
                return HandlerType.EXCLUSIVE;
            }
            case 3: {
                return HandlerType.SHARED;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void validateMethodSignature(ServiceType serviceType, HandlerType handlerType, KSFunctionDeclaration function) {
        if (function.getParameters().isEmpty()) {
            this.logger.error("The annotated method has no parameters. There must be at least the context parameter as first parameter", (KSNode)function);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[handlerType.ordinal()]) {
            case 1: {
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(SharedObjectContext.class), function);
                    break;
                }
                if (serviceType == ServiceType.WORKFLOW) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(SharedWorkflowContext.class), function);
                    break;
                }
                this.logger.error("The annotation @Shared is not supported by the service type " + serviceType, (KSNode)function);
                break;
            }
            case 2: {
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(ObjectContext.class), function);
                    break;
                }
                this.logger.error("The annotation @Exclusive is not supported by the service type " + serviceType, (KSNode)function);
                break;
            }
            case 3: {
                this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(Context.class), function);
                break;
            }
            case 4: {
                if (serviceType == ServiceType.WORKFLOW) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(WorkflowContext.class), function);
                    break;
                }
                this.logger.error("The annotation @Workflow is not supported by the service type " + serviceType, (KSNode)function);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void validateFirstParameterType(KClass<?> clazz, KSFunctionDeclaration function) {
        KSName kSName = ((KSValueParameter)function.getParameters().get(0)).getType().resolve().getDeclaration().getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        if (!Intrinsics.areEqual((Object)kSName.asString(), (Object)clazz.getQualifiedName())) {
            String string = clazz.getQualifiedName();
            KSName kSName2 = ((KSValueParameter)function.getParameters().get(0)).getType().resolve().getDeclaration().getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName2);
            this.logger.error("The method signature must have " + string + " as first parameter, was " + kSName2.asString(), (KSNode)function);
        }
    }

    private final String jsonSerdeDecl(KSType ty, String qualifiedTypeName) {
        return Intrinsics.areEqual((Object)ty, (Object)this.builtIns.getUnitType()) ? "dev.restate.sdk.kotlin.KtSerdes.UNIT" : "dev.restate.sdk.kotlin.KtSerdes.json<" + this.boxedType(ty, qualifiedTypeName) + ">()";
    }

    private final String boxedType(KSType ty, String qualifiedTypeName) {
        return Intrinsics.areEqual((Object)ty, (Object)this.builtIns.getUnitType()) ? "Unit" : qualifiedTypeName;
    }

    private final String qualifiedTypeName(KSType ksType) {
        Object typeName;
        Object object = ksType.getDeclaration().getQualifiedName();
        if (object == null || (object = object.asString()) == null) {
            object = typeName = ksType.toString();
        }
        if (!((Collection)ksType.getArguments()).isEmpty()) {
            typeName = (String)typeName + "<" + CollectionsKt.joinToString$default((Iterable)ksType.getArguments(), (CharSequence)", ", null, null, (int)0, null, arg_0 -> KElementConverter.qualifiedTypeName$lambda$2(this, arg_0), (int)30, null) + ">";
        }
        if (ksType.isMarkedNullable()) {
            typeName = (String)typeName + "?";
        }
        return typeName;
    }

    private static final boolean visitClassDeclaration$lambda$0(KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)it), (KClass)Reflection.getOrCreateKotlinClass(Handler.class)) || UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)it), (KClass)Reflection.getOrCreateKotlinClass(Workflow.class)) || UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)it), (KClass)Reflection.getOrCreateKotlinClass(Exclusive.class)) || UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)it), (KClass)Reflection.getOrCreateKotlinClass(Shared.class));
    }

    private static final CharSequence qualifiedTypeName$lambda$2(KElementConverter this$0, KSTypeArgument it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getVariance() == Variance.STAR) {
            object = it.getVariance().getLabel();
        } else {
            String string = it.getVariance().getLabel();
            KSTypeReference kSTypeReference = it.getType();
            Intrinsics.checkNotNull((Object)kSTypeReference);
            object = string + " " + this$0.qualifiedTypeName(kSTypeReference.resolve());
        }
        return (CharSequence)object;
    }

    static {
        Object[] objectArray = new ClassKind[]{ClassKind.CLASS, ClassKind.INTERFACE};
        SUPPORTED_CLASS_KIND = SetsKt.setOf((Object[])objectArray);
        EMPTY_PAYLOAD = new PayloadType(true, "", "Unit", "dev.restate.sdk.kotlin.KtSerdes.UNIT");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/restate/sdk/kotlin/gen/KElementConverter$Companion;", "", "<init>", "()V", "SUPPORTED_CLASS_KIND", "", "Lcom/google/devtools/ksp/symbol/ClassKind;", "EMPTY_PAYLOAD", "Ldev/restate/sdk/gen/model/PayloadType;", "RAW_SERDE", "", "sdk-api-kotlin-gen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ServiceType.values().length];
            try {
                nArray[ServiceType.SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceType.VIRTUAL_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceType.WORKFLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HandlerType.values().length];
            try {
                nArray[HandlerType.SHARED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.EXCLUSIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.STATELESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.WORKFLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

