/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.kotlin.gen;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.KSBuiltIns;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.FunctionKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.Visibility;
import com.google.devtools.ksp.visitor.KSDefaultVisitor;
import dev.restate.sdk.annotation.Exclusive;
import dev.restate.sdk.annotation.Service;
import dev.restate.sdk.annotation.Shared;
import dev.restate.sdk.annotation.VirtualObject;
import dev.restate.sdk.annotation.Workflow;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.gen.model.Handler;
import dev.restate.sdk.gen.model.HandlerType;
import dev.restate.sdk.gen.model.PayloadType;
import dev.restate.sdk.gen.model.Service;
import dev.restate.sdk.kotlin.Context;
import dev.restate.sdk.kotlin.ObjectContext;
import dev.restate.sdk.kotlin.SharedObjectContext;
import dev.restate.sdk.kotlin.gen.KElementConverter;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001a\u001a\u00020\u00032\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010'\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/restate/sdk/kotlin/gen/KElementConverter;", "Lcom/google/devtools/ksp/visitor/KSDefaultVisitor;", "Ldev/restate/sdk/gen/model/Service$Builder;", "", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "builtIns", "Lcom/google/devtools/ksp/processing/KSBuiltIns;", "(Lcom/google/devtools/ksp/processing/KSPLogger;Lcom/google/devtools/ksp/processing/KSBuiltIns;)V", "boxedType", "", "ty", "Lcom/google/devtools/ksp/symbol/KSType;", "defaultHandler", "node", "Lcom/google/devtools/ksp/symbol/KSNode;", "data", "defaultHandlerType", "Ldev/restate/sdk/gen/model/HandlerType;", "serviceType", "Ldev/restate/sdk/common/ServiceType;", "payloadFromType", "Ldev/restate/sdk/gen/model/PayloadType;", "typeRef", "Lcom/google/devtools/ksp/symbol/KSTypeReference;", "serdeDecl", "validateFirstParameterType", "clazz", "Lkotlin/reflect/KClass;", "function", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "validateMethodSignature", "handlerType", "visitAnnotated", "annotated", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "visitClassDeclaration", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "visitFunctionDeclaration", "Companion", "sdk-api-kotlin-gen"})
@SourceDebugExtension(value={"SMAP\nKElementConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KElementConverter.kt\ndev/restate/sdk/kotlin/gen/KElementConverter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,244:1\n1313#2,2:245\n*S KotlinDebug\n*F\n+ 1 KElementConverter.kt\ndev/restate/sdk/kotlin/gen/KElementConverter\n*L\n109#1:245,2\n*E\n"})
public final class KElementConverter
extends KSDefaultVisitor<Service.Builder, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final KSBuiltIns builtIns;
    @NotNull
    private static final Set<ClassKind> SUPPORTED_CLASS_KIND;
    @NotNull
    private static final PayloadType EMPTY_PAYLOAD;

    public KElementConverter(@NotNull KSPLogger logger, @NotNull KSBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        this.logger = logger;
        this.builtIns = builtIns;
    }

    public void defaultHandler(@NotNull KSNode node, @NotNull Service.Builder data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public void visitAnnotated(@NotNull KSAnnotated annotated, @NotNull Service.Builder data) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(annotated instanceof KSClassDeclaration)) {
            KSPLogger.error$default((KSPLogger)this.logger, (String)"Only classes or interfaces can be annotated with @Service or @VirtualObject or @Workflow", null, (int)2, null);
        }
        this.visitClassDeclaration((KSClassDeclaration)annotated, data);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull Service.Builder data) {
        void $this$forEach$iv;
        CharSequence charSequence;
        String serviceName;
        String string;
        boolean isAnnotatedWithVirtualObject;
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!((Collection)classDeclaration.getTypeParameters()).isEmpty()) {
            this.logger.error("The ServiceProcessor doesn't support services with generics", (KSNode)classDeclaration);
        }
        if (!SUPPORTED_CLASS_KIND.contains(classDeclaration.getClassKind())) {
            this.logger.error("The ServiceProcessor supports only class declarations of kind " + SUPPORTED_CLASS_KIND, (KSNode)classDeclaration);
        }
        if (UtilsKt.getVisibility((KSDeclaration)((KSDeclaration)classDeclaration)) == Visibility.PRIVATE) {
            this.logger.error("The annotated class is private", (KSNode)classDeclaration);
        }
        if (UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Workflow.class))) {
            this.logger.error("sdk-api-kotlin doesn't support workflows yet", (KSNode)classDeclaration);
        }
        Service serviceAnnotation = (Service)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Service.class)));
        VirtualObject virtualObjectAnnotation = (VirtualObject)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)classDeclaration), (KClass)Reflection.getOrCreateKotlinClass(VirtualObject.class)));
        boolean isAnnotatedWithService = serviceAnnotation != null;
        boolean bl = isAnnotatedWithVirtualObject = virtualObjectAnnotation != null;
        if (!(isAnnotatedWithService ^ isAnnotatedWithVirtualObject)) {
            this.logger.error("The type can be annotated only with one annotation between @VirtualObject and @Service", (KSNode)classDeclaration);
        }
        data.withServiceType(isAnnotatedWithService ? ServiceType.SERVICE : ServiceType.VIRTUAL_OBJECT);
        String targetPkg = classDeclaration.getPackageName().asString();
        KSName kSName = classDeclaration.getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        String targetFqcn = kSName.asString();
        if (isAnnotatedWithService) {
            Service service = serviceAnnotation;
            Intrinsics.checkNotNull((Object)service);
            string = service.name();
        } else {
            VirtualObject virtualObject = virtualObjectAnnotation;
            Intrinsics.checkNotNull((Object)virtualObject);
            string = serviceName = virtualObject.name();
        }
        if (((CharSequence)serviceName).length() == 0) {
            String string2 = targetFqcn.substring(targetPkg.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            charSequence = string2;
            String string3 = Pattern.quote(".");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"quote(...)");
            String string4 = string3;
            string4 = new Regex(string4);
            String string5 = "";
            serviceName = string4.replace(charSequence, string5);
        }
        data.withTargetPkg((CharSequence)targetPkg).withTargetFqcn((CharSequence)targetFqcn).withServiceName(serviceName);
        charSequence = SequencesKt.filter((Sequence)classDeclaration.getAllFunctions(), (Function1)visitClassDeclaration.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSFunctionDeclaration it = (KSFunctionDeclaration)element$iv;
            boolean bl2 = false;
            this.visitFunctionDeclaration(it, data);
        }
        if (data.getHandlers().isEmpty()) {
            this.logger.warn("The class declaration " + targetFqcn + " has no methods annotated as handlers", (KSNode)classDeclaration);
        }
    }

    public void visitFunctionDeclaration(@NotNull KSFunctionDeclaration function, @NotNull Service.Builder data) {
        HandlerType handlerType;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!((Collection)function.getTypeParameters()).isEmpty()) {
            this.logger.error("The ServiceProcessor doesn't support methods with generics", (KSNode)function);
        }
        if (function.getFunctionKind() != FunctionKind.MEMBER) {
            KSPLogger.error$default((KSPLogger)this.logger, (String)"Only member function declarations are supported as Restate handlers", null, (int)2, null);
        }
        if (UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Workflow.class))) {
            this.logger.error("sdk-api-kotlin doesn't support workflows yet", (KSNode)function);
        }
        boolean isAnnotatedWithShared = UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Shared.class));
        boolean isAnnotatedWithExclusive = UtilsKt.isAnnotationPresent((KSAnnotated)((KSAnnotated)function), (KClass)Reflection.getOrCreateKotlinClass(Exclusive.class));
        boolean hasAnyAnnotation = isAnnotatedWithExclusive || isAnnotatedWithShared;
        boolean hasExactlyOneAnnotation = isAnnotatedWithShared ^ isAnnotatedWithExclusive;
        if (hasAnyAnnotation && !hasExactlyOneAnnotation) {
            this.logger.error("You can have only one annotation between @Shared and @Exclusive to a method", (KSNode)function);
        }
        Handler.Builder handlerBuilder = Handler.builder();
        if (isAnnotatedWithShared) {
            handlerType = HandlerType.SHARED;
        } else if (isAnnotatedWithExclusive) {
            handlerType = HandlerType.EXCLUSIVE;
        } else {
            ServiceType serviceType = data.getServiceType();
            Intrinsics.checkNotNullExpressionValue((Object)serviceType, (String)"getServiceType(...)");
            handlerType = this.defaultHandlerType(serviceType, (KSNode)function);
        }
        HandlerType handlerType2 = handlerType;
        handlerBuilder.withHandlerType(handlerType2);
        ServiceType serviceType = data.getServiceType();
        Intrinsics.checkNotNullExpressionValue((Object)serviceType, (String)"getServiceType(...)");
        this.validateMethodSignature(serviceType, handlerType2, function);
        try {
            PayloadType payloadType;
            Handler.Builder builder = handlerBuilder.withName((CharSequence)function.getSimpleName().asString()).withHandlerType(handlerType2).withInputType(function.getParameters().size() == 2 ? this.payloadFromType(((KSValueParameter)function.getParameters().get(1)).getType()) : EMPTY_PAYLOAD);
            if (function.getReturnType() != null) {
                KSTypeReference kSTypeReference = function.getReturnType();
                Intrinsics.checkNotNull((Object)kSTypeReference);
                payloadType = this.payloadFromType(kSTypeReference);
            } else {
                payloadType = EMPTY_PAYLOAD;
            }
            data.withHandler(builder.withOutputType(payloadType).validateAndBuild());
        }
        catch (Exception e) {
            this.logger.error("Error when building handler: " + e, (KSNode)function);
        }
    }

    private final HandlerType defaultHandlerType(ServiceType serviceType, KSNode node) {
        switch (WhenMappings.$EnumSwitchMapping$0[serviceType.ordinal()]) {
            case 1: {
                return HandlerType.STATELESS;
            }
            case 2: {
                return HandlerType.EXCLUSIVE;
            }
            case 3: {
                this.logger.error("Workflow handlers MUST be annotated with either @Shared or @Workflow", node);
            }
        }
        throw new IllegalStateException("Unexpected");
    }

    private final void validateMethodSignature(ServiceType serviceType, HandlerType handlerType, KSFunctionDeclaration function) {
        if (function.getParameters().isEmpty()) {
            this.logger.error("The annotated method has no parameters. There must be at least the context parameter as first parameter", (KSNode)function);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[handlerType.ordinal()]) {
            case 1: {
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(SharedObjectContext.class), function);
                    break;
                }
                this.logger.error("The annotation @Shared is not supported by the service type " + serviceType, (KSNode)function);
                break;
            }
            case 2: {
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(ObjectContext.class), function);
                    break;
                }
                this.logger.error("The annotation @Exclusive is not supported by the service type " + serviceType, (KSNode)function);
                break;
            }
            case 3: {
                this.validateFirstParameterType(Reflection.getOrCreateKotlinClass(Context.class), function);
                break;
            }
            case 4: {
                this.logger.error("The annotation @Workflow is currently not supported in sdk-api-kotlin", (KSNode)function);
            }
        }
    }

    private final void validateFirstParameterType(KClass<?> clazz, KSFunctionDeclaration function) {
        KSName kSName = ((KSValueParameter)function.getParameters().get(0)).getType().resolve().getDeclaration().getQualifiedName();
        Intrinsics.checkNotNull((Object)kSName);
        if (!Intrinsics.areEqual((Object)kSName.asString(), (Object)clazz.getQualifiedName())) {
            String string = clazz.getQualifiedName();
            KSName kSName2 = ((KSValueParameter)function.getParameters().get(0)).getType().resolve().getDeclaration().getQualifiedName();
            Intrinsics.checkNotNull((Object)kSName2);
            this.logger.error("The method signature must have " + string + " as first parameter, was " + kSName2.asString(), (KSNode)function);
        }
    }

    private final PayloadType payloadFromType(KSTypeReference typeRef) {
        KSType ty = typeRef.resolve();
        return new PayloadType(false, typeRef.toString(), this.boxedType(ty), this.serdeDecl(ty));
    }

    private final String serdeDecl(KSType ty) {
        return Intrinsics.areEqual((Object)ty, (Object)this.builtIns.getUnitType()) ? "dev.restate.sdk.kotlin.KtSerdes.UNIT" : "dev.restate.sdk.kotlin.KtSerdes.json<" + this.boxedType(ty) + ">()";
    }

    private final String boxedType(KSType ty) {
        return Intrinsics.areEqual((Object)ty, (Object)this.builtIns.getUnitType()) ? "Unit" : ty.toString();
    }

    static {
        Object[] objectArray = new ClassKind[]{ClassKind.CLASS, ClassKind.INTERFACE};
        SUPPORTED_CLASS_KIND = SetsKt.setOf((Object[])objectArray);
        EMPTY_PAYLOAD = new PayloadType(true, "", "Unit", "dev.restate.sdk.kotlin.KtSerdes.UNIT");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/restate/sdk/kotlin/gen/KElementConverter$Companion;", "", "()V", "EMPTY_PAYLOAD", "Ldev/restate/sdk/gen/model/PayloadType;", "SUPPORTED_CLASS_KIND", "", "Lcom/google/devtools/ksp/symbol/ClassKind;", "sdk-api-kotlin-gen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ServiceType.values().length];
            try {
                nArray[ServiceType.SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceType.VIRTUAL_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceType.WORKFLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HandlerType.values().length];
            try {
                nArray[HandlerType.SHARED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.EXCLUSIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.STATELESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HandlerType.WORKFLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

