/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.gen;

import com.github.jknack.handlebars.io.TemplateLoader;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.common.function.ThrowingFunction;
import dev.restate.sdk.common.syscalls.ServiceDefinitionFactory;
import dev.restate.sdk.gen.ElementConverter;
import dev.restate.sdk.gen.FilerTemplateLoader;
import dev.restate.sdk.gen.model.Service;
import dev.restate.sdk.gen.template.HandlebarsTemplateEngine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"dev.restate.sdk.annotation.Service", "dev.restate.sdk.annotation.Workflow", "dev.restate.sdk.annotation.VirtualObject"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class ServiceProcessor
extends AbstractProcessor {
    private HandlebarsTemplateEngine definitionsCodegen;
    private HandlebarsTemplateEngine serviceDefinitionFactoryCodegen;
    private HandlebarsTemplateEngine clientCodegen;
    private static final Set<String> RESERVED_METHOD_NAMES = Set.of("send", "submit", "workflowHandle");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        FilerTemplateLoader filerTemplateLoader = new FilerTemplateLoader(processingEnv.getFiler());
        this.definitionsCodegen = new HandlebarsTemplateEngine("Definitions", (TemplateLoader)filerTemplateLoader, Map.of(ServiceType.WORKFLOW, "templates/Definitions.hbs", ServiceType.SERVICE, "templates/Definitions.hbs", ServiceType.VIRTUAL_OBJECT, "templates/Definitions.hbs"), RESERVED_METHOD_NAMES);
        this.serviceDefinitionFactoryCodegen = new HandlebarsTemplateEngine("ServiceDefinitionFactory", (TemplateLoader)filerTemplateLoader, Map.of(ServiceType.WORKFLOW, "templates/ServiceDefinitionFactory.hbs", ServiceType.SERVICE, "templates/ServiceDefinitionFactory.hbs", ServiceType.VIRTUAL_OBJECT, "templates/ServiceDefinitionFactory.hbs"), RESERVED_METHOD_NAMES);
        this.clientCodegen = new HandlebarsTemplateEngine("Client", (TemplateLoader)filerTemplateLoader, Map.of(ServiceType.WORKFLOW, "templates/Client.hbs", ServiceType.SERVICE, "templates/Client.hbs", ServiceType.VIRTUAL_OBJECT, "templates/Client.hbs"), RESERVED_METHOD_NAMES);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Path resourceFilePath;
        ElementConverter converter = new ElementConverter(this.processingEnv.getMessager(), this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        List parsedServices = annotations.stream().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream()).filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> Map.entry(e, converter.fromTypeElement((TypeElement)e))).collect(Collectors.toList());
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry e2 : parsedServices) {
            try {
                ThrowingFunction fileCreator = name -> filer.createSourceFile((CharSequence)name, (Element)e2.getKey()).openWriter();
                this.definitionsCodegen.generate(fileCreator, (Service)e2.getValue());
                this.serviceDefinitionFactoryCodegen.generate(fileCreator, (Service)e2.getValue());
                this.clientCodegen.generate(fileCreator, (Service)e2.getValue());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            resourceFilePath = ServiceProcessor.readOrCreateResource(this.processingEnv.getFiler(), "META-INF/services/" + ServiceDefinitionFactory.class.getCanonicalName());
            Files.createDirectories(resourceFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(resourceFilePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            for (Map.Entry e4 : parsedServices) {
                writer.write(((Service)e4.getValue()).getGeneratedClassFqcnPrefix() + "ServiceDefinitionFactory");
                writer.write(10);
            }
        }
        catch (IOException e5) {
            throw new RuntimeException(e5);
        }
        return false;
    }

    public static Path readOrCreateResource(Filer filer, String file) throws IOException {
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", file);
            return new File(fileObject.toUri()).toPath();
        }
        catch (IOException e) {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", file, new Element[0]);
            return new File(fileObject.toUri()).toPath();
        }
    }
}

