/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.gen;

import dev.restate.sdk.Context;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.SharedObjectContext;
import dev.restate.sdk.annotation.Exclusive;
import dev.restate.sdk.annotation.Shared;
import dev.restate.sdk.annotation.VirtualObject;
import dev.restate.sdk.annotation.Workflow;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.gen.model.Handler;
import dev.restate.sdk.gen.model.HandlerType;
import dev.restate.sdk.gen.model.PayloadType;
import dev.restate.sdk.gen.model.Service;
import dev.restate.sdk.workflow.WorkflowContext;
import dev.restate.sdk.workflow.WorkflowSharedContext;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ElementConverter {
    private static final PayloadType EMPTY_PAYLOAD = new PayloadType(true, "", "Void", "dev.restate.sdk.common.CoreSerdes.VOID");
    private final Messager messager;
    private final Elements elements;
    private final Types types;

    public ElementConverter(Messager messager, Elements elements, Types types) {
        this.messager = messager;
        this.elements = elements;
        this.types = types;
    }

    public Service fromTypeElement(TypeElement element) {
        List handlers;
        String serviceName;
        boolean isAnnotatedWithWorkflow;
        this.validateType(element);
        dev.restate.sdk.annotation.Service serviceAnnotation = element.getAnnotation(dev.restate.sdk.annotation.Service.class);
        VirtualObject virtualObjectAnnotation = element.getAnnotation(VirtualObject.class);
        Workflow workflowAnnotation = element.getAnnotation(Workflow.class);
        boolean isAnnotatedWithService = serviceAnnotation != null;
        boolean isAnnotatedWithVirtualObject = virtualObjectAnnotation != null;
        boolean bl = isAnnotatedWithWorkflow = workflowAnnotation != null;
        assert (isAnnotatedWithWorkflow || isAnnotatedWithVirtualObject || isAnnotatedWithService);
        if (!Boolean.logicalXor(isAnnotatedWithService, Boolean.logicalXor(isAnnotatedWithWorkflow, isAnnotatedWithVirtualObject))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The type can be annotated only with one annotation between @VirtualObject, @Workflow and @Service", element);
        }
        ServiceType type = isAnnotatedWithWorkflow ? ServiceType.WORKFLOW : (isAnnotatedWithService ? ServiceType.SERVICE : ServiceType.VIRTUAL_OBJECT);
        Name targetPkg = this.elements.getPackageOf(element).getQualifiedName();
        Name targetFqcn = element.getQualifiedName();
        String string = isAnnotatedWithService ? serviceAnnotation.name() : (serviceName = isAnnotatedWithVirtualObject ? virtualObjectAnnotation.name() : workflowAnnotation.name());
        if (serviceName.isEmpty()) {
            serviceName = targetFqcn.toString().substring(targetPkg.length()).replaceAll(Pattern.quote("."), "");
        }
        if ((handlers = this.elements.getAllMembers(element).stream().filter(e -> e instanceof ExecutableElement).filter(e -> e.getAnnotation(dev.restate.sdk.annotation.Handler.class) != null || e.getAnnotation(Workflow.class) != null || e.getAnnotation(Exclusive.class) != null || e.getAnnotation(Shared.class) != null).map(e -> this.fromExecutableElement(type, (ExecutableElement)e)).collect(Collectors.toList())).isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "The service " + serviceName + " has no handlers", element);
        }
        try {
            return new Service.Builder().withTargetPkg((CharSequence)targetPkg).withTargetFqcn((CharSequence)targetFqcn).withServiceName(serviceName).withServiceType(type).withHandlers(handlers).validateAndBuild();
        }
        catch (Exception e2) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Can't build the service " + serviceName + ": " + e2.getMessage(), element);
            return null;
        }
    }

    private void validateType(TypeElement element) {
        if (!element.getTypeParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The ServiceProcessor doesn't support services with generics", element);
        }
        if (element.getKind().equals((Object)ElementKind.ENUM)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The EntityProcessor doesn't support enums", element);
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The annotated class is private", element);
        }
    }

    private Handler fromExecutableElement(ServiceType serviceType, ExecutableElement element) {
        if (!element.getTypeParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The EntityProcessor doesn't support methods with generics", element);
        }
        if (element.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "You cannot annotate a constructor as Restate method");
        }
        if (element.getKind().equals((Object)ElementKind.STATIC_INIT)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "You cannot annotate a static init as Restate method");
        }
        boolean isAnnotatedWithShared = element.getAnnotation(Shared.class) != null;
        boolean isAnnotatedWithExclusive = element.getAnnotation(Exclusive.class) != null;
        boolean isAnnotatedWithWorkflow = element.getAnnotation(Workflow.class) != null;
        boolean hasAnyAnnotation = isAnnotatedWithExclusive || isAnnotatedWithShared || isAnnotatedWithWorkflow;
        boolean hasExactlyOneAnnotation = Boolean.logicalXor(isAnnotatedWithShared, Boolean.logicalXor(isAnnotatedWithWorkflow, isAnnotatedWithExclusive));
        if (hasAnyAnnotation && !hasExactlyOneAnnotation) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "You can have only one annotation between @Shared, @Exclusive and @Workflow to a method", element);
        }
        HandlerType handlerType = isAnnotatedWithWorkflow ? HandlerType.WORKFLOW : (isAnnotatedWithShared ? HandlerType.SHARED : (isAnnotatedWithExclusive ? HandlerType.EXCLUSIVE : this.defaultHandlerType(serviceType, element)));
        this.validateMethodSignature(serviceType, handlerType, element);
        try {
            return new Handler.Builder().withName((CharSequence)element.getSimpleName()).withHandlerType(handlerType).withInputType(element.getParameters().size() > 1 ? this.payloadFromType(element.getParameters().get(1).asType()) : EMPTY_PAYLOAD).withOutputType(!element.getReturnType().getKind().equals((Object)TypeKind.VOID) ? this.payloadFromType(element.getReturnType()) : EMPTY_PAYLOAD).validateAndBuild();
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Error when building handler: " + e.getMessage(), element);
            return null;
        }
    }

    private HandlerType defaultHandlerType(ServiceType serviceType, ExecutableElement element) {
        switch (serviceType) {
            case SERVICE: {
                return HandlerType.STATELESS;
            }
            case VIRTUAL_OBJECT: {
                return HandlerType.EXCLUSIVE;
            }
            case WORKFLOW: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Workflow methods MUST be annotated with either @Shared or @Workflow", element);
            }
        }
        throw new IllegalStateException("Unexpected");
    }

    private void validateMethodSignature(ServiceType serviceType, HandlerType handlerType, ExecutableElement element) {
        switch (handlerType) {
            case SHARED: {
                if (serviceType == ServiceType.WORKFLOW) {
                    this.validateFirstParameterType(WorkflowSharedContext.class, element);
                    break;
                }
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(SharedObjectContext.class, element);
                    break;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "The annotation @Shared is not supported by the service type " + serviceType, element);
                break;
            }
            case EXCLUSIVE: {
                if (serviceType == ServiceType.VIRTUAL_OBJECT) {
                    this.validateFirstParameterType(ObjectContext.class, element);
                    break;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "The annotation @Exclusive is not supported by the service type " + serviceType, element);
                break;
            }
            case STATELESS: {
                this.validateFirstParameterType(Context.class, element);
                break;
            }
            case WORKFLOW: {
                if (serviceType == ServiceType.WORKFLOW) {
                    this.validateFirstParameterType(WorkflowContext.class, element);
                    break;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "The annotation @Shared is not supported by the service type " + serviceType, element);
            }
        }
    }

    private void validateFirstParameterType(Class<?> clazz, ExecutableElement element) {
        if (!this.types.isSameType(element.getParameters().get(0).asType(), this.elements.getTypeElement(clazz.getCanonicalName()).asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The method signature must have " + clazz.getCanonicalName() + " as first parameter", element);
        }
    }

    private PayloadType payloadFromType(TypeMirror typeMirror) {
        Objects.requireNonNull(typeMirror);
        return new PayloadType(false, typeMirror.toString(), ElementConverter.boxedType(typeMirror), ElementConverter.serdeDecl(typeMirror));
    }

    private static String serdeDecl(TypeMirror ty) {
        switch (ty.getKind()) {
            case BOOLEAN: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_BOOLEAN";
            }
            case BYTE: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_BYTE";
            }
            case SHORT: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_SHORT";
            }
            case INT: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_INT";
            }
            case LONG: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_LONG";
            }
            case CHAR: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_CHAR";
            }
            case FLOAT: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_FLOAT";
            }
            case DOUBLE: {
                return "dev.restate.sdk.common.CoreSerdes.JSON_DOUBLE";
            }
            case VOID: {
                return "dev.restate.sdk.common.CoreSerdes.VOID";
            }
        }
        return "dev.restate.sdk.serde.jackson.JacksonSerdes.of(new com.fasterxml.jackson.core.type.TypeReference<" + ty + ">() {})";
    }

    private static String boxedType(TypeMirror ty) {
        switch (ty.getKind()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTE: {
                return "Byte";
            }
            case SHORT: {
                return "Short";
            }
            case INT: {
                return "Integer";
            }
            case LONG: {
                return "Long";
            }
            case CHAR: {
                return "Char";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case VOID: {
                return "Void";
            }
        }
        return ty.toString();
    }
}

