/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.gen.model;

import dev.restate.sdk.annotation.Exclusive;
import dev.restate.sdk.annotation.Handler;
import dev.restate.sdk.annotation.Shared;
import dev.restate.sdk.annotation.VirtualObject;
import dev.restate.sdk.annotation.Workflow;
import dev.restate.sdk.common.ComponentType;
import dev.restate.sdk.gen.model.Method;
import dev.restate.sdk.gen.model.MethodType;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Service {
    private final CharSequence targetPkg;
    private final CharSequence targetFqcn;
    private final String componentName;
    private final ComponentType componentType;
    private final List<Method> methods;

    Service(CharSequence targetPkg, CharSequence targetFqcn, String componentName, ComponentType componentType, List<Method> methods) {
        this.targetPkg = targetPkg;
        this.targetFqcn = targetFqcn;
        this.componentName = componentName;
        this.componentType = componentType;
        this.methods = methods;
    }

    public CharSequence getTargetPkg() {
        return this.targetPkg;
    }

    public CharSequence getTargetFqcn() {
        return this.targetFqcn;
    }

    public String getFullyQualifiedComponentName() {
        return this.componentName;
    }

    public String getSimpleComponentName() {
        return this.componentName.substring(this.componentName.lastIndexOf(46) + 1);
    }

    public CharSequence getGeneratedClassFqcnPrefix() {
        if (this.targetPkg == null || this.targetPkg.length() == 0) {
            return this.getSimpleComponentName();
        }
        return this.targetPkg + "." + this.getSimpleComponentName();
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public static Service fromTypeElement(TypeElement element, Messager messager, Elements elements, Types types) {
        String componentName;
        boolean isAnnotatedWithWorkflow;
        Service.validateType(element, messager);
        dev.restate.sdk.annotation.Service serviceAnnotation = element.getAnnotation(dev.restate.sdk.annotation.Service.class);
        VirtualObject virtualObjectAnnotation = element.getAnnotation(VirtualObject.class);
        Workflow workflowAnnotation = element.getAnnotation(Workflow.class);
        boolean isAnnotatedWithService = serviceAnnotation != null;
        boolean isAnnotatedWithVirtualObject = virtualObjectAnnotation != null;
        boolean bl = isAnnotatedWithWorkflow = workflowAnnotation != null;
        assert (isAnnotatedWithWorkflow || isAnnotatedWithVirtualObject || isAnnotatedWithService);
        if (!Boolean.logicalXor(isAnnotatedWithService, Boolean.logicalXor(isAnnotatedWithWorkflow, isAnnotatedWithVirtualObject))) {
            messager.printMessage(Diagnostic.Kind.ERROR, "The type can be annotated only with one annotation between @VirtualObject, @Workflow and @Service", element);
        }
        ComponentType type = isAnnotatedWithWorkflow ? ComponentType.WORKFLOW : (isAnnotatedWithService ? ComponentType.SERVICE : ComponentType.VIRTUAL_OBJECT);
        Name targetPkg = elements.getPackageOf(element).getQualifiedName();
        Name targetFqcn = element.getQualifiedName();
        String string = isAnnotatedWithService ? serviceAnnotation.name() : (componentName = isAnnotatedWithVirtualObject ? virtualObjectAnnotation.name() : workflowAnnotation.name());
        if (componentName.isEmpty()) {
            String simpleComponentName = targetFqcn.toString().substring(targetPkg.length()).replaceAll(Pattern.quote("."), "");
            componentName = targetPkg.length() > 0 ? targetPkg + "." + simpleComponentName : simpleComponentName;
        }
        List<Method> methods = elements.getAllMembers(element).stream().filter(e -> e instanceof ExecutableElement).filter(e -> e.getAnnotation(Handler.class) != null || e.getAnnotation(Workflow.class) != null || e.getAnnotation(Exclusive.class) != null || e.getAnnotation(Shared.class) != null).map(e -> Method.fromExecutableElement(type, (ExecutableElement)e, messager, elements, types)).collect(Collectors.toList());
        Service.validateMethods(type, methods, element, messager);
        return new Service(targetPkg, targetFqcn, componentName, type, methods);
    }

    private static void validateType(TypeElement element, Messager messager) {
        if (!element.getTypeParameters().isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, "The EntityProcessor doesn't support services with generics", element);
        }
        if (element.getKind().equals((Object)ElementKind.ENUM)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "The EntityProcessor doesn't support enums", element);
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "The annotated class is private", element);
        }
    }

    private static void validateMethods(ComponentType componentType, List<Method> methods, TypeElement element, Messager messager) {
        if (componentType.equals((Object)ComponentType.WORKFLOW) && methods.stream().filter(m -> m.getMethodType().equals((Object)MethodType.WORKFLOW)).count() != 1L) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Workflow services must have exactly one method annotated as @Workflow", element);
        }
    }
}

