/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.gen;

import dev.restate.sdk.common.ComponentAdapter;
import dev.restate.sdk.common.ComponentType;
import dev.restate.sdk.gen.HandlebarsCodegen;
import dev.restate.sdk.gen.model.Service;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"dev.restate.sdk.annotation.Service", "dev.restate.sdk.annotation.Workflow", "dev.restate.sdk.annotation.VirtualObject"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class ComponentProcessor
extends AbstractProcessor {
    private HandlebarsCodegen serviceAdapterCodegen;
    private HandlebarsCodegen clientCodegen;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.serviceAdapterCodegen = new HandlebarsCodegen(processingEnv.getFiler(), "ComponentAdapter", Map.of(ComponentType.WORKFLOW, "templates.workflow", ComponentType.SERVICE, "templates", ComponentType.VIRTUAL_OBJECT, "templates"));
        this.clientCodegen = new HandlebarsCodegen(processingEnv.getFiler(), "Client", Map.of(ComponentType.WORKFLOW, "templates.workflow", ComponentType.SERVICE, "templates", ComponentType.VIRTUAL_OBJECT, "templates"));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Path resourceFilePath;
        List parsedServices = annotations.stream().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream()).filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> Service.fromTypeElement((TypeElement)e, this.processingEnv.getMessager(), this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils())).collect(Collectors.toList());
        for (Service e2 : parsedServices) {
            try {
                this.serviceAdapterCodegen.generate(e2);
                this.clientCodegen.generate(e2);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            resourceFilePath = ComponentProcessor.readOrCreateResource(this.processingEnv.getFiler(), "META-INF/services/" + ComponentAdapter.class.getCanonicalName());
            Files.createDirectories(resourceFilePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(resourceFilePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            for (Service svc : parsedServices) {
                writer.write(svc.getGeneratedClassFqcnPrefix() + "ComponentAdapter");
                writer.write(10);
            }
        }
        catch (IOException e4) {
            throw new RuntimeException(e4);
        }
        return false;
    }

    public static Path readOrCreateResource(Filer filer, String file) throws IOException {
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", file);
            return new File(fileObject.toUri()).toPath();
        }
        catch (IOException e) {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", file, new Element[0]);
            return new File(fileObject.toUri()).toPath();
        }
    }
}

