/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.lookup;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.hosts.HostsFileParser;
import org.xbill.DNS.lookup.InvalidZoneDataException;
import org.xbill.DNS.lookup.LookupFailedException;
import org.xbill.DNS.lookup.LookupResult;
import org.xbill.DNS.lookup.NoSuchDomainException;
import org.xbill.DNS.lookup.NoSuchRRSetException;
import org.xbill.DNS.lookup.RedirectOverflowException;
import org.xbill.DNS.lookup.ServerFailedException;

public class LookupSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupSession.class);
    public static final int DEFAULT_MAX_ITERATIONS = 16;
    public static final int DEFAULT_NDOTS = 1;
    @NonNull
    private final Resolver resolver;
    private final int maxRedirects;
    private final int ndots;
    private final List<Name> searchPath;
    private final boolean cycleResults;
    private final Map<Integer, Cache> caches;
    private final HostsFileParser hostsFileParser;

    public static LookupSessionBuilder builder() {
        return new LookupSessionBuilder(){

            @Override
            public LookupSession build() {
                this.preBuild();
                return super.build();
            }
        };
    }

    public CompletionStage<LookupResult> lookupAsync(Name name, int type, int dclass) {
        List<Name> searchNames = this.expandName(name);
        LookupResult localHostsLookupResult = this.lookupWithHosts(searchNames, type);
        if (localHostsLookupResult != null) {
            return CompletableFuture.completedFuture(localHostsLookupResult);
        }
        CompletableFuture<LookupResult> future = new CompletableFuture<LookupResult>();
        this.lookupUntilSuccess(searchNames.iterator(), type, dclass, future);
        return future;
    }

    List<Name> expandName(Name name) {
        if (name.isAbsolute()) {
            return Collections.singletonList(name);
        }
        List fromSearchPath = this.searchPath.stream().map(searchSuffix -> LookupSession.safeConcat(name, searchSuffix)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (name.labels() > this.ndots) {
            fromSearchPath.add(0, LookupSession.safeConcat(name, Name.root));
        } else {
            fromSearchPath.add(LookupSession.safeConcat(name, Name.root));
        }
        return fromSearchPath;
    }

    private static Name safeConcat(Name name, Name suffix) {
        try {
            return Name.concatenate(name, suffix);
        }
        catch (NameTooLongException e) {
            return null;
        }
    }

    private LookupResult lookupWithHosts(List<Name> names, int type) {
        if (this.hostsFileParser != null && (type == 1 || type == 28)) {
            try {
                for (Name name : names) {
                    Optional<InetAddress> result = this.hostsFileParser.getAddressForHost(name, type);
                    if (!result.isPresent()) continue;
                    Record r = type == 1 ? new ARecord(name, 1, 0L, result.get()) : new AAAARecord(name, 1, 0L, result.get());
                    return new LookupResult(Collections.singletonList(r), Collections.emptyList());
                }
            }
            catch (IOException e) {
                log.debug("Local hosts database parsing failed, ignoring and using resolver", e);
            }
        }
        return null;
    }

    private void lookupUntilSuccess(Iterator<Name> names, int type, int dclass, CompletableFuture<LookupResult> future) {
        Record query = Record.newRecord(names.next(), type, dclass);
        this.lookupWithCache(query, null).thenCompose(answer -> this.resolveRedirects((LookupResult)answer, query)).whenComplete((result, ex) -> {
            Throwable cause;
            Throwable throwable = cause = ex == null ? null : ex.getCause();
            if (cause instanceof NoSuchDomainException || cause instanceof NoSuchRRSetException) {
                if (names.hasNext()) {
                    this.lookupUntilSuccess(names, type, dclass, future);
                } else {
                    future.completeExceptionally(cause);
                }
            } else if (cause != null) {
                future.completeExceptionally(cause);
            } else {
                future.complete((LookupResult)result);
            }
        });
    }

    private CompletionStage<LookupResult> lookupWithCache(Record queryRecord, List<Name> aliases) {
        return Optional.ofNullable(this.caches.get(queryRecord.getDClass())).map(c -> c.lookupRecords(queryRecord.getName(), queryRecord.getType(), 3)).map(setResponse -> this.setResponseToMessageFuture((SetResponse)setResponse, queryRecord)).orElseGet(() -> this.lookupWithResolver(queryRecord, aliases));
    }

    private CompletionStage<LookupResult> lookupWithResolver(Record queryRecord, List<Name> aliases) {
        return this.resolver.sendAsync(Message.newQuery(queryRecord)).thenApply(this::maybeAddToCache).thenApply(answer -> LookupSession.buildResult(answer, aliases, queryRecord));
    }

    private Message maybeAddToCache(Message message) {
        Optional.ofNullable(this.caches.get(message.getQuestion().getDClass())).ifPresent(cache -> cache.addMessage(message));
        return message;
    }

    private CompletionStage<LookupResult> setResponseToMessageFuture(SetResponse setResponse, Record queryRecord) {
        if (setResponse.isNXDOMAIN()) {
            return this.completeExceptionally(new NoSuchDomainException(queryRecord.getName(), queryRecord.getType()));
        }
        if (setResponse.isNXRRSET()) {
            return this.completeExceptionally(new NoSuchRRSetException(queryRecord.getName(), queryRecord.getType()));
        }
        if (setResponse.isSuccessful()) {
            List<Record> records = setResponse.answers().stream().flatMap(rrset -> rrset.rrs(this.cycleResults).stream()).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new LookupResult(records, null));
        }
        return null;
    }

    private <T extends LookupFailedException> CompletionStage<LookupResult> completeExceptionally(T failure) {
        CompletableFuture<LookupResult> future = new CompletableFuture<LookupResult>();
        future.completeExceptionally(failure);
        return future;
    }

    private CompletionStage<LookupResult> resolveRedirects(LookupResult response, Record query) {
        CompletableFuture<LookupResult> future = new CompletableFuture<LookupResult>();
        this.maybeFollowRedirect(response, query, 1, future);
        return future;
    }

    private void maybeFollowRedirect(LookupResult response, Record query, int redirectCount, CompletableFuture<LookupResult> future) {
        try {
            if (redirectCount > this.maxRedirects) {
                throw new RedirectOverflowException(String.format("Refusing to follow more than %s redirects", this.maxRedirects));
            }
            List<Record> records = response.getRecords();
            if (records.isEmpty()) {
                future.complete(response);
            } else if (records.get(0).getType() == 39 || records.get(0).getType() == 5) {
                this.lookupWithCache(this.buildRedirectQuery(response, query), this.makeAliases(response.getAliases(), query.getName())).thenAccept(m -> this.maybeFollowRedirect((LookupResult)m, query, redirectCount + 1, future));
            } else {
                future.complete(response);
            }
        }
        catch (LookupFailedException e) {
            future.completeExceptionally(e);
        }
    }

    private List<Name> makeAliases(List<Name> previous, Name name) {
        if (previous == null) {
            return Collections.singletonList(name);
        }
        ArrayList<Name> copy = new ArrayList<Name>(previous);
        copy.add(name);
        return Collections.unmodifiableList(copy);
    }

    private Record buildRedirectQuery(LookupResult response, Record question) {
        List<Record> answer = response.getRecords();
        Record firstAnswer = answer.get(0);
        if (answer.size() != 1) {
            throw new InvalidZoneDataException("Multiple CNAME RRs not allowed, see RFC1034 3.6.2");
        }
        if (firstAnswer.getType() == 5) {
            return Record.newRecord(((CNAMERecord)firstAnswer).getTarget(), question.getType(), question.getDClass());
        }
        try {
            Name name = question.getName().fromDNAME((DNAMERecord)firstAnswer);
            return Record.newRecord(name, question.getType(), question.getDClass());
        }
        catch (NameTooLongException e) {
            throw new InvalidZoneDataException("DNAME redirect would result in a name that would be too long");
        }
    }

    private static LookupResult buildResult(Message answer, List<Name> aliases, Record query) {
        int rcode = answer.getRcode();
        List<Record> answerRecords = answer.getSection(1);
        if (answerRecords.isEmpty()) {
            switch (rcode) {
                case 3: {
                    throw new NoSuchDomainException(query.getName(), query.getType());
                }
                case 8: {
                    throw new NoSuchRRSetException(query.getName(), query.getType());
                }
                case 2: {
                    throw new ServerFailedException();
                }
            }
            throw new LookupFailedException(String.format("Unknown non-success error code %s", Rcode.string(rcode)));
        }
        return new LookupResult(answerRecords, aliases);
    }

    @Generated
    private static int $default$maxRedirects() {
        return 16;
    }

    @Generated
    private static int $default$ndots() {
        return 1;
    }

    @Generated
    private static boolean $default$cycleResults() {
        return false;
    }

    @Generated
    LookupSession(@NonNull Resolver resolver, int maxRedirects, int ndots, List<Name> searchPath, boolean cycleResults, Map<Integer, Cache> caches, HostsFileParser hostsFileParser) {
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        this.resolver = resolver;
        this.maxRedirects = maxRedirects;
        this.ndots = ndots;
        this.searchPath = searchPath;
        this.cycleResults = cycleResults;
        this.caches = caches;
        this.hostsFileParser = hostsFileParser;
    }

    public static class LookupSessionBuilder {
        @Generated
        private Resolver resolver;
        @Generated
        private boolean maxRedirects$set;
        @Generated
        private int maxRedirects$value;
        @Generated
        private boolean ndots$set;
        @Generated
        private int ndots$value;
        @Generated
        private ArrayList<Name> searchPath;
        @Generated
        private boolean cycleResults$set;
        @Generated
        private boolean cycleResults$value;
        @Generated
        private ArrayList<Integer> caches$key;
        @Generated
        private ArrayList<Cache> caches$value;
        @Generated
        private HostsFileParser hostsFileParser;

        public LookupSessionBuilder defaultHostsFileParser() {
            this.hostsFileParser = new HostsFileParser();
            return this;
        }

        void preBuild() {
            if (this.searchPath != null) {
                this.searchPath = this.searchPath.stream().map(name -> {
                    try {
                        return Name.concatenate(name, Name.root);
                    }
                    catch (NameTooLongException e) {
                        throw new IllegalArgumentException("Search path name too long");
                    }
                }).collect(Collectors.toCollection(ArrayList::new));
            }
        }

        @Generated
        LookupSessionBuilder() {
        }

        @Generated
        public LookupSessionBuilder resolver(@NonNull Resolver resolver) {
            if (resolver == null) {
                throw new NullPointerException("resolver is marked non-null but is null");
            }
            this.resolver = resolver;
            return this;
        }

        @Generated
        public LookupSessionBuilder maxRedirects(int maxRedirects) {
            this.maxRedirects$value = maxRedirects;
            this.maxRedirects$set = true;
            return this;
        }

        @Generated
        public LookupSessionBuilder ndots(int ndots) {
            this.ndots$value = ndots;
            this.ndots$set = true;
            return this;
        }

        @Generated
        public LookupSessionBuilder searchPath(Name searchPath) {
            if (this.searchPath == null) {
                this.searchPath = new ArrayList();
            }
            this.searchPath.add(searchPath);
            return this;
        }

        @Generated
        public LookupSessionBuilder searchPath(Collection<? extends Name> searchPath) {
            if (this.searchPath == null) {
                this.searchPath = new ArrayList();
            }
            this.searchPath.addAll(searchPath);
            return this;
        }

        @Generated
        public LookupSessionBuilder clearSearchPath() {
            if (this.searchPath != null) {
                this.searchPath.clear();
            }
            return this;
        }

        @Generated
        public LookupSessionBuilder cycleResults(boolean cycleResults) {
            this.cycleResults$value = cycleResults;
            this.cycleResults$set = true;
            return this;
        }

        @Generated
        public LookupSessionBuilder cache(Integer cacheKey, Cache cacheValue) {
            if (this.caches$key == null) {
                this.caches$key = new ArrayList();
                this.caches$value = new ArrayList();
            }
            this.caches$key.add(cacheKey);
            this.caches$value.add(cacheValue);
            return this;
        }

        @Generated
        public LookupSessionBuilder caches(Map<? extends Integer, ? extends Cache> caches) {
            if (this.caches$key == null) {
                this.caches$key = new ArrayList();
                this.caches$value = new ArrayList();
            }
            for (Map.Entry<? extends Integer, ? extends Cache> $lombokEntry : caches.entrySet()) {
                this.caches$key.add($lombokEntry.getKey());
                this.caches$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public LookupSessionBuilder clearCaches() {
            if (this.caches$key != null) {
                this.caches$key.clear();
                this.caches$value.clear();
            }
            return this;
        }

        @Generated
        public LookupSessionBuilder hostsFileParser(HostsFileParser hostsFileParser) {
            this.hostsFileParser = hostsFileParser;
            return this;
        }

        @Generated
        public LookupSession build() {
            Map<Object, Object> caches;
            List<Name> searchPath;
            switch (this.searchPath == null ? 0 : this.searchPath.size()) {
                case 0: {
                    searchPath = Collections.emptyList();
                    break;
                }
                case 1: {
                    searchPath = Collections.singletonList(this.searchPath.get(0));
                    break;
                }
                default: {
                    searchPath = Collections.unmodifiableList(new ArrayList<Name>(this.searchPath));
                }
            }
            switch (this.caches$key == null ? 0 : this.caches$key.size()) {
                case 0: {
                    caches = Collections.emptyMap();
                    break;
                }
                case 1: {
                    caches = Collections.singletonMap(this.caches$key.get(0), this.caches$value.get(0));
                    break;
                }
                default: {
                    caches = new LinkedHashMap(this.caches$key.size() < 0x40000000 ? 1 + this.caches$key.size() + (this.caches$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.caches$key.size(); ++$i) {
                        caches.put(this.caches$key.get($i), this.caches$value.get($i));
                    }
                    caches = Collections.unmodifiableMap(caches);
                }
            }
            int maxRedirects$value = this.maxRedirects$value;
            if (!this.maxRedirects$set) {
                maxRedirects$value = LookupSession.$default$maxRedirects();
            }
            int ndots$value = this.ndots$value;
            if (!this.ndots$set) {
                ndots$value = LookupSession.$default$ndots();
            }
            boolean cycleResults$value = this.cycleResults$value;
            if (!this.cycleResults$set) {
                cycleResults$value = LookupSession.$default$cycleResults();
            }
            return new LookupSession(this.resolver, maxRedirects$value, ndots$value, searchPath, cycleResults$value, caches, this.hostsFileParser);
        }

        @Generated
        public String toString() {
            return "LookupSession.LookupSessionBuilder(resolver=" + this.resolver + ", maxRedirects$value=" + this.maxRedirects$value + ", ndots$value=" + this.ndots$value + ", searchPath=" + this.searchPath + ", cycleResults$value=" + this.cycleResults$value + ", caches$key=" + this.caches$key + ", caches$value=" + this.caches$value + ", hostsFileParser=" + this.hostsFileParser + ")";
        }
    }
}

