/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.scanners;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.guice.bean.reflect.BeanProperty;
import org.sonatype.guice.plexus.config.PlexusBeanMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusXmlMetadata
implements PlexusBeanMetadata {
    private Map<String, Configuration> configurationMap = Collections.emptyMap();
    private Map<String, Requirement> requirementMap = Collections.emptyMap();

    PlexusXmlMetadata(Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        this.merge(configurationMap, requirementMap);
    }

    @Override
    public boolean isEmpty() {
        return this.configurationMap.isEmpty() && this.requirementMap.isEmpty();
    }

    @Override
    public Configuration getConfiguration(BeanProperty<?> property) {
        return this.configurationMap.remove(property.getName());
    }

    @Override
    public Requirement getRequirement(BeanProperty<?> property) {
        Requirement requirement = this.requirementMap.remove(property.getName());
        if (null == requirement) {
            requirement = this.requirementMap.remove(property.getType().getRawType().getName());
        }
        return requirement;
    }

    void merge(Map<String, Configuration> extraConfiguration, Map<String, Requirement> extraRequirements) {
        this.configurationMap = PlexusXmlMetadata.addIfMissing(this.configurationMap, extraConfiguration);
        this.requirementMap = PlexusXmlMetadata.addIfMissing(this.requirementMap, extraRequirements);
    }

    private static <K, V> Map<K, V> addIfMissing(Map<K, V> primary2, Map<K, V> secondary) {
        if (secondary.isEmpty()) {
            return primary2;
        }
        if (primary2.isEmpty()) {
            return secondary;
        }
        HashMap<K, V> tempMap = new HashMap<K, V>(secondary);
        tempMap.putAll(primary2);
        return tempMap;
    }
}

