/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="javadoc", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JavadocReport
extends AbstractJavadocMojo
implements MavenReport {
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/apidocs", required=true)
    private File reportOutputDirectory;
    @Parameter(property="destDir", defaultValue="apidocs")
    private String destDir;
    @Parameter(property="name")
    private String name;
    @Parameter(property="description")
    private String description;

    @Override
    public String getName(Locale locale) {
        if (StringUtils.isEmpty(this.name)) {
            return this.getBundle(locale).getString("report.javadoc.name");
        }
        return this.name;
    }

    @Override
    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty(this.description)) {
            return this.getBundle(locale).getString("report.javadoc.description");
        }
        return this.description;
    }

    @Override
    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        try {
            this.executeReport(locale);
        }
        catch (RuntimeException | MavenReportException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error("Error while creating javadoc report: " + e.getMessage(), e);
        }
    }

    @Override
    public String getOutputName() {
        return this.destDir + "/index";
    }

    @Override
    public boolean isExternalReport() {
        return true;
    }

    @Override
    public boolean canGenerateReport() {
        boolean canGenerate = false;
        if (this.isAggregator() || !"pom".equals(this.project.getPackaging())) {
            Map<Path, Collection<String>> files;
            try {
                Collection sourcePaths = this.getSourcePaths().stream().flatMap(e -> e.getSourcePaths().stream()).collect(Collectors.toList());
                files = this.getFiles(sourcePaths);
            }
            catch (MavenReportException e2) {
                this.getLog().error(e2.getMessage(), e2);
                return false;
            }
            canGenerate = this.canGenerateReport(files);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(" canGenerateReport = " + canGenerate + " for project " + this.project);
        }
        return canGenerate;
    }

    @Override
    public String getCategoryName() {
        return "Project Reports";
    }

    @Override
    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    @Override
    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    public void setDestDir(String theDestDir) {
        this.destDir = theDestDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory, theDestDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info("Skipping javadoc generation");
            return;
        }
        try {
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate(sink, locale);
        }
        catch (RuntimeException | MavenReportException e) {
            this.failOnError("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", e);
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("javadoc-report", locale, this.getClass().getClassLoader());
    }
}

