/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.inheritance;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.site.decoration.inheritance.URIPathDescriptor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=DecorationModelInheritanceAssembler.class)
public class DefaultDecorationModelInheritanceAssembler
implements DecorationModelInheritanceAssembler {
    @Override
    public void assembleModelInheritance(String name, DecorationModel child, DecorationModel parent, String childBaseUrl, String parentBaseUrl) {
        if (parent == null || !child.isMergeParent()) {
            return;
        }
        child.setCombineSelf(parent.getCombineSelf());
        URLRebaser urlContainer = new URLRebaser(parentBaseUrl, childBaseUrl);
        if (child.getBannerLeft() == null && parent.getBannerLeft() != null) {
            child.setBannerLeft(parent.getBannerLeft().clone());
            this.rebaseBannerPaths(child.getBannerLeft(), urlContainer);
        }
        if (child.getBannerRight() == null && parent.getBannerRight() != null) {
            child.setBannerRight(parent.getBannerRight().clone());
            this.rebaseBannerPaths(child.getBannerRight(), urlContainer);
        }
        if (child.isDefaultPublishDate() && parent.getPublishDate() != null) {
            child.setPublishDate(parent.getPublishDate().clone());
        }
        if (child.isDefaultVersion() && parent.getVersion() != null) {
            child.setVersion(parent.getVersion().clone());
        }
        if (child.getEdit() == null && parent.getEdit() != null) {
            child.setEdit(parent.getEdit());
        }
        if (child.getSkin() == null && parent.getSkin() != null) {
            child.setSkin(parent.getSkin().clone());
        }
        child.setPoweredBy(this.mergePoweredByLists(child.getPoweredBy(), parent.getPoweredBy(), urlContainer));
        if (parent.getLastModified() > child.getLastModified()) {
            child.setLastModified(parent.getLastModified());
        }
        if (child.getGoogleAdSenseClient() == null && parent.getGoogleAdSenseClient() != null) {
            child.setGoogleAdSenseClient(parent.getGoogleAdSenseClient());
        }
        if (child.getGoogleAdSenseSlot() == null && parent.getGoogleAdSenseSlot() != null) {
            child.setGoogleAdSenseSlot(parent.getGoogleAdSenseSlot());
        }
        if (child.getGoogleAnalyticsAccountId() == null && parent.getGoogleAnalyticsAccountId() != null) {
            child.setGoogleAnalyticsAccountId(parent.getGoogleAnalyticsAccountId());
        }
        this.assembleBodyInheritance(name, child, parent, urlContainer);
        this.assembleCustomInheritance(child, parent);
    }

    @Override
    public void resolvePaths(DecorationModel decoration, String baseUrl) {
        if (baseUrl == null) {
            return;
        }
        if (decoration.getBannerLeft() != null) {
            this.relativizeBannerPaths(decoration.getBannerLeft(), baseUrl);
        }
        if (decoration.getBannerRight() != null) {
            this.relativizeBannerPaths(decoration.getBannerRight(), baseUrl);
        }
        for (Logo logo : decoration.getPoweredBy()) {
            this.relativizeLogoPaths(logo, baseUrl);
        }
        if (decoration.getBody() != null) {
            for (LinkItem linkItem : decoration.getBody().getLinks()) {
                this.relativizeLinkItemPaths(linkItem, baseUrl);
            }
            for (LinkItem linkItem : decoration.getBody().getBreadcrumbs()) {
                this.relativizeLinkItemPaths(linkItem, baseUrl);
            }
            for (Menu menu : decoration.getBody().getMenus()) {
                this.relativizeMenuPaths(menu.getItems(), baseUrl);
            }
        }
    }

    private void relativizeBannerPaths(Banner banner, String baseUrl) {
        banner.setHref(this.relativizeLink(banner.getHref(), baseUrl));
        banner.setSrc(this.relativizeLink(banner.getSrc(), baseUrl));
    }

    private void rebaseBannerPaths(Banner banner, URLRebaser urlContainer) {
        if (banner.getHref() != null) {
            banner.setHref(urlContainer.rebaseLink(banner.getHref()));
        }
        if (banner.getSrc() != null) {
            banner.setSrc(urlContainer.rebaseLink(banner.getSrc()));
        }
    }

    private void assembleCustomInheritance(DecorationModel child, DecorationModel parent) {
        if (child.getCustom() == null) {
            child.setCustom(parent.getCustom());
        } else {
            child.setCustom(Xpp3Dom.mergeXpp3Dom((Xpp3Dom)child.getCustom(), (Xpp3Dom)parent.getCustom()));
        }
    }

    private void assembleBodyInheritance(String name, DecorationModel child, DecorationModel parent, URLRebaser urlContainer) {
        Body cBody = child.getBody();
        Body pBody = parent.getBody();
        if (cBody != null || pBody != null) {
            if (cBody == null) {
                cBody = new Body();
                child.setBody(cBody);
            }
            if (pBody == null) {
                pBody = new Body();
            }
            if (cBody.getHead() == null && pBody.getHead() != null) {
                cBody.setHead(pBody.getHead());
            }
            cBody.setLinks(this.mergeLinkItemLists(cBody.getLinks(), pBody.getLinks(), urlContainer, false));
            if (cBody.getBreadcrumbs().isEmpty() && !pBody.getBreadcrumbs().isEmpty()) {
                LinkItem breadcrumb = new LinkItem();
                breadcrumb.setName(name);
                breadcrumb.setHref("index.html");
                cBody.getBreadcrumbs().add(breadcrumb);
            }
            cBody.setBreadcrumbs(this.mergeLinkItemLists(cBody.getBreadcrumbs(), pBody.getBreadcrumbs(), urlContainer, true));
            cBody.setMenus(this.mergeMenus(cBody.getMenus(), pBody.getMenus(), urlContainer));
            if (cBody.getFooter() == null && pBody.getFooter() != null) {
                cBody.setFooter(pBody.getFooter());
            }
        }
    }

    private List<Menu> mergeMenus(List<Menu> childMenus, List<Menu> parentMenus, URLRebaser urlContainer) {
        ArrayList<Menu> menus = new ArrayList<Menu>(childMenus.size() + parentMenus.size());
        for (Menu menu : childMenus) {
            menus.add(menu);
        }
        int topCounter = 0;
        for (Menu menu : parentMenus) {
            Menu clone;
            if ("top".equals(menu.getInherit())) {
                clone = menu.clone();
                this.rebaseMenuPaths(clone.getItems(), urlContainer);
                menus.add(topCounter, clone);
                ++topCounter;
                continue;
            }
            if (!"bottom".equals(menu.getInherit())) continue;
            clone = menu.clone();
            this.rebaseMenuPaths(clone.getItems(), urlContainer);
            menus.add(clone);
        }
        return menus;
    }

    private void relativizeMenuPaths(List<MenuItem> items, String baseUrl) {
        for (MenuItem item : items) {
            this.relativizeLinkItemPaths(item, baseUrl);
            this.relativizeMenuPaths(item.getItems(), baseUrl);
        }
    }

    private void rebaseMenuPaths(List<MenuItem> items, URLRebaser urlContainer) {
        for (MenuItem item : items) {
            this.rebaseLinkItemPaths(item, urlContainer);
            this.rebaseMenuPaths(item.getItems(), urlContainer);
        }
    }

    private void relativizeLinkItemPaths(LinkItem item, String baseUrl) {
        item.setHref(this.relativizeLink(item.getHref(), baseUrl));
    }

    private void rebaseLinkItemPaths(LinkItem item, URLRebaser urlContainer) {
        item.setHref(urlContainer.rebaseLink(item.getHref()));
    }

    private void relativizeLogoPaths(Logo logo, String baseUrl) {
        logo.setImg(this.relativizeLink(logo.getImg(), baseUrl));
        this.relativizeLinkItemPaths(logo, baseUrl);
    }

    private void rebaseLogoPaths(Logo logo, URLRebaser urlContainer) {
        logo.setImg(urlContainer.rebaseLink(logo.getImg()));
        this.rebaseLinkItemPaths(logo, urlContainer);
    }

    private List<LinkItem> mergeLinkItemLists(List<LinkItem> childList, List<LinkItem> parentList, URLRebaser urlContainer, boolean cutParentAfterDuplicate) {
        ArrayList<LinkItem> items = new ArrayList<LinkItem>(childList.size() + parentList.size());
        for (LinkItem item : parentList) {
            if (!items.contains(item) && !childList.contains(item)) {
                LinkItem clone = item.clone();
                this.rebaseLinkItemPaths(clone, urlContainer);
                items.add(clone);
                continue;
            }
            if (!cutParentAfterDuplicate) continue;
            break;
        }
        for (LinkItem item : childList) {
            if (items.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    private List<Logo> mergePoweredByLists(List<Logo> childList, List<Logo> parentList, URLRebaser urlContainer) {
        ArrayList<Logo> logos = new ArrayList<Logo>(childList.size() + parentList.size());
        for (Logo logo : parentList) {
            if (logos.contains(logo)) continue;
            Logo clone = logo.clone();
            this.rebaseLogoPaths(clone, urlContainer);
            logos.add(clone);
        }
        for (Logo logo : childList) {
            if (logos.contains(logo)) continue;
            logos.add(logo);
        }
        return logos;
    }

    private String relativizeLink(String link, String baseUri) {
        if (link == null || baseUri == null) {
            return link;
        }
        try {
            URIPathDescriptor path = new URIPathDescriptor(baseUri, link);
            return path.relativizeLink().toString();
        }
        catch (IllegalArgumentException e) {
            return link;
        }
    }

    private static class URLRebaser {
        private final String oldPath;
        private final String newPath;

        URLRebaser(String oldPath, String newPath) {
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public String getNewPath() {
            return this.newPath;
        }

        public String getOldPath() {
            return this.oldPath;
        }

        public String rebaseLink(String link) {
            if (link == null || this.getOldPath() == null) {
                return link;
            }
            if (link.contains("${project.")) {
                throw new IllegalArgumentException("site.xml late interpolation ${project.*} expression found in link: '" + link + "'. Use early interpolation ${this.*}");
            }
            URIPathDescriptor oldPath = new URIPathDescriptor(this.getOldPath(), link);
            return oldPath.rebaseLink(this.getNewPath()).toString();
        }
    }
}

