/*
 * Decompiled with CFR 0.152.
 */
package dev.redcoke.mcserverping;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public final class MCServerPingResponse {
    private final int ping;
    private final String version;
    private final int protocol;
    private final int maxPlayers;
    private final int onlinePlayers;
    private final String motd;
    private final JsonArray descriptionExtras;
    private final String serverIcon;

    public MCServerPingResponse(int ping, String name, int protocol, Integer playerMax, Integer playerOnline, String motd, JsonArray descriptionExtras, String serverIcon) {
        this.ping = ping;
        this.version = name;
        this.protocol = protocol;
        this.maxPlayers = playerMax;
        this.onlinePlayers = playerOnline;
        this.motd = motd;
        this.descriptionExtras = descriptionExtras;
        this.serverIcon = serverIcon;
    }

    public static MCServerPingResponse serverPingFromJsonObj(JsonObject jsonObj) {
        int serverPing = jsonObj.get("ping").getAsInt();
        String versionName = jsonObj.get("version").getAsString();
        int serverProtocol = jsonObj.get("protocol").getAsInt();
        Integer playerMax = null;
        Integer playerOnline = null;
        if (jsonObj.has("players")) {
            playerMax = jsonObj.get("players").getAsJsonObject().get("max").getAsInt();
            playerOnline = jsonObj.get("players").getAsJsonObject().get("online").getAsInt();
        }
        String serverMOTD = jsonObj.get("description").getAsJsonObject().get("text").getAsString();
        JsonArray serverDescriptionExtra = jsonObj.get("description").getAsJsonObject().get("extra") == null ? null : jsonObj.get("description").getAsJsonObject().get("extra").getAsJsonArray();
        String favIcon = jsonObj.get("favicon").getAsString();
        return new MCServerPingResponse(serverPing, versionName, serverProtocol, playerMax, playerOnline, serverMOTD, serverDescriptionExtra, favIcon);
    }

    public int getPing() {
        return this.ping;
    }

    public String getName() {
        return this.version;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public Integer getPlayerMax() {
        return this.maxPlayers;
    }

    public Integer getPlayerOnline() {
        return this.onlinePlayers;
    }

    public String getMotd() {
        return this.motd;
    }

    public JsonArray getDescriptionExtras() {
        return this.descriptionExtras;
    }

    public String getServerIcon() {
        return this.serverIcon;
    }

    public String getAsJsonString() {
        return new Gson().newBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(this);
    }

    public JsonObject getAsJsonObject() {
        return JsonParser.parseString(this.getAsJsonString()).getAsJsonObject();
    }
}

