/*
 * Decompiled with CFR 0.152.
 */
package dev.redcoke.mcserverping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.redcoke.mcserverping.MCServerPingResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public final class MCServerPing {
    private MCServerPing() {
    }

    public static MCServerPingResponse getPing(String address) throws IOException, TimeoutException {
        return MCServerPing.getPing(address, 25565);
    }

    public static MCServerPingResponse getPing(String address, int port) throws IOException, TimeoutException {
        String json;
        if (address == null) {
            throw new IOException("Hostname cannot be null!");
        }
        String serverHost = address;
        int serverPort = port;
        Record[] srvRecords = new Lookup(String.format("_minecraft._tcp.%s", address), 33).run();
        if (srvRecords != null) {
            for (Record srvRecord : srvRecords) {
                SRVRecord srv = (SRVRecord)srvRecord;
                serverHost = srv.getTarget().toString().replaceFirst("\\.$", "");
                serverPort = srv.getPort();
            }
        }
        long ping = System.currentTimeMillis();
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(serverHost, serverPort), 5000);
            ping = System.currentTimeMillis() - ping;
            ByteArrayOutputStream handshakeStream = new ByteArrayOutputStream();
            DataOutputStream handshake = new DataOutputStream(handshakeStream);
            handshake.write(0);
            MCServerPing.writeVarInt(handshake, 4);
            MCServerPing.writeVarInt(handshake, address.length());
            handshake.writeBytes(address);
            handshake.writeShort(port);
            MCServerPing.writeVarInt(handshake, 1);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            MCServerPing.writeVarInt(out, handshakeStream.size());
            out.write(handshakeStream.toByteArray());
            out.writeByte(1);
            out.writeByte(0);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            MCServerPing.readVarInt(in);
            int id = MCServerPing.readVarInt(in);
            MCServerPing.io(id == -1, "Server ended data stream unexpectedly.");
            MCServerPing.io(id != 0, "Server returned invalid packet.");
            int length = MCServerPing.readVarInt(in);
            MCServerPing.io(length == -1, "Server ended data stream unexpectedly.");
            MCServerPing.io(length == 0, "Server returned unexpected value.");
            byte[] data = new byte[length];
            in.readFully(data);
            json = new String(data, StandardCharsets.UTF_8);
        }
        JsonObject jsonObj = JsonParser.parseString(json).getAsJsonObject();
        JsonElement descriptionJsonElement = jsonObj.get("description");
        if (descriptionJsonElement.isJsonObject()) {
            JsonObject descriptionJsonObject = descriptionJsonElement.getAsJsonObject();
            if (descriptionJsonObject.has("extra")) {
                descriptionJsonObject.addProperty("text", new TextComponent(ComponentSerializer.parse(descriptionJsonObject.get("extra").getAsJsonArray().toString())).toLegacyText());
                jsonObj.add("description", descriptionJsonObject);
            }
        } else {
            String description = descriptionJsonElement.getAsString();
            JsonObject descriptionJsonObj = new JsonObject();
            descriptionJsonObj.addProperty("text", description);
            jsonObj.add("description", descriptionJsonObj);
        }
        jsonObj.addProperty("ping", ping);
        return MCServerPingResponse.serverPingFromJsonObj(jsonObj);
    }

    public static void io(boolean b, String m) throws IOException {
        if (b) {
            throw new IOException(m);
        }
    }

    public static int readVarInt(DataInputStream in) throws IOException, TimeoutException {
        AtomicInteger k;
        int i = 0;
        int j = 0;
        do {
            k = new AtomicInteger();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<?> future = executor.submit(() -> {
                try {
                    k.set(in.readByte());
                }
                catch (IOException e) {
                    k.set(Integer.MAX_VALUE);
                }
            });
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            finally {
                executor.shutdownNow();
            }
            if (k.get() == Integer.MAX_VALUE) {
                throw new IOException();
            }
            i |= (k.get() & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new IOException("VarInt too big");
        } while ((k.get() & 0x80) == 128);
        return i;
    }

    public static void writeVarInt(DataOutputStream out, int inputParamInt) throws IOException {
        int paramInt = inputParamInt;
        while (true) {
            if ((paramInt & 0xFFFFFF80) == 0) {
                out.writeByte(paramInt);
                return;
            }
            out.writeByte(paramInt & 0x7F | 0x80);
            paramInt >>>= 7;
        }
    }
}

