/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.util;

import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.scan.annotations.DataGlobalAnnotation;
import dev.quantumfusion.hyphen.scan.annotations.HyphenAnnotation;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanUtil {
    public static AnnotatedType[] findPath(AnnotatedType root, Predicate<AnnotatedType> matcher, Function<AnnotatedType, AnnotatedType[]> splitter) {
        ArrayDeque<AnnotatedType[]> queue = new ArrayDeque<AnnotatedType[]>();
        HashSet<AnnotatedType> explored = new HashSet<AnnotatedType>();
        explored.add(root);
        queue.add(new AnnotatedType[]{root});
        while (!queue.isEmpty()) {
            int parentPathLength;
            AnnotatedType[] parentPath = (AnnotatedType[])queue.poll();
            AnnotatedType parent = parentPath[(parentPathLength = parentPath.length) - 1];
            if (matcher.test(parent)) {
                return parentPath;
            }
            for (AnnotatedType child : splitter.apply(parent)) {
                if (explored.contains(child)) continue;
                explored.add(child);
                queue.add(ScanUtil.append(parentPath, child));
            }
        }
        return null;
    }

    public static AnnotatedType[] append(AnnotatedType[] oldArray, AnnotatedType value) {
        int length = oldArray.length;
        AnnotatedType[] out = new AnnotatedType[length + 1];
        System.arraycopy(oldArray, 0, out, 0, length);
        out[length] = value;
        return out;
    }

    public static Map<Class<? extends Annotation>, Object> acquireAnnotations(SerializerHandler<?, ?> handler, @NotNull AnnotatedType self, @Nullable Clazz parent) {
        Class<?> classFrom;
        AnnotatedType annotatedType;
        LinkedHashMap<Class<? extends Annotation>, Object> out = new LinkedHashMap<Class<? extends Annotation>, Object>();
        if (parent != null) {
            Class<?> parentClass = parent.getDefinedClass();
            Package pack = parentClass.getPackage();
            if (pack != null) {
                ScanUtil.addAnnotations(pack, out);
            }
            ScanUtil.addAnnotations(parentClass, out);
        }
        if ((annotatedType = self) instanceof FieldAnnotatedType) {
            FieldAnnotatedType fieldAnnotatedType = (FieldAnnotatedType)annotatedType;
            ScanUtil.addAnnotations(fieldAnnotatedType.field, out);
            ScanUtil.addAnnotations(fieldAnnotatedType.annotatedType, out);
        } else {
            ScanUtil.addAnnotations(self, out);
        }
        if (out.containsKey(DataGlobalAnnotation.class)) {
            out.putAll(handler.globalAnnotations.get(out.get(DataGlobalAnnotation.class)));
        }
        if ((classFrom = ScanUtil.getClassFromOrNull(self.getType())) != null && handler.globalAnnotations.containsKey(classFrom)) {
            out.putAll(handler.globalAnnotations.get(classFrom));
        }
        return out;
    }

    public static void addAnnotations(AnnotatedElement annotations, Map<Class<? extends Annotation>, Object> map) {
        try {
            for (Annotation annotation : annotations.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotatedType = annotation.annotationType();
                if (!annotatedType.isAnnotationPresent(HyphenAnnotation.class)) continue;
                Object value = null;
                Method valueGetter = ScanUtil.getAnnotationValueGetter(annotatedType);
                if (valueGetter != null) {
                    value = valueGetter.invoke((Object)annotation, new Object[0]);
                }
                map.put(annotatedType, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nullable
    public static Method getAnnotationValueGetter(Class<? extends Annotation> annotation) {
        Method methodOut = null;
        for (Method method : annotation.getMethods()) {
            if (method.getDeclaringClass() == Annotation.class) continue;
            if (methodOut != null) {
                throw new RuntimeException("Annotation " + annotation.getSimpleName() + " has more than 1 field");
            }
            methodOut = method;
        }
        return methodOut;
    }

    public static AnnotatedType wrap(Type clazz) {
        return new AnnotatedWrapped(clazz);
    }

    public static Class<?> getClassFrom(AnnotatedType type) {
        return ScanUtil.getClassFrom(type.getType());
    }

    public static Class<?> getClassFrom(Type type) {
        Class<?> aClass = ScanUtil.getClassFromOrNull(type);
        if (aClass == null) {
            throw new IllegalArgumentException(type.getClass() + ": " + type);
        }
        return aClass;
    }

    @Nullable
    public static Class<?> getClassFromOrNull(Type type) {
        Type type2 = type;
        if (type2 instanceof Class) {
            Class c = (Class)type2;
            return c;
        }
        type2 = type;
        if (type2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type2;
            return ScanUtil.getClassFrom(pt.getRawType());
        }
        return null;
    }

    public record FieldAnnotatedType(Field field, AnnotatedType annotatedType) implements AnnotatedType
    {
        @Override
        public Type getType() {
            return this.annotatedType.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.field.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.field.getDeclaredAnnotations();
        }

        @Override
        public String toString() {
            return Arrays.toString(this.field.getDeclaredAnnotations());
        }
    }

    private record AnnotatedWrapped(Type type) implements AnnotatedType
    {
        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }
    }
}

