/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.util;

import dev.quantumfusion.hyphen.codegen.MethodHandler;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.util.ArrayUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class GenUtil {
    private static final char[] HYPHEN_METHOD_BASE_CHARS = "\u0d9eabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$0123456789".toCharArray();
    private static final Handle LAMBDA_METAFACTORY_HANDLE = GenUtil.createHandle(6, LambdaMetafactory.class, "metafactory", false, CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
    private static final Map<Character, Character> SAFE_METHOD_NAME_MAPPER = Map.of(Character.valueOf('['), Character.valueOf('$'), Character.valueOf(']'), Character.valueOf('$'), Character.valueOf('<'), Character.valueOf('$'), Character.valueOf('>'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf('$'), Character.valueOf(')'), Character.valueOf('$'), Character.valueOf('/'), Character.valueOf('\u2215'), Character.valueOf('.'), Character.valueOf('\u2022'), Character.valueOf(';'), Character.valueOf('\u037e'), Character.valueOf(':'), Character.valueOf('\uff1a'));

    public static Type[] of(Class<?>[] classes) {
        Type[] out = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            out[i] = GenUtil.of(classes[i]);
        }
        return out;
    }

    public static Type of(Class<?> aClass) {
        return Type.getType(aClass);
    }

    public static String internal(Class<?> aClass) {
        return Type.getInternalName(aClass);
    }

    public static String desc(Class<?> aClass) {
        return Type.getDescriptor(aClass);
    }

    public static void shouldCastGeneric(MethodHandler mh, Clazz clazz) {
        GenUtil.shouldCastGeneric(mh, clazz.getDefinedClass(), clazz.getBytecodeClass());
    }

    public static void shouldCastGeneric(MethodHandler mh, Class<?> actual, Class<?> bytecodeClass) {
        if (!actual.isAssignableFrom(bytecodeClass)) {
            mh.typeOp(192, actual);
        }
    }

    public static String methodDesc(Class<?> returnClass, Class<?> ... parameters) {
        return Type.getMethodDescriptor((Type)GenUtil.of(returnClass), (Type[])GenUtil.of(parameters));
    }

    public static Type methodTypeDesc(Class<?> returnClass, Class<?> ... parameters) {
        return Type.getMethodType((Type)GenUtil.of(returnClass), (Type[])GenUtil.of(parameters));
    }

    public static String hyphenShortMethodName(int methodId) {
        int length = (63 - Long.numberOfLeadingZeros(methodId)) / 6 + 1;
        char[] result = new char[length];
        for (int i = length - 1; i >= 0; --i) {
            result[i] = HYPHEN_METHOD_BASE_CHARS[methodId & 0x3F];
            methodId >>= 6;
        }
        return new String(result);
    }

    public static String upperCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String makeSafe(String str) {
        return str.chars().map(ch -> SAFE_METHOD_NAME_MAPPER.getOrDefault(Character.valueOf((char)ch), Character.valueOf((char)ch)).charValue()).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static Handle createHandle(int op, Class<?> owner, String name, boolean isInterface, Class<?> returnClass, Class<?> ... parameters) {
        return new Handle(op, Type.getInternalName(owner), name, GenUtil.methodDesc(returnClass, parameters), isInterface);
    }

    public static Handle createHandle(int op, String owner, String name, boolean isInterface, Class<?> returnClass, Class<?> ... parameters) {
        return new Handle(op, owner, name, GenUtil.methodDesc(returnClass, parameters), isInterface);
    }

    public static void createMethodRef(MethodVisitor mv, Class<?> targetInterface, String targetMethod, Class<?> targetMethodReturnClass, Class<?>[] targetMethodParameters, String sourceClass, String sourceMethod, Class<?> sourceMethodReturnClass, Class<?>[] capturedParameters, Class<?>[] uncapturedParameters) {
        mv.visitInvokeDynamicInsn(targetMethod, GenUtil.methodDesc(targetInterface, capturedParameters), LAMBDA_METAFACTORY_HANDLE, new Object[]{GenUtil.methodTypeDesc(targetMethodReturnClass, targetMethodParameters), GenUtil.createHandle(6, sourceClass, sourceMethod, false, sourceMethodReturnClass, ArrayUtil.combine(capturedParameters, uncapturedParameters)), GenUtil.methodTypeDesc(sourceMethodReturnClass, uncapturedParameters)});
    }
}

