/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.util;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class ArrayUtil {
    public static <A, B> void dualForEach(A[] a, B[] b, DualForEach<? super A, ? super B> dualForEach) {
        ArrayUtil.checkMatchingLength(a, b);
        for (int i = 0; i < a.length; ++i) {
            dualForEach.apply(a[i], b[i], i);
        }
    }

    public static <A, B> void dualFor(A[] a, B[] b, BiConsumer<? super A, ? super B> dualFor) {
        ArrayUtil.checkMatchingLength(a, b);
        for (int i = 0; i < a.length; ++i) {
            dualFor.accept(a[i], b[i]);
        }
    }

    private static void checkMatchingLength(Object[] a, Object[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("T length " + a.length + " does not match B length " + b.length);
        }
    }

    public static <A, B> B[] map(A[] a, IntFunction<B[]> creator, IndexedMap<? super A, ? extends B> mapper) {
        B[] out = creator.apply(a.length);
        for (int i = 0; i < a.length; ++i) {
            out[i] = mapper.apply(a[i], i);
        }
        return out;
    }

    public static <A, B> B[] map(A[] a, IntFunction<B[]> creator, Function<? super A, ? extends B> mapper) {
        B[] out = creator.apply(a.length);
        for (int i = 0; i < a.length; ++i) {
            out[i] = mapper.apply(a[i]);
        }
        return out;
    }

    public static <A, B, D> B[] map(A[] a, IntFunction<B[]> creator, D data, BiFunction<? super A, ? super D, ? extends B> mapper) {
        B[] out = creator.apply(a.length);
        for (int i = 0; i < a.length; ++i) {
            out[i] = mapper.apply(a[i], data);
        }
        return out;
    }

    public static <T> T[] combine(T[] a1, T[] a2, IntFunction<T[]> creator) {
        int a1Length = a1.length;
        int a2Length = a2.length;
        T[] out = creator.apply(a1Length + a2Length);
        System.arraycopy(a1, 0, out, 0, a1Length);
        System.arraycopy(a2, 0, out, a1Length, a2Length);
        return out;
    }

    public static <T> T[] combine(T[] a1, T[] a2) {
        T[] out = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, out, a1.length, a2.length);
        return out;
    }

    public static <T> T[] filter(T[] array, Predicate<? super T> predicate) {
        if (array.length == 0) {
            return array;
        }
        int count = 0;
        Object[] clone = (Object[])array.clone();
        for (T t : array) {
            if (!predicate.test(t)) continue;
            clone[count++] = t;
        }
        return Arrays.copyOf(clone, count);
    }

    public static <T> T[] copyAndAppend(T[] oldArray, T newEntry) {
        int length = oldArray.length;
        Object[] newArray = new Object[length + 1];
        System.arraycopy(oldArray, 0, newArray, 0, length);
        newArray[length] = newEntry;
        return newArray;
    }

    @FunctionalInterface
    public static interface DualForEach<A, B> {
        public void apply(A var1, B var2, int var3);
    }

    @FunctionalInterface
    public static interface IndexedMap<A, B> {
        public B apply(A var1, int var2);
    }
}

