/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.thr;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class HyphenException
extends RuntimeException {
    private final List<Entry> path = new ArrayList<Entry>();
    @Nullable
    private final String possibleSolution;

    public HyphenException() {
        this.possibleSolution = null;
    }

    public HyphenException(String message, @Nullable String possibleSolution) {
        super(message);
        this.possibleSolution = possibleSolution;
    }

    public HyphenException(Throwable cause, @Nullable String possibleSolution) {
        super(cause.getMessage(), cause);
        this.setStackTrace(cause.getStackTrace());
        this.possibleSolution = possibleSolution;
    }

    public static HyphenException thr(String type, String separator, Object clazz, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof HyphenException) {
            HyphenException exception = (HyphenException)throwable2;
            return exception.append(type, separator, clazz);
        }
        HyphenException exception = new HyphenException(throwable, null);
        exception.append(type, separator, clazz);
        return exception;
    }

    public HyphenException append(String type, String separator, Object clazz) {
        this.path.add(new Entry(type, separator, clazz));
        return this;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(this.niceException());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(this.niceException());
    }

    public String niceException() {
        StringBuilder sb = new StringBuilder("now handled as a \u001b[33m<$ Hyphen Fatal Exception $>\u001b[0m\n\n");
        ArrayList<Entry> main = new ArrayList<Entry>();
        main.add(new Entry(null, null, this.getMessage()));
        if (this.getCause() != null) {
            main.add(new Entry("cause: ", null, this.getCause().getClass().getSimpleName()));
        }
        new Group(this.getClass().getSimpleName() + " Reason", null, main).append(sb);
        if (this.possibleSolution != null) {
            new Group("Possible Solution", null, Collections.singletonList(new Entry(null, null, this.possibleSolution))).append(sb);
        }
        new Group("Path", "\u001b[41m", this.path).append(sb);
        new Group("Stacktrace", "\u001b[41m", Arrays.stream(this.getStackTrace()).map(Entry::create).collect(Collectors.toList())).append(sb);
        return sb.toString();
    }

    public record Entry(String type, String separator, Object object) {
        public static Entry create(StackTraceElement object) {
            return new Entry((object.isNativeMethod() ? "native" : "java") + ":" + object.getLineNumber(), "\u239f", object);
        }
    }

    public record Group(String name, String topBackground, List<Entry> entries) {
        public void append(StringBuilder sb) {
            sb.append('\t').append("\u001b[32m").append(this.name).append("\u001b[0m").append('\n');
            boolean first = true;
            for (Entry entry : this.entries) {
                String path = " \u2191  ";
                Object style = "\u001b[0m";
                String accents = "\u001b[35m";
                if (first) {
                    path = " -> ";
                    if (this.topBackground != null) {
                        style = "\u001b[30m" + this.topBackground;
                        accents = "\u001b[30m";
                    }
                }
                sb.append("\t\t").append((String)style).append(accents).append(path);
                if (entry.type != null) {
                    sb.append((String)style).append(entry.type);
                }
                if (entry.separator != null) {
                    sb.append(accents).append(' ').append(entry.separator).append(' ');
                }
                sb.append((String)style).append(entry.object);
                sb.append("\u001b[0m").append('\n');
                first = false;
            }
            sb.append('\n');
        }
    }
}

