/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.scan.type;

import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.scan.Clazzifier;
import dev.quantumfusion.hyphen.scan.Direction;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.util.ScanUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayClazz
extends Clazz {
    public final Clazz component;

    public ArrayClazz(SerializerHandler<?, ?> handler, @NotNull Class<?> aClass, Map<Class<? extends Annotation>, Object> annotations, Clazz component) {
        super(handler, aClass, annotations);
        this.component = component;
    }

    public static ArrayClazz create(SerializerHandler<?, ?> handler, AnnotatedType array, @Nullable Clazz ctx, Direction dir) {
        if (dir == Direction.SUB) {
            Clazz clazz = ctx;
            if (clazz instanceof ArrayClazz) {
                ArrayClazz arrayClazz = (ArrayClazz)clazz;
            } else {
                throw new IllegalArgumentException();
            }
        }
        Clazz component = Clazzifier.create(handler, ArrayClazz.getAnnotatedGenericComponentType(array), ctx, dir);
        return new ArrayClazz(handler, (Class<?>)component.getBytecodeClass().arrayType(), ScanUtil.acquireAnnotations(handler, array, ctx), component);
    }

    private static AnnotatedType getAnnotatedGenericComponentType(AnnotatedType array) {
        AnnotatedType annotatedType = array;
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
            return annotatedArrayType.getAnnotatedGenericComponentType();
        }
        annotatedType = array;
        if (annotatedType instanceof ScanUtil.FieldAnnotatedType) {
            ScanUtil.FieldAnnotatedType fieldAnnotatedType = (ScanUtil.FieldAnnotatedType)annotatedType;
            return ArrayClazz.getAnnotatedGenericComponentType(fieldAnnotatedType.annotatedType());
        }
        return ScanUtil.wrap((Type)((Object)ScanUtil.getClassFrom(array).componentType()));
    }

    @Override
    public int defined() {
        return 1 + this.component.defined();
    }

    @Override
    public String toString() {
        StringJoiner annotationJoiner = new StringJoiner("_", "<", ">");
        this.annotations.forEach((aClass1, value) -> annotationJoiner.add("@" + aClass1.getSimpleName() + value));
        return this.component.toString() + "_" + annotationJoiner;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayClazz that = (ArrayClazz)o;
        return Objects.equals(this.component, that.component) && Objects.equals(this.annotations, that.annotations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.component);
    }
}

