/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.scan;

import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.scan.Direction;
import dev.quantumfusion.hyphen.scan.type.ArrayClazz;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.scan.type.ParaClazz;
import dev.quantumfusion.hyphen.scan.type.TypeClazz;
import dev.quantumfusion.hyphen.thr.HyphenException;
import dev.quantumfusion.hyphen.util.ScanUtil;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Clazzifier {
    public static Clazz create(SerializerHandler<?, ?> handler, @NotNull Type type, @Nullable Clazz ctx, Direction dir) {
        return Clazzifier.create(handler, ScanUtil.wrap(type), ctx, dir);
    }

    public static Clazz create(SerializerHandler<?, ?> handler, @NotNull AnnotatedType annotatedType, @Nullable Clazz ctx, Direction dir) {
        try {
            Class c;
            Type type = annotatedType.getType();
            if (type instanceof ParameterizedType) {
                return ParaClazz.create(handler, annotatedType, ctx, dir);
            }
            if (type instanceof GenericArrayType) {
                return ArrayClazz.create(handler, annotatedType, ctx, dir);
            }
            if (type instanceof WildcardType) {
                return Clazzifier.create(handler, ((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds()[0], ctx, dir);
            }
            if (type instanceof TypeVariable) {
                return TypeClazz.create(handler, annotatedType, ctx);
            }
            Type type2 = type;
            if (type2 instanceof Class && (c = (Class)type2).getTypeParameters().length > 0) {
                return ParaClazz.create(handler, annotatedType, ctx, dir);
            }
            type2 = type;
            if (type2 instanceof Class && (c = (Class)type2).isArray()) {
                return ArrayClazz.create(handler, annotatedType, ctx, dir);
            }
            if (type instanceof Class) {
                return Clazz.create(handler, annotatedType, ctx);
            }
            throw new RuntimeException("Can not handle: " + annotatedType.getClass().getSimpleName());
        }
        catch (Throwable throwable) {
            throw HyphenException.thr("class", ":", annotatedType, throwable);
        }
    }
}

