/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.io;

import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.io.IOInterface;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public final class ByteBufferIO
implements IOInterface {
    private final ByteBuffer byteBuffer;

    private ByteBufferIO(ByteBuffer buffer) {
        this.byteBuffer = buffer;
    }

    public static final ByteBufferIO wrap(ByteBuffer byteBuffer) {
        return new ByteBufferIO(byteBuffer.order(ByteOrder.LITTLE_ENDIAN));
    }

    public static final ByteBufferIO create(int size) {
        return ByteBufferIO.wrap(ByteBuffer.allocate(size));
    }

    public static final ByteBufferIO createDirect(int size) {
        return ByteBufferIO.wrap(ByteBuffer.allocateDirect(size));
    }

    public static final <O> ByteBufferIO create(HyphenSerializer<ByteBufferIO, O> serializer, O data) {
        return ByteBufferIO.create(serializer.measure(data));
    }

    public static final <O> ByteBufferIO createDirect(HyphenSerializer<ByteBufferIO, O> serializer, O data) {
        return ByteBufferIO.createDirect(serializer.measure(data));
    }

    @Override
    public final void rewind() {
        this.byteBuffer.rewind();
    }

    @Override
    public final int pos() {
        return this.byteBuffer.position();
    }

    @Override
    public final void close() {
        this.byteBuffer.clear();
    }

    @Override
    public final boolean getBoolean() {
        return this.byteBuffer.get() == 1;
    }

    @Override
    public final byte getByte() {
        return this.byteBuffer.get();
    }

    @Override
    public final char getChar() {
        return this.byteBuffer.getChar();
    }

    @Override
    public final short getShort() {
        return this.byteBuffer.getShort();
    }

    @Override
    public final int getInt() {
        return this.byteBuffer.getInt();
    }

    @Override
    public final long getLong() {
        return this.byteBuffer.getLong();
    }

    @Override
    public final float getFloat() {
        return this.byteBuffer.getFloat();
    }

    @Override
    public final double getDouble() {
        return this.byteBuffer.getDouble();
    }

    @Override
    public final String getString() {
        int length = this.getInt();
        byte[] byteArray = this.getByteArray(length);
        return new String(byteArray, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public final void putBoolean(boolean value) {
        this.byteBuffer.put((byte)(value ? 1 : 0));
    }

    @Override
    public final void putByte(byte value) {
        this.byteBuffer.put(value);
    }

    @Override
    public final void putChar(char value) {
        this.byteBuffer.putChar(value);
    }

    @Override
    public final void putShort(short value) {
        this.byteBuffer.putShort(value);
    }

    @Override
    public final void putInt(int value) {
        this.byteBuffer.putInt(value);
    }

    @Override
    public final void putLong(long value) {
        this.byteBuffer.putLong(value);
    }

    @Override
    public final void putFloat(float value) {
        this.byteBuffer.putFloat(value);
    }

    @Override
    public final void putDouble(double value) {
        this.byteBuffer.putDouble(value);
    }

    @Override
    public final void putString(String value) {
        byte[] array = value.getBytes(StandardCharsets.UTF_8);
        int length = array.length;
        this.putInt(length);
        this.putByteArray(array, length);
    }

    @Override
    public final boolean[] getBooleanArray(int length) {
        boolean[] out = new boolean[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.get() == 1;
        }
        return out;
    }

    @Override
    public final byte[] getByteArray(int length) {
        byte[] out = new byte[length];
        this.byteBuffer.get(out, 0, length);
        return out;
    }

    @Override
    public final char[] getCharArray(int length) {
        char[] out = new char[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getChar();
        }
        return out;
    }

    @Override
    public final short[] getShortArray(int length) {
        short[] out = new short[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getShort();
        }
        return out;
    }

    @Override
    public final int[] getIntArray(int length) {
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getInt();
        }
        return out;
    }

    @Override
    public final long[] getLongArray(int length) {
        long[] out = new long[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getLong();
        }
        return out;
    }

    @Override
    public final float[] getFloatArray(int length) {
        float[] out = new float[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getFloat();
        }
        return out;
    }

    @Override
    public final double[] getDoubleArray(int length) {
        double[] out = new double[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.byteBuffer.getDouble();
        }
        return out;
    }

    @Override
    public final String[] getStringArray(int length) {
        String[] out = new String[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getString();
        }
        return out;
    }

    @Override
    public final void putBooleanArray(boolean[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.put((byte)(value[i] ? 1 : 0));
        }
    }

    @Override
    public final void putByteArray(byte[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.put(value[i]);
        }
    }

    @Override
    public final void putCharArray(char[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putChar(value[i]);
        }
    }

    @Override
    public final void putShortArray(short[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putShort(value[i]);
        }
    }

    @Override
    public final void putIntArray(int[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putInt(value[i]);
        }
    }

    @Override
    public final void putLongArray(long[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putLong(value[i]);
        }
    }

    @Override
    public final void putFloatArray(float[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putFloat(value[i]);
        }
    }

    @Override
    public final void putDoubleArray(double[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.byteBuffer.putDouble(value[i]);
        }
    }

    @Override
    public final void putStringArray(String[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putString(value[i]);
        }
    }
}

