/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.io;

import dev.quantumfusion.hyphen.HyphenSerializer;
import dev.quantumfusion.hyphen.io.IOInterface;
import java.nio.charset.StandardCharsets;

public final class ArrayIO
implements IOInterface {
    private final byte[] bytes;
    private int pos;

    private ArrayIO(byte[] bytes, int pos) {
        this.bytes = bytes;
        this.pos = pos;
    }

    public static final ArrayIO create(int size) {
        return new ArrayIO(new byte[size], 0);
    }

    public static final <O> ArrayIO create(HyphenSerializer<ArrayIO, O> serializer, O data) {
        return ArrayIO.create(serializer.measure(data));
    }

    public static final ArrayIO wrap(byte[] array) {
        return new ArrayIO(array, 0);
    }

    @Override
    public final void rewind() {
        this.pos = 0;
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    @Override
    public final void close() {
    }

    public final byte[] export() {
        return this.bytes;
    }

    @Override
    public final boolean getBoolean() {
        return this.getByte() != 0;
    }

    @Override
    public final byte getByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public final char getChar() {
        char c = (char)(this.bytes[this.pos] & 0xFF | (this.bytes[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return c;
    }

    @Override
    public final short getShort() {
        short c = (short)(this.bytes[this.pos] & 0xFF | (this.bytes[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return c;
    }

    @Override
    public final int getInt() {
        int result = this.bytes[this.pos] & 0xFF | (this.bytes[this.pos + 1] & 0xFF) << 8 | (this.bytes[this.pos + 2] & 0xFF) << 16 | (this.bytes[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return result;
    }

    @Override
    public final long getLong() {
        long result = (long)(this.bytes[this.pos] & 0xFF | (this.bytes[this.pos + 1] & 0xFF) << 8 | (this.bytes[this.pos + 2] & 0xFF) << 16) | (long)(this.bytes[this.pos + 3] & 0xFF) << 24 | (long)(this.bytes[this.pos + 4] & 0xFF) << 32 | (long)(this.bytes[this.pos + 5] & 0xFF) << 40 | (long)(this.bytes[this.pos + 6] & 0xFF) << 48 | (long)(this.bytes[this.pos + 7] & 0xFF) << 56;
        this.pos += 8;
        return result;
    }

    @Override
    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public final String getString() {
        int length = this.getInt();
        byte[] byteArray = this.getByteArray(length);
        return new String(byteArray, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public final void putBoolean(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    @Override
    public final void putByte(byte value) {
        this.bytes[this.pos++] = value;
    }

    @Override
    public final void putChar(char value) {
        this.bytes[this.pos] = (byte)value;
        this.bytes[this.pos + 1] = (byte)(value >>> 8);
        this.pos += 2;
    }

    @Override
    public final void putShort(short value) {
        this.bytes[this.pos] = (byte)value;
        this.bytes[this.pos + 1] = (byte)(value >>> 8);
        this.pos += 2;
    }

    @Override
    public final void putInt(int value) {
        this.bytes[this.pos] = (byte)value;
        this.bytes[this.pos + 1] = (byte)(value >>> 8);
        this.bytes[this.pos + 2] = (byte)(value >>> 16);
        this.bytes[this.pos + 3] = (byte)(value >>> 24);
        this.pos += 4;
    }

    @Override
    public final void putLong(long value) {
        int low = (int)value;
        int high = (int)(value >>> 32);
        this.bytes[this.pos] = (byte)low;
        this.bytes[this.pos + 1] = (byte)(low >>> 8);
        this.bytes[this.pos + 2] = (byte)(low >>> 16);
        this.bytes[this.pos + 3] = (byte)(low >>> 24);
        this.bytes[this.pos + 4] = (byte)high;
        this.bytes[this.pos + 5] = (byte)(high >>> 8);
        this.bytes[this.pos + 6] = (byte)(high >>> 16);
        this.bytes[this.pos + 7] = (byte)(high >>> 24);
        this.pos += 8;
    }

    @Override
    public final void putFloat(float value) {
        this.putInt(Float.floatToIntBits(value));
    }

    @Override
    public final void putDouble(double value) {
        this.putLong(Double.doubleToLongBits(value));
    }

    @Override
    public final void putString(String value) {
        byte[] array = value.getBytes(StandardCharsets.UTF_8);
        int length = array.length;
        this.putInt(length);
        this.putByteArray(array, length);
    }

    @Override
    public final boolean[] getBooleanArray(int length) {
        boolean[] out = new boolean[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getByte() == 1;
        }
        return out;
    }

    @Override
    public final byte[] getByteArray(int length) {
        byte[] out = new byte[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getByte();
        }
        return out;
    }

    @Override
    public final char[] getCharArray(int length) {
        char[] out = new char[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getChar();
        }
        return out;
    }

    @Override
    public final short[] getShortArray(int length) {
        short[] out = new short[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getShort();
        }
        return out;
    }

    @Override
    public final int[] getIntArray(int length) {
        int[] out = new int[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getInt();
        }
        return out;
    }

    @Override
    public final long[] getLongArray(int length) {
        long[] out = new long[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getLong();
        }
        return out;
    }

    @Override
    public final float[] getFloatArray(int length) {
        float[] out = new float[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getFloat();
        }
        return out;
    }

    @Override
    public final double[] getDoubleArray(int length) {
        double[] out = new double[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getDouble();
        }
        return out;
    }

    @Override
    public final String[] getStringArray(int length) {
        String[] out = new String[length];
        for (int i = 0; i < length; ++i) {
            out[i] = this.getString();
        }
        return out;
    }

    @Override
    public final void putBooleanArray(boolean[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putByte((byte)(value[i] ? 1 : 0));
        }
    }

    @Override
    public final void putByteArray(byte[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putByte(value[i]);
        }
    }

    @Override
    public final void putCharArray(char[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putChar(value[i]);
        }
    }

    @Override
    public final void putShortArray(short[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putShort(value[i]);
        }
    }

    @Override
    public final void putIntArray(int[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putInt(value[i]);
        }
    }

    @Override
    public final void putLongArray(long[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putLong(value[i]);
        }
    }

    @Override
    public final void putFloatArray(float[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putFloat(value[i]);
        }
    }

    @Override
    public final void putDoubleArray(double[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putDouble(value[i]);
        }
    }

    @Override
    public final void putStringArray(String[] value, int length) {
        for (int i = 0; i < length; ++i) {
            this.putString(value[i]);
        }
    }
}

