/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.hyphen.codegen.def;

import dev.quantumfusion.hyphen.SerializerHandler;
import dev.quantumfusion.hyphen.codegen.MethodHandler;
import dev.quantumfusion.hyphen.codegen.Variable;
import dev.quantumfusion.hyphen.codegen.def.MethodDef;
import dev.quantumfusion.hyphen.codegen.def.SerializerDef;
import dev.quantumfusion.hyphen.codegen.statement.If;
import dev.quantumfusion.hyphen.codegen.statement.TableSwitch;
import dev.quantumfusion.hyphen.scan.type.Clazz;
import dev.quantumfusion.hyphen.util.ArrayUtil;
import dev.quantumfusion.hyphen.util.GenUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

public final class SubclassDef
extends MethodDef {
    private final Class<?>[] subClasses;
    private SerializerDef[] subDefs;
    private boolean allSameStaticSize;

    public SubclassDef(SerializerHandler<?, ?> handler, Clazz clazz, Class<?>[] subClasses) {
        super(handler, clazz, "SUB{ # " + Arrays.stream(subClasses).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "}");
        this.subClasses = subClasses;
    }

    @Override
    public void scan(SerializerHandler<?, ?> handler, Clazz clazz) {
        this.subDefs = ArrayUtil.map(this.subClasses, SerializerDef[]::new, subclass -> handler.acquireDef(clazz.asSub((Class<?>)subclass)));
        int size = this.subDefs[0].getStaticSize();
        for (int i = 1; i < this.subDefs.length; ++i) {
            if (size == this.subDefs[i].getStaticSize()) continue;
            this.allSameStaticSize = false;
            return;
        }
        this.allSameStaticSize = true;
    }

    @Override
    protected void writeMethodGet(MethodHandler mh) {
        mh.loadIO();
        mh.getIO(Byte.TYPE);
        try (TableSwitch tableSwitch = new TableSwitch(mh, 0, this.subDefs.length);){
            tableSwitch.labels(value -> {
                this.subDefs[value].writeGet(mh);
                mh.op(176);
            });
            tableSwitch.defaultLabel();
        }
        mh.op(1);
    }

    @Override
    protected void writeMethodPut(MethodHandler mh, Runnable valueLoad) {
        this.ifChainClasses(mh, valueLoad, (clz, serializerDef, i) -> {
            mh.loadIO();
            mh.visitLdcInsn(i);
            mh.putIO(Byte.TYPE);
            serializerDef.writePut(mh, () -> {
                valueLoad.run();
                GenUtil.shouldCastGeneric(mh, clz, this.clazz.getBytecodeClass());
            });
            mh.op(177);
        });
    }

    @Override
    protected void writeMethodMeasure(MethodHandler mh, Runnable valueLoad) {
        this.ifChainClasses(mh, valueLoad, (clz, serializerDef, i) -> {
            if (serializerDef.hasDynamicSize()) {
                serializerDef.writeMeasure(mh, () -> {
                    valueLoad.run();
                    GenUtil.shouldCastGeneric(mh, clz, this.clazz.getBytecodeClass());
                });
            }
            int ss = serializerDef.getStaticSize();
            if (!this.allSameStaticSize && ss != 0) {
                mh.visitLdcInsn(ss);
                if (serializerDef.hasDynamicSize()) {
                    mh.op(96);
                }
            } else if (!serializerDef.hasDynamicSize()) {
                mh.op(3);
            }
            mh.op(172);
        });
        mh.op(3);
    }

    private void ifChainClasses(MethodHandler mh, Runnable valueLoad, ArrayUtil.DualForEach<Class<?>, SerializerDef> action) {
        Variable clz = mh.addVar("clz", Class.class);
        valueLoad.run();
        mh.callInst(182, Object.class, "getClass", Class.class, new Class[0]);
        mh.varOp(54, clz);
        ArrayUtil.dualForEach(this.subClasses, this.subDefs, (aClass, serializerDef, i) -> {
            mh.varOp(21, clz);
            mh.visitLdcInsn(Type.getType((Class)aClass));
            try (If f = new If(mh, 166);){
                action.apply((Class<?>)aClass, (SerializerDef)serializerDef, i);
            }
        });
    }

    @Override
    public int getStaticSize() {
        if (this.subDefs.length == 0) {
            return 0;
        }
        if (this.allSameStaticSize) {
            return this.subDefs[0].getStaticSize() + 1;
        }
        return 1;
    }

    @Override
    public boolean hasDynamicSize() {
        if (this.subDefs.length == 0) {
            return false;
        }
        if (!this.allSameStaticSize) {
            return true;
        }
        for (SerializerDef subDef : this.subDefs) {
            if (!subDef.hasDynamicSize()) continue;
            return true;
        }
        return false;
    }
}

